<div class="theme-offer">
	<?php 
        // Check if the demo import has been completed
        $vw_real_estate_demo_import_completed = get_option('vw_real_estate_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($vw_real_estate_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'vw-real-estate') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'vw-real-estate') . '</a></span>';
        }

		//POST and update the customizer and other related data
        if (isset($_POST['submit'])) {

            // Check if ibtana visual editor is installed and activated
            if (!is_plugin_active('ibtana-visual-editor/plugin.php')) {
              // Install the plugin if it doesn't exist
              $vw_real_estate_plugin_slug = 'ibtana-visual-editor';
              $vw_real_estate_plugin_file = 'ibtana-visual-editor/plugin.php';

              // Check if plugin is installed
              $vw_real_estate_installed_plugins = get_plugins();
              if (!isset($vw_real_estate_installed_plugins[$vw_real_estate_plugin_file])) {
                  include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                  include_once(ABSPATH . 'wp-admin/includes/file.php');
                  include_once(ABSPATH . 'wp-admin/includes/misc.php');
                  include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

                  // Install the plugin
                  $vw_real_estate_upgrader = new Plugin_Upgrader();
                  $vw_real_estate_upgrader->install('https://downloads.wordpress.org/plugin/ibtana-visual-editor.latest-stable.zip');
              }
              // Activate the plugin
              activate_plugin($vw_real_estate_plugin_file);
            }

            // ------- Create Nav Menu --------
            $vw_real_estate_menuname = 'Main Menus';
            $vw_real_estate_bpmenulocation = 'primary';
            $vw_real_estate_menu_exists = wp_get_nav_menu_object($vw_real_estate_menuname);

            if (!$vw_real_estate_menu_exists) {
                $vw_real_estate_menu_id = wp_create_nav_menu($vw_real_estate_menuname);

                // Create Home Page
                $vw_real_estate_home_title = 'Home';
                $vw_real_estate_home = array(
                    'post_type' => 'page',
                    'post_title' => $vw_real_estate_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $vw_real_estate_home_id = wp_insert_post($vw_real_estate_home);
                // Assign Home Page Template
                add_post_meta($vw_real_estate_home_id, '_wp_page_template', 'page-template/custom-home-page.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $vw_real_estate_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($vw_real_estate_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'vw-real-estate'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_real_estate_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $vw_real_estate_pages_title = 'Pages';
                $vw_real_estate_pages_content = '
                <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>

                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                  All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_real_estate_pages = array(
                    'post_type' => 'page',
                    'post_title' => $vw_real_estate_pages_title,
                    'post_content' => $vw_real_estate_pages_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'pages'
                );
                $vw_real_estate_pages_id = wp_insert_post($vw_real_estate_pages);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($vw_real_estate_menu_id, 0, array(
                    'menu-item-title' => __('Pages', 'vw-real-estate'),
                    'menu-item-classes' => 'pages',
                    'menu-item-url' => home_url('/pages/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_real_estate_pages_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create About Us Page with Dummy Content
                $vw_real_estate_about_title = 'About Us';
                $vw_real_estate_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

                         Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                            There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                            All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_real_estate_about = array(
                    'post_type' => 'page',
                    'post_title' => $vw_real_estate_about_title,
                    'post_content' => $vw_real_estate_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $vw_real_estate_about_id = wp_insert_post($vw_real_estate_about);
                // Add About Us Page to Menu
                wp_update_nav_menu_item($vw_real_estate_menu_id, 0, array(
                    'menu-item-title' => __('About Us', 'vw-real-estate'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_real_estate_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Set the menu location if it's not already set
                if (!has_nav_menu($vw_real_estate_bpmenulocation)) {
                    $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($locations)) {
                        $locations = array();
                    }
                    $locations[$vw_real_estate_bpmenulocation] = $vw_real_estate_menu_id;
                    set_theme_mod('nav_menu_locations', $locations);
                }               
        }

         
            // Set the demo import completion flag
    		update_option('vw_real_estate_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'vw-real-estate') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'vw-real-estate') . '</a></span>';
            //end 


            // Top Bar //
            set_theme_mod( 'vw_construction_estate_location_icon', 'fas fa-map-marker-alt' );  
            set_theme_mod( 'vw_construction_estate_location', 'Get Direction' );
            set_theme_mod( 'vw_construction_estate_location1', 'Lorem Ipsum is simply dummy text' );    
            set_theme_mod( 'vw_construction_estate_call1', '0123456789' ); 
            set_theme_mod( 'vw_construction_estate_email_icon', 'far fa-envelope-open' );
            set_theme_mod( 'vw_construction_estate_mail', 'Drop Us a line' );  
            set_theme_mod( 'vw_construction_estate_mail1', 'support@example.com' );


            // slider section start //  
            set_theme_mod( 'vw_construction_estate_slider_button_text', 'LEARN MORE' );    
            set_theme_mod( 'vw_construction_estate_top_button_url', '#' );

            for($vw_construction_estate_i=1;$vw_construction_estate_i<=3;$vw_construction_estate_i++){
               $vw_construction_estate_slider_title = 'Contrary to popular belief Lorem Ipsum';
               $vw_construction_estate_slider_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.';
                  // Create post object
               $my_post = array(
               'post_title'    => wp_strip_all_tags( $vw_construction_estate_slider_title ),
               'post_content'  => $vw_construction_estate_slider_content,
               'post_status'   => 'publish',
               'post_type'     => 'page',
               );

               // Insert the post into the database
               $vw_construction_estate_post_id = wp_insert_post( $my_post );

               if ($vw_construction_estate_post_id) {
                 // Set the theme mod for the slider page
                 set_theme_mod('vw_construction_estate_slider_page' . $vw_construction_estate_i, $vw_construction_estate_post_id);

                  $vw_construction_estate_image_url = get_theme_file_uri().'/images/slider'.$vw_construction_estate_i.'.png';

                $vw_construction_estate_image_id = media_sideload_image($vw_construction_estate_image_url, $vw_construction_estate_post_id, null, 'id');

                    if (!is_wp_error($vw_construction_estate_image_id)) {
                        // Set the downloaded image as the post's featured image
                        set_post_thumbnail($vw_construction_estate_post_id, $vw_construction_estate_image_id);
                    }
                }
            } 

            // Consultant Section //
            set_theme_mod( 'vw_construction_estate_contact_number_icon', 'fas fa-phone-square' );
            set_theme_mod( 'vw_construction_estate_contact_number', '0123456789' );
            set_theme_mod( 'vw_construction_estate_contact_title', 'LOREM IPSUM DOLOR SIT AMET' );   
            set_theme_mod( 'vw_construction_estate_contact_content', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard' );
            set_theme_mod( 'vw_construction_estate_contact_text', 'CONTACT US NOW' );
            set_theme_mod( 'vw_construction_estate_contact_link', '#' );
            set_theme_mod( 'vw_construction_estate_contact_text_icon', 'fas fa-arrow-right' ); 

            // About Section //
            set_theme_mod( 'vw_construction_estate_about_button_text', 'DISCOVER MORE' );

            // Define post title and content
             $vw_construction_estate_post_title = 'WELCOME TO OUR COMPANY!';
             $vw_construction_estate_post_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.';
 
             // Create post object
             $vw_construction_estate_my_post = array(
                 'post_title'    => wp_strip_all_tags($vw_construction_estate_post_title),
                 'post_content'  => $vw_construction_estate_post_content,
                 'post_status'   => 'publish',
                 'post_type'     => 'post',
             );
 
             // Insert the post into the database
             $vw_construction_estate_post_id = wp_insert_post($vw_construction_estate_my_post);
 
             // Check if the post was successfully created
             if (!is_wp_error($vw_construction_estate_post_id)) {
                // Set the theme mod for the post ID
                set_theme_mod('vw_construction_estate_about_setting', $vw_construction_estate_post_id);

                // Fetch the image URL
                 $vw_construction_estate_image_url = get_theme_file_uri() . '/images/about.png';
 
                 // Media sideload the image
                 $vw_construction_estate_image_id = media_sideload_image($vw_construction_estate_image_url, $vw_construction_estate_post_id, null, 'id');
 
                 // Check if the image was successfully uploaded
                 if (!is_wp_error($vw_construction_estate_image_id)) {
                     // Set the downloaded image as the post's featured image
                     set_post_thumbnail($vw_construction_estate_post_id, $vw_construction_estate_image_id);
                 } else {
                     // Handle the error if the image upload failed
                     error_log('Image upload failed: ' . $vw_construction_estate_image_id->get_error_message());
                 }
                
             } else {
                 // Handle the error if the post creation failed
                 error_log('Post creation failed: ' . $vw_construction_estate_post_id->get_error_message());             
            }

            // Service Section //
            set_theme_mod( 'vw_real_estate_section_text', 'CATEGORIES' );
            set_theme_mod( 'vw_real_estate_section_title', 'Browse By Category' );
            set_theme_mod('vw_real_estate_category', 'category1');

            // Define post category names and post titles
            $vw_real_estate_category_names = array('category1', 'category2');
            $vw_real_estate_title_array = array(
                array("Lorem Ipsum 1", "Lorem Ipsum 2", "Lorem Ipsum 3"),
                array("Lorem Ipsum 1", "Lorem Ipsum 2", "Lorem Ipsum 3")
            );

            foreach ($vw_real_estate_category_names as $vw_real_estate_index => $vw_real_estate_category_name) {
                // Create or retrieve the post category term ID
                $vw_real_estate_term = term_exists($vw_real_estate_category_name, 'category');
                if ($vw_real_estate_term === 0 || $vw_real_estate_term === null) {
                    // If the term does not exist, create it
                    $vw_real_estate_term = wp_insert_term($vw_real_estate_category_name, 'category');
                }
                if (is_wp_error($vw_real_estate_term)) {
                    error_log('Error creating category: ' . $vw_real_estate_term->get_error_message());
                    continue; // Skip to the next iteration if category creation fails
                }

                for ($vw_real_estate_i = 0; $vw_real_estate_i < 3; $vw_real_estate_i++) {
                    // Create post content
                    $vw_real_estate_title = $vw_real_estate_title_array[$vw_real_estate_index][$vw_real_estate_i];
                    $vw_real_estate_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting';

                    // Create post post object
                    $vw_real_estate_my_post = array(
                        'post_title'    => wp_strip_all_tags($vw_real_estate_title),
                        'post_content'  => $vw_real_estate_content,
                        'post_status'   => 'publish',
                        'post_type'     => 'post', // Post type set to 'post'
                    );

                    // Insert the post into the database
                    $vw_real_estate_post_id = wp_insert_post($vw_real_estate_my_post);

                    if (is_wp_error($vw_real_estate_post_id)) {
                        error_log('Error creating post: ' . $vw_real_estate_post_id->get_error_message());
                        continue; // Skip to the next post if creation fails
                    }

                    // Assign the category to the post
                    wp_set_post_categories($vw_real_estate_post_id, array((int)$vw_real_estate_term['term_id']));

                    // Handle the featured image using media_sideload_image
                    $vw_real_estate_image_url = get_theme_file_uri() . '/images/category' . ($vw_real_estate_i + 1) . '.png';
                    $vw_real_estate_image_id = media_sideload_image($vw_real_estate_image_url, $vw_real_estate_post_id, null, 'id');

                    if (is_wp_error($vw_real_estate_image_id)) {
                        error_log('Error downloading image: ' . $vw_real_estate_image_id->get_error_message());
                        continue; // Skip to the next post if image download fails
                    }
                    // Assign featured image to post
                    set_post_thumbnail($vw_real_estate_post_id, $vw_real_estate_image_id);
                }
            } 
  
            //Copyright Text
            set_theme_mod( 'vw_construction_estate_footer_text', 'By VWThemes' );  
     
        }
    ?>


    <p><?php esc_html_e('Please back up your website if it’s already live with data. This importer will overwrite your existing settings with the new customizer values for VW Real Estate', 'vw-real-estate'); ?></p>
    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=vw_real_estate_guide" method="POST" onsubmit="return validate(this);">
        <?php if (!get_option('vw_real_estate_demo_import_completed')) : ?>
            <input class="run-import" type="submit" name="submit" value="<?php esc_attr_e('Run Importer', 'vw-real-estate'); ?>" class="button button-primary button-large">
        <?php endif; ?>
        <div id="spinner" style="display:none;">         
            <img src="<?php echo esc_url(get_theme_file_uri()); ?>/images/spinner.png" alt="" />
        </div>
    </form>
    <script type="text/javascript">
        function validate(form) {
            if (confirm("Do you really want to import the theme demo content?")) {
                // Show the spinner
                document.getElementById('spinner').style.display = 'block';
                // Allow the form to be submitted
                return true;
            } 
            else {
                return false;
            }
        }
    </script>
</div>

