<?php
/**
 * VW Real Estate: Block Patterns
 *
 * @package VW Real Estate
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {
	register_block_pattern_category(
		'vw-real-estate',
		array( 'label' => __( 'VW Real Estate', 'vw-real-estate' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'vw-real-estate/banner-section',
		array(
			'title'      => __( 'Banner Section', 'vw-real-estate' ),
			'categories' => array( 'vw-real-estate' ),
			'content'    => "<!-- wp:cover {\"customGradient\":\"linear-gradient(120deg,rgb(255,255,255) 47%,rgb(15,63,208) 47%)\",\"align\":\"full\",\"className\":\"outer-banner-sec p-lg-5\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim has-background-gradient outer-banner-sec p-lg-5\" style=\"background:linear-gradient(120deg,rgb(255,255,255) 47%,rgb(15,63,208) 47%)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:cover {\"url\":\"" . get_theme_file_uri() . "/inc/block-patterns/images/banner.png\",\"id\":9923,\"minHeight\":650,\"align\":\"wide\",\"className\":\"banner-sec mx-0\"} -->\n<div class=\"wp-block-cover alignwide has-background-dim banner-sec mx-0\" style=\"background-image:url(" . get_theme_file_uri() . "/inc/block-patterns/images/banner.png);min-height:650px\"><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"wide\",\"className\":\"m-0\"} -->\n<div class=\"wp-block-columns alignwide m-0\"><!-- wp:column {\"width\":\"25%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"className\":\"px-lg-5\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center px-lg-5\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":1,\"className\":\"text-center\",\"style\":{\"typography\":{\"fontSize\":70}}} -->\n<h1 class=\"has-text-align-center text-center\" style=\"font-size:70px\">Contrary to popular belief  Lorem Ipsum</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":15}}} -->\n<p class=\"has-text-align-center text-center has-white-color has-text-color\" style=\"font-size:15px\">Lorem Ipsum has been the industrys standard.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"style\":{\"color\":{\"background\":\"#f8af12\"}},\"textColor\":\"white\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-white-color has-text-color has-background no-border-radius\" style=\"background-color:#f8af12\">LEARN MORE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'vw-real-estate/category-section',
		array(
			'title'      => __( 'Category Section', 'vw-real-estate' ),
			'categories' => array( 'vw-real-estate' ),
			'content'    => "<!-- wp:cover {\"overlayColor\":\"white\",\"align\":\"wide\",\"className\":\"category-sec mx-0 p-4 mb-2\"} -->\n<div class=\"wp-block-cover alignwide has-white-background-color has-background-dim category-sec mx-0 p-4 mb-2\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"text-center mb-1\",\"style\":{\"color\":{\"text\":\"#4d546b\"},\"typography\":{\"fontSize\":18}}} -->\n<h3 class=\"has-text-align-center text-center mb-1 has-text-color\" style=\"color:#4d546b;font-size:18px\">CATEGORIES</h3>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"className\":\"text-center\",\"style\":{\"typography\":{\"fontSize\":35},\"color\":{\"text\":\"#222222\"}}} -->\n<h2 class=\"has-text-align-center text-center has-text-color\" style=\"color:#222222;font-size:35px\">Browse By Category</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"align\":\"wide\",\"className\":\"mx-0\"} -->\n<div class=\"wp-block-columns alignwide mx-0\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"category-box\"} -->\n<div class=\"wp-block-group category-box\"><div class=\"wp-block-group__inner-container\"><!-- wp:image {\"id\":9887,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"" . get_theme_file_uri() . "/inc/block-patterns/images/cat-image1.png\" alt=\"\" class=\"wp-image-9887\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"className\":\"category-inner-box px-3 py-1\"} -->\n<div class=\"wp-block-group category-inner-box px-3 py-1\"><div class=\"wp-block-group__inner-container\"><!-- wp:columns {\"className\":\"title-content mb-0\"} -->\n<div class=\"wp-block-columns title-content mb-0\"><!-- wp:column {\"width\":\"70%\",\"className\":\"title\"} -->\n<div class=\"wp-block-column title\" style=\"flex-basis:70%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"className\":\"mt-3 mb-0\",\"fontSize\":\"medium\",\"style\":{\"color\":{\"text\":\"#222222\"}}} -->\n<h4 class=\"has-text-align-left mt-3 mb-0 has-text-color has-medium-font-size\" style=\"color:#222222\">Category Title 1</h4>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"className\":\"btn ms-0\"} -->\n<div class=\"wp-block-column btn ms-0\" style=\"flex-basis:20%\"><!-- wp:buttons {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-buttons mb-0\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\"></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"category-box\"} -->\n<div class=\"wp-block-group category-box\"><div class=\"wp-block-group__inner-container\"><!-- wp:image {\"id\":9888,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"" . get_theme_file_uri() . "/inc/block-patterns/images/cat-image2.png\" alt=\"\" class=\"wp-image-9888\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"className\":\"category-inner-box px-3 py-1\"} -->\n<div class=\"wp-block-group category-inner-box px-3 py-1\"><div class=\"wp-block-group__inner-container\"><!-- wp:columns {\"className\":\"title-content mb-0\"} -->\n<div class=\"wp-block-columns title-content mb-0\"><!-- wp:column {\"width\":\"70%\",\"className\":\"title\"} -->\n<div class=\"wp-block-column title\" style=\"flex-basis:70%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"className\":\"mt-3 mb-0\",\"fontSize\":\"medium\",\"style\":{\"color\":{\"text\":\"#222222\"}}} -->\n<h4 class=\"has-text-align-left mt-3 mb-0 has-text-color has-medium-font-size\" style=\"color:#222222\">Category Title 2</h4>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"className\":\"btn ms-0\"} -->\n<div class=\"wp-block-column btn ms-0\" style=\"flex-basis:20%\"><!-- wp:buttons {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-buttons mb-0\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\"></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"category-box\"} -->\n<div class=\"wp-block-group category-box\"><div class=\"wp-block-group__inner-container\"><!-- wp:image {\"id\":9889,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"" . get_theme_file_uri() . "/inc/block-patterns/images/cat-image3.png\" alt=\"\" class=\"wp-image-9889\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"className\":\"category-inner-box px-3 py-1\"} -->\n<div class=\"wp-block-group category-inner-box px-3 py-1\"><div class=\"wp-block-group__inner-container\"><!-- wp:columns {\"className\":\"title-content mb-0\"} -->\n<div class=\"wp-block-columns title-content mb-0\"><!-- wp:column {\"width\":\"70%\",\"className\":\"title\"} -->\n<div class=\"wp-block-column title\" style=\"flex-basis:70%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"className\":\"mt-3 mb-0\",\"fontSize\":\"medium\",\"style\":{\"color\":{\"text\":\"#222222\"}}} -->\n<h4 class=\"has-text-align-left mt-3 mb-0 has-text-color has-medium-font-size\" style=\"color:#222222\">Category Title 3</h4>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"className\":\"btn ms-0\"} -->\n<div class=\"wp-block-column btn ms-0\" style=\"flex-basis:20%\"><!-- wp:buttons {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-buttons mb-0\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\"></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);
}