<?php
/**
 * Nexproperty Child Theme Custom Functions
**/
if ( ! defined( 'REAL_ESTATE_DIRECTORY_THEME_DIRECTORY' ) ) {
	define( 'REAL_ESTATE_DIRECTORY_THEME_DIRECTORY', get_stylesheet_directory() );
}

require REAL_ESTATE_DIRECTORY_THEME_DIRECTORY . '/includes/wptt-webfont-loader.php';

/**
 * Localize
 * Since 1.0
 */
 if( ! function_exists( 'real_estate_directory_localize' ) ) {
	 
	add_action('after_setup_theme', 'real_estate_directory_localize');

	function real_estate_directory_localize(){
		load_child_theme_textdomain( 'real-estate-directory' , get_stylesheet_directory().'/languages');
	}
 }

 /* Enqueue Child Theme Scripts & Styles 
 ** http://codex.wordpress.org/Function_Reference/wp_enqueue_style
 * Since 1.0
 */
 
add_action( 'wp_enqueue_scripts', 'real_estate_directory_styles' );	

if( ! function_exists( 'real_estate_directory_styles' ) ) {	

	function real_estate_directory_styles() {	
					
		wp_enqueue_style(
			'layers-parent-style',
			get_template_directory_uri() . '/style.css',
			array()
		); // Parent Stylsheet for Version info

        $remote_url = 'https://fonts.googleapis.com/css?family=Playfair Display:300,300i,400,400i,500,600,500i,600i,700,700i,900,900i|Poppins:300,300i,400,400i,500,600,500i,600i,700,700i,900,900i|Raleway:300,300i,400,400i,500,600,500i,600i,700,700i,900,900i&display=swap';
		if(function_exists('wptt_get_webfont_url')){
            wp_enqueue_style( 'rdm-google-fonts',  wptt_get_webfont_url( $remote_url ), false );
        }
	}
	
}
if( ! function_exists( 'real_estate_directory_scripts' ) ) {
		
	function real_estate_directory_scripts() {
		
		wp_enqueue_script(
			'real-estate-directory' . '-custom',
			get_stylesheet_directory_uri() . '/assets/js/theme.js',
			array(
				'jquery', // make sure this only loads if jQuery has loaded
			)
		); // Custom Child Theme jQuery  
		
	}	
	
}
// Output this in the footer before anything else
// http://codex.wordpress.org/Plugin_API/Action_Reference/wp_footer
add_action('wp_enqueue_scripts', 'real_estate_directory_scripts'); 
 

/**
* Add Sub Menu Page to the Layers Menu Item
*/
if( ! function_exists('real_estate_directory_register_submenu_page') ) {
	function real_estate_directory_register_submenu_page(){
		add_theme_page( __( 'Realtor Directory Moison Help' , 'real-estate-directory'  ), __( 'Realtor Directory Moison Help' , 'real-estate-directory'  ), 
							'edit_theme_options', 'real_estate_directory-dashboard', 'get_child_onboarding' );
	}
}
function get_child_onboarding(){
	require_once get_stylesheet_directory() . '/includes/theme-help.php';
}
add_action('admin_menu', 'real_estate_directory_register_submenu_page', 60);


/**
* Welcome Redirect
* http://docs.layerswp.com/how-to-add-help-pages-onboarding-to-layers-themes-or-extensions/
*/
function real_estate_directory_setup(){
	if( isset($_GET["activated"]) && $pagenow = "themes.php" ) { //&& '' == get_option( 'layers_welcome' )
		update_option( 'layers_welcome' , 1);
	}
}
add_action( 'after_setup_theme' , 'real_estate_directory_setup', 20 );
           
/*
* Add admin notify
* @param (string) $key unique key of notify, prefix included related plugin
* @param (string) $text test of message
* @param (function) $callback_filter custom function should be return true if not need show
* @param (string) $class notify alert class, by default 'notice notice-error'
* @return boolen true 
*/
function real_estate_directory_notify_admin ($key = '', $text = 'Custom Text of message', $callback_filter = '', $class = 'notice notice-error') {
    $key = 'real_estate_directory_notify_'.$key;
    $key_diss = $key.'_dissmiss';

    $real_estate_directory_notinstalled_admin_notice__error = function () use ($key_diss, $text, $class, $callback_filter) {
        global $wpdb;
        $user_id = get_current_user_id();
        if (!get_user_meta($user_id, $key_diss)) {
            if(!empty($callback_filter)) if($callback_filter()) return false;

            $message = '';
            $message .= $text;
            printf('<div class="%1$s" style="position:relative;"><p>%2$s</p><a href="?'.$key_diss.'"><button type="button" class="notice-dismiss"></button></a></div>', esc_html($class), ($message));  // WPCS: XSS ok, sanitization ok.
        }
    };

    add_action('admin_notices', function () use ($real_estate_directory_notinstalled_admin_notice__error) {
        $real_estate_directory_notinstalled_admin_notice__error();
    });

    $real_estate_directory_notinstalled_admin_notice__error_dismissed = function () use ($key_diss) {
        $user_id = get_current_user_id();
        if (isset($_GET[$key_diss]))
            add_user_meta($user_id, $key_diss, 'true', true);
    };
    add_action('admin_init', function () use ($real_estate_directory_notinstalled_admin_notice__error_dismissed) {
        $real_estate_directory_notinstalled_admin_notice__error_dismissed();
    });

    return true;
}
  
function real_estate_directory_notify_admin_welcome () {
    if(!current_user_can( 'activate_plugins' )) return false;
    add_action('admin_notices', function () {

        $screen = get_current_screen();
        if (get_user_meta(get_current_user_id(), 'theme_alert_dissmiss')) {
            return;
        }
        if ('appearance_page_one-click-demo-import' == $screen->id || 'appearance_page_real_estate_directory-dashboard' === $screen->id || 'appearance_page_tgmpa-install-plugins' === $screen->id) {
            return;
        }

        
        if (get_option('wdk_theme_rdm_installed')) {
            return true;
        }
        add_action('admin_footer', function () {
            echo '<style>
                 #setting-error-tgmpa {
                    display: none !important;
                }
            </style>';
        });
        ?>
        <div class="updated notice rdm-welcome-notice">
            <div class="rdm-welcome-notice-wrap">
                <h2><?php esc_html_e('Congratulations!', 'real-estate-directory'); ?></h2>
                <p><?php echo esc_html__('Real Estate Directory Moison is now installed and ready to use. You can start either by importing the ready made demo or get started by customizing it your self.', 'real-estate-directory'); ?></p>
    
                <div class="rdm-welcome-info">
                    <div class="rdm-welcome-thumb">
                        <img src="<?php echo esc_url(get_stylesheet_directory_uri() . '/screenshot.jpg'); ?>" alt="<?php echo esc_attr__('Real Estate Directory Moison Demo', 'real-estate-directory'); ?>">
                    </div>
                        <div class="rdm-welcome-import">
                            <h3><?php esc_html_e('Import Demo', 'real-estate-directory'); ?></h3>
                            <?php if(!file_exists(get_stylesheet_directory() .'/addons/configuration.php')):?>
                                <?php if ( 
                                    file_exists(ABSPATH . 'wp-content/plugins/one-click-demo-import/one-click-demo-import.php') && in_array( 'one-click-demo-import/one-click-demo-import.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) 
                                    && file_exists(ABSPATH . 'wp-content/plugins/elementor/elementor.php') && in_array( 'elementor/elementor.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) 
                                    && file_exists(ABSPATH . 'wp-content/plugins/wpdirectorykit/wpdirectorykit.php') && in_array( 'wpdirectorykit/wpdirectorykit.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) 
                                    && file_exists(ABSPATH . 'wp-content/plugins/elementinvader-addons-for-elementor/elementinvader-addons-for-elementor.php') && in_array( 'elementinvader-addons-for-elementor/elementinvader-addons-for-elementor.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) 
                                    ):?>
                                    <p><?php esc_html_e('Click below to Import Theme Demo Content.', 'real-estate-directory'); ?></p>
                                    <p><a href="<?php echo esc_url(get_admin_url() . "themes.php?page=one-click-demo-import");?>" class="button button-primary"><?php esc_html_e('Import Now', 'real-estate-directory'); ?></a></p>
                                <?php else:?>
                                    <p><?php esc_html_e('Click below to install and active Themes Needed plugins.', 'real-estate-directory'); ?></p>
                                    <p><a href="<?php echo esc_url(get_admin_url() . "themes.php?page=tgmpa-install-plugins");?>" class="button button-primary"><?php esc_html_e('For best experience please install and active all recommended plugin from theme before demo content import here', 'real-estate-directory'); ?></a></p>
                                <?php endif;?>
                            <?php else:?> 
                                <p><?php esc_html_e('Click below to install and active Themes Demo Importer Plugin.', 'real-estate-directory'); ?></p>
                                <?php if ( file_exists(ABSPATH . 'wp-content/plugins/one-click-demo-import/one-click-demo-import.php') && !in_array( 'one-click-demo-import/one-click-demo-import.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ):?>
                                    <p><a data-slug="one-click-demo-import" data-filename="one-click-demo-import" href="<?php echo esc_url(get_admin_url() . "themes.php?page=tgmpa-install-plugins");?>" class="button button-primary rdm-activate-plugin"><?php esc_html_e('Activate Demo Importer Plugin', 'real-estate-directory'); ?></a></p>
                                <?php elseif ( file_exists(ABSPATH . 'wp-content/plugins/one-click-demo-import/one-click-demo-import.php') && in_array( 'one-click-demo-import/one-click-demo-import.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) )):?>
                                    <p><a href="<?php echo esc_url(get_admin_url() . "themes.php?page=one-click-demo-import");?>" class="button button-primary"><?php esc_html_e('Go to Demo Importer Page', 'real-estate-directory'); ?></a></p>
                                <?php else:?>
                                    <p><a data-slug="one-click-demo-import" data-filename="one-click-demo-import" href="<?php echo esc_url(admin_url('themes.php?page=one-click-demo-import'));?>" class="button button-primary rdm-install-plugin"><?php esc_html_e('Install Demo Importer Plugin', 'real-estate-directory'); ?></a></p>
                                <?php endif;?>
                            <?php endif;?>
                        </div>
                    <div class="rdm-welcome-getting-started">
                        <h3><?php esc_html_e('Get Started', 'real-estate-directory'); ?></h3>
                        <p><?php echo esc_html__('Here you will find all the necessary links and information on how to use Real Estate Directory Moison.', 'real-estate-directory'); ?></p>
                        <p><a href="<?php echo esc_url(admin_url('themes.php?page=real_estate_directory-dashboard')); ?>" class="button button-primary "><?php esc_html_e('Go to Setting Page', 'real-estate-directory'); ?></a></p>
                    </div>
                </div>
    
                <a href="?theme_alert_dissmiss" class="notice-close"><?php esc_html_e('Dismiss', 'real-estate-directory'); ?></a>
            </div>
        </div>
        <?php
    });

    add_action('admin_init', function () {
        $user_id = get_current_user_id();
        if (isset($_GET['theme_alert_dissmiss']))
            add_user_meta($user_id, 'theme_alert_dissmiss', 'true', true);
    });

    return true;
}

real_estate_directory_notify_admin_welcome();

/**
 * Admin styles.
 *
 */
function real_estate_directory_custom_admin_styles() {
    echo '<style>
      .appearance_page_real_estate_directory-dashboard #setting-error-tgmpa {
        margin-left: 0;
      }

      .ocdi__content-container #setting-error-tgmpa,
      .ocdi-install-plugins-content-content .ocdi-content-notice.ocdi-content-notice--warning,
      .ocdi__file-upload-container .ocdi__file-upload-container-items .ocdi__file-upload:not(:first-child),
      .ocdi__file-upload-container .ocdi__file-upload-container-items--second-row,
      .ocdi__content-container .plugin-item.plugin-item-wpforms-lite,
      .ocdi__content-container .plugin-item.plugin-item-all-in-one-seo-pack,
      .ocdi__content-container .plugin-item.plugin-item-google-analytics-for-wordpress {
        display: none !important;
      }

      
      .button.button-primary.js-ocdi-install-plugins-before-import.ocdi-button-disabled::after {
        content: "\f113";
        font-family: dashicons;
        display: inline-block;
        line-height: 1;
        font-weight: 400;
        font-style: normal;
        speak: never;
        text-decoration: inherit;
        text-transform: none;
        text-rendering: auto;
        -webkit-animation: nexproperty-spin 2s infinite linear;
        animation: nexproperty-spin 2s infinite linear;
        margin-left: 13px;
        display: inline-block;
    }
        
    @keyframes nexproperty-spin {
        0% {
        -webkit-transform: rotate(0deg);
        transform: rotate(0deg);
        }
        100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg);
        }
    }
    </style>

    ';

  }
add_action('admin_head', 'real_estate_directory_custom_admin_styles');

  
function real_estate_directory_admin_scripts() {
        if(!current_user_can( 'activate_plugins' )) return false;
        $importer_params = array(
            'installing_text' => esc_html__('Installing Demo Importer Plugin', 'real-estate-directory'),
            'activating_text' => esc_html__('Activating Demo Importer Plugin', 'real-estate-directory'),
            'importer_page' => esc_html__('Go to Demo Importer Page', 'real-estate-directory'),
            'importer_url' => admin_url('themes.php?page=one-click-demo-import'),
            'error' => esc_html__('Error! Reload the page and try again.', 'real-estate-directory'),
            'success_redirect' => false,
            'tgmpa_link' => esc_url(get_admin_url() . "themes.php?page=tgmpa-install-plugins"),
            'success_import' => esc_html__('For best experience please install and active all recommended plugin from theme before demo content import here.', 'real-estate-directory'),
            'wpnonce' => wp_create_nonce( 'activate_plugin' ),
        );

        if(file_exists(get_stylesheet_directory() .'/addons/configuration.php')) {
            $importer_params['success_redirect'] = 1;
        }
        
        wp_enqueue_style('real-estate-directory-welcome', get_stylesheet_directory_uri() . '/assets/css/welcome.css', array(), '1.0');
        wp_enqueue_script('real-estate-directory-welcome', get_stylesheet_directory_uri() . '/assets/js/welcome.js', ['jquery','updates'], '1.0', true );
        wp_localize_script('real-estate-directory-welcome', 'importer_params', $importer_params);
}

add_action('admin_enqueue_scripts', 'real_estate_directory_admin_scripts');

if(!function_exists('rdm_activate_plugin')) {
    add_action('wp_ajax_rdm_activate_plugin', 'rdm_activate_plugin');
    function rdm_activate_plugin() {
        
        if(!current_user_can( 'activate_plugins' )) {
            echo esc_html__('Disable for current user', 'real-estate-directory');
            exit();
        }
        
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( $_POST['_wpnonce'], 'activate_plugin' ) ) {
            echo esc_html__('Wrong _wpnonce', 'real-estate-directory');
            exit();
        }

        $slug = isset($_POST['slug']) ? $_POST['slug'] : '';
        $file = isset($_POST['file']) ? $_POST['file'] : '';
        $success = false;

        if (!empty($slug) && !empty($file)) {
            $result = activate_plugin($slug . '/' . $file . '.php');
            update_option('rdm_hide_notice', true);
            if (!is_wp_error($result)) {
                $success = true;
            }
        }
        echo wp_json_encode(array('success' => $success));
        die();
    }
}

if(!function_exists('real_estate_directory_install_ocdi_images_sizes')) {

    function real_estate_directory_install_ocdi_images_sizes($sizes) {
        if(get_option('real_estate_directory_install_ocdi_images_sizes_enable') == 1) {
            unset($sizes['thumb']);
            unset($sizes['thumbnail']);
            unset($sizes['medium']);
            unset($sizes['large']);
            unset($sizes['medium_large']);
            unset($sizes['big_image_size_threshold']);
            unset($sizes['post-thumbnail']);
            unset($sizes['1536x1536']);
            unset($sizes['nexproperty-footer-thumbnail']);
            unset($sizes['nexproperty-slider-thumbnail']);
            unset($sizes['nexproperty-post-thumbnail']);
            unset($sizes['woocommerce_thumbnail']);
            unset($sizes['woocommerce_single']);
            unset($sizes['woocommerce_gallery_thumbnail']);
            unset($sizes['shop_single']);
            unset($sizes['shop_thumbnail']);
        }

        return $sizes;
    }
    add_filter('intermediate_image_sizes_advanced', 'real_estate_directory_install_ocdi_images_sizes');
}
