<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package NexProperty
 */

$real_estate_directory_footer_logo = get_theme_mod('footer_logo');
$real_estate_directory_footer_content = get_theme_mod('footer_content');
$real_estate_directory_footer_phone_number = get_theme_mod('footer_phone_number');
$real_estate_directory_email_address = get_theme_mod('footer_email_address');

?>
<footer>
	<div class="banner-footer">
		<div class="container">
			<div class="row">
				<div class="col-sm-8">
					<span class="banner-footer-text">
						<?php echo esc_html__('Find your perfect home', 'real-estate-directory'); ?>
					</span>
				</div>
				<div class="col-sm-4 f-right">
					<a href="#" class="btn-moison" role="button">
						<?php echo esc_html__('Search Now', 'real-estate-directory'); ?>
					</a>
				</div>
			</div>
		</div>
	</div>

	<div class="top-footer">
		<div class="container">
			<div class="row">
				<div class="col-lg-3 col-md-4 col-sm-6 col-12">
					<div class="my-property widget">
						<h3 class="title"><?php echo esc_html(get_bloginfo('name')); ?></h3>
						<?php if ($real_estate_directory_footer_content) : ?>
							<p><?php echo wp_kses_post($real_estate_directory_footer_content); ?></p>
						<?php else : ?>
							<p><?php echo esc_html(get_bloginfo('description')); ?></p>
						<?php endif; ?>
					</div>
					<!--my-property end-->
				</div>
				<?php
				if (is_active_sidebar('footer')) :
					dynamic_sidebar('footer');
				endif;
				?>
			</div>
		</div>
		<!--top-footer end-->
	</div>
</footer>
<!--footer end-->
</div>

<!--wrapper end-->
<?php wp_footer(); ?>
</body>

</html>