<?php
// Get the previous and next post objects
$prev_post = get_previous_post();
$next_post = get_next_post();

$style_demo = get_theme_mod( 'pointify_demo_selection', '' );
// Check if there is a previous post
if ($prev_post) {
	$prev_post_id = $prev_post->ID;
    ?>
    <div class="post-navigation previous-post">
        <a href="<?php echo esc_url(get_permalink($prev_post_id)); ?>" title="<?php echo wp_kses_post($prev_post->post_title); ?>">
            <?php echo get_the_post_thumbnail($prev_post_id, 'thumbnail'); ?>
			<div class="post-details-info-sec">
				<div class="author-info">
					<p class="author-name"><?php echo get_the_author_meta('display_name', $prev_post->post_author);	?></p>
				</div>
				<div class="post-published_date">
					Date: <?php echo get_the_date('', $prev_post_id); ?> 
				</div>
				<div class="post-other-info">
					<span class="post-comment-count"><?php echo get_comments_number($prev_post_id); ?></span>
				</div>
				
			</div>
			<div class="post-details">
                <h3><?php echo wp_kses_post($prev_post->post_title); ?></h3>
				<?php if($style_demo !== 'job_board') { ?>
                	<p><?php echo get_the_excerpt($prev_post_id) ?></p>
					<a class="more-link" href="<?php echo esc_url(get_permalink($prev_post_id)); ?>" title="<?php echo wp_kses_post($prev_post->post_title); ?>"><?php _e('Read More', 'pointify'); ?></a>
				<?php } ?>
            </div>
		</a>
    </div>
    <?php
}

// Check if there is a next post
if ($next_post) {
	$next_post_id = $next_post->ID;
    ?>
    <div class="post-navigation next-post">
        <a href="<?php echo esc_url(get_permalink($next_post_id)); ?>" title="<?php echo wp_kses_post($next_post->post_title); ?>">
            <?php echo get_the_post_thumbnail($next_post_id, 'thumbnail'); ?>
			<div class="post-details-info-sec">
				<div class="author-info">
					<p class="author-name"><?php echo get_the_author_meta('display_name', $next_post->post_author);	?></p>
				</div>
				<div class="post-published_date">
					Date: <?php echo get_the_date('', $next_post_id); ?> 
				</div>
				<div class="post-other-info">
					<span class="post-comment-count"><?php echo get_comments_number($next_post_id); ?></span>
				</div>
				
			</div>
			<div class="post-details">
                <h3><?php echo wp_kses_post($next_post->post_title); ?></h3>
				<?php if($style_demo !== 'job_board') { ?>
                	<p><?php echo get_the_excerpt($next_post_id); ?></p>
					<a class="more-link" href="<?php echo esc_url(get_permalink($next_post_id)); ?>" title="<?php echo wp_kses_post($next_post->post_title); ?>"><?php _e('Read More', 'pointify'); ?></a>
				<?php } ?>
            </div>
		</a>
    </div>
    <?php
}
