<?php
/**
 * Template part for displaying all content single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#content-single-post
 *
 * @package Pointify_-_Listing_Directory_WordPress_Theme
 */

$style_demo = get_theme_mod( 'pointify_demo_selection', '' );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if($style_demo === 'job_board' || $style_demo === 'lawyer' ) { ?>
		<div class="post-content-section">
			<div class="post-details-section">

				<div class="post-detail-content-sec">
					<?php 
						the_title( '<h2 class="entry-title">', '</h2>' ); 
					?>
				</div>
				<div class="post-details-info-sec">
					<p class="author-name"><?php echo get_the_author_meta('display_name'); ?></p>
					<div class="post-time-info">
						<?php pointify_post_time_details(); ?>
					</div>
					<div class="post-other-info">
						<span class="post-comment-count"><?php comments_number( '0', '1', '%' ); ?></span>
					</div>
					<div class="post-share-section">
						<?php pointify_post_share(); ?>
					</div>
				</div>
			</div>
		</div>
	<?php 
		}
		?>
		<div class="post-single-thumb">
			<?php
			pointify_post_thumbnail(); 
			pointify_get_the_category();
			?>
		</div>	
		<?php
		if($style_demo === 'business') { 
	?>
	<div class="post-content-section">
		<div class="post-author-sec">
			<?php pointify_author_details(); ?>
		</div>
		<div class="post-details-section">

			<div class="post-detail-content-sec">
				<?php 
					the_title( '<h2 class="entry-title">', '</h2>' ); 
				?>
			</div>
			<div class="post-details-info-sec">
				<div class="post-time-info">
					<?php pointify_post_time_details(); ?>
				</div>
				<!-- <div class="post-like-sec">
					<?php //pointify_custom_like_post(); ?>
				</div> -->
				<div class="post-other-info">
					<span class="post-comment-count"><?php comments_number( '0', '1', '%' ); ?></span>
				</div>
				<div class="post-share-section">
					<?php pointify_post_share(); ?>
				</div>
			</div>
		</div>
	</div>
	<?php } ?>
	<div class="post-content-sec">
		<?php the_content(); ?>
	</div>
	<div class="post-tags-sec">
		<?php 
			echo pointify_tags_icons();
			pointify_get_the_tags(); 
		?>
	</div>
	<div class="post-nav-wrap-sec">
		<?php get_template_part( 'template-parts/post-navigation', get_post_type() ); ?>
	</div>
</article>