<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Pointify_-_Listing_Directory_WordPress_Theme
 */

get_header();
?>

	<main id="primary" class="site-main">
		<div class="page_header_section" style="background-image: url(<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>);">
			<?php pointify_page_header(); ?>
			<div class="page_breadcrumb_sec">
				<?php echo pointify_page_breadcrumb(); ?>
			</div>
		</div>
		<div class="single-post-main-section">
			<div class="container">
				<div class="row">
					<div class="col-md-8 col-lg-9">
						
						<div class="single-content-wrapper">
							<?php
							while ( have_posts() ) :
								the_post();

								get_template_part( 'template-parts/content-single', get_post_type() );
								
								
								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) :
									comments_template();
								endif;

							endwhile; // End of the loop.
							?>
						</div>
					</div>
					<div class="col-md-4 col-lg-3">
						<div class="sidebar-content">
							<?php get_sidebar(); ?>
						</div>
					</div>
				</div>
			</div>
		</div>

	</main><!-- #main -->

<?php
get_footer();
