<?php
/**
 * The template for displaying all single job listing
 *
 */

get_header();
?>
	<main id="primary" class="site-main">
		<?php
			// Get the current job listing ID
			$job_id = get_the_ID();
			$job_title = get_the_title( $job_id );
			$job_content = get_post_field( 'post_content', $job_id );
			$featured_image = get_post_meta( $job_id, '_featured_image', true );
			$job_location = get_post_meta( $job_id, '_job_location', true );
			$job_salary = get_post_meta( $job_id, '_job_salary', true );
			$job_salary_currency = get_post_meta( $job_id, '_job_salary_currency', true );
			$job_salary_unit = get_post_meta( $job_id, '_job_salary_unit', true );
			$job_all_ratings = get_post_meta( $job_id, '_all_ratings', true );
			$job_average_rating = get_post_meta( $job_id, '_average_rating', true );

			// Company
			$company_name = get_post_meta( $job_id, '_company_name', true );
			$company_website = get_post_meta( $job_id, '_company_website', true );
			$company_tagline = get_post_meta( $job_id, '_company_tagline', true );
			$company_twitter = get_post_meta( $job_id, '_company_twitter', true );
			$company_video = get_post_meta( $job_id, '_company_video', true );
			$filled = get_post_meta( $job_id, '_filled', true );

			$job_types = wp_get_post_terms($job_id, 'job_listing_type');

			$style_demo = get_theme_mod( 'pointify_demo_selection', '' );

		if ($style_demo === 'job_board' || $style_demo === 'lawyer' ) { ?>
			<div class="page_header_section listing_single_cls" style="background-image: url(<?php echo $featured_image; ?>);">
				<div class="listing-details">
					<?php pointify_page_header(); ?>
					<div class="page_breadcrumb_sec">
						<?php echo pointify_page_breadcrumb(); ?>
					</div>
				</div>
			</div>
		<?php } else { ?>
			<div class="page_header_section listing_single_cls" style="background-image: url(<?php echo $featured_image; ?>);">
				<div class="listing-details">
					<div class="listing-header-left">
						<div class="company-logo">
							<img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" alt="<?php echo $job_title; ?>">
						</div>
						<div class="listing-title-caption">
							<?php if(!empty($job_title)) { ?>
							<div class="job-title">
								<h4><?php echo $job_title; ?></h4>
							</div>
							<?php } 
								if(!empty($job_location)){
							?>
							<div class="job-location">
								<span><?php echo $job_location; ?></span>
							</div>
							<?php } ?>
							<div class="listing_review_fav">
								<?php if(class_exists('WP_Job_Manager_Reviews')) { ?>
									<div class="listing_review_cls">
										<?php
											echo wpjmr_reviews_get_stars($job_id);
											echo wpjmr_get_reviews_average($job_id);
										?>
									</div>
								<?php
									}
									if (class_exists('Astoundify\Favorites\Favorite')) {
								?>
									<div class="listing_fav_sec">
										<?php echo astoundify_favorites_link($job_id); ?>	
									</div>
								<?php } ?>
							</div>
													
						</div>
					</div>
					
					<div class="listing-header-right">
						<?php if(!empty($job_salary)) { ?>
							<div class="listing-pricing">
								<h5><?php echo $job_salary_currency .' '. $job_salary.'/'.$job_salary_unit; ?></h5>
							</div>
						<?php } 
						if ( comments_open() ) {
						?>
						<div class="review_btn_cls">
							<a href="#respond" title="<?php _e( 'Review', 'pointify' ); ?>"><?php _e( 'Write a Review', 'pointify' ); ?></a>
						</div>
						<?php } 
						if ( class_exists( 'Extensify' ) ) {
							$extensify_job_manager_claim_listing_enable = get_option( 'extensify_job_manager_claim_listing_enable' );
							if( $extensify_job_manager_claim_listing_enable ){
								do_action( 'pointify_single_job_listing_actions_start' );
							}
						}
						?>
					</div>
					
				</div>
			</div>
		<?php } ?>

		<div class="single-post-main-section single-listing-section">
			<div class="container">
				<div class="row">					
					<?php 					
						if ($style_demo === 'job_board') { 
						
						$job_post_date = get_post_field('post_date', $job_id);
						$timestamp = strtotime($job_post_date);
						$formatted_date = date_i18n('d M Y', $timestamp);
					?>
						<div class="col-md-9">
							<div class="single-content-wrapper single_job_listing job_board_single_listing">
								<div class="job_board_single_header">
									<div class="job-date-cls">
										<?php echo sprintf( __('%s by %s', 'pointify'), $formatted_date, $company_name ); ?>
									</div>
									<?php if(!empty($job_title)) { ?>
										<div class="job-title">
											<h4><?php echo $job_title; ?></h4>
										</div>
									<?php } ?>
									<div class="company twitter_site">
										<a href="https://twitter.com/<?php echo $company_twitter; ?>" class="company_twitter" title="<?php echo $company_twitter; ?>">
											<?php echo __('Twitter', 'pointify'); ?>
										</a>
									</div>
									<?php
										if ( comments_open() ) {
										?>
										<div class="review_btn_cls">
											<a href="#respond" title="<?php _e( 'Review', 'pointify' ); ?>"><?php _e( 'Write a Review', 'pointify' ); ?></a>
										</div>
										<?php } 
										if ( class_exists( 'Extensify' ) ) {
											$extensify_job_manager_claim_listing_enable = get_option( 'extensify_job_manager_claim_listing_enable' );
											if( $extensify_job_manager_claim_listing_enable ){
												do_action( 'pointify_single_job_listing_actions_start' );
											}
										}
										do_action( 'single_job_listing_meta_after' );
									?>
								</div>
								
								<?php 
									if($company_video) {
										?>
										<div class="company-content">
											<h3><?php _e( 'Company info', 'pointify' ); ?></h3>
											<?php the_company_video(); ?>
										</div>
										<?php
									}
								 ?>

								<div class="post-content-sec">
									<h3><?php _e( 'Job Description', 'pointify' ); ?></h3>
									<?php the_content(); ?>
								</div>
								<?php
									// If comments are open or we have at least one comment, load up the comment template.
									if ( comments_open() || get_comments_number() ) :
										comments_template();
									endif;
								?>
							</div>
						</div>
						<div class="col-md-3">
							<div class="job-company-caption">
								<div class="job-company-logo">
									<img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" alt="<?php echo $job_title; ?>">
								</div>
								
								<div class="job-company-link">
									<a class="website" href="<?php echo esc_url($company_website); ?>" target="_blank" rel="nofollow" title="<?php echo esc_attr( 'Website', 'pointify'); ?>"><?php echo esc_html( 'Visit Website', 'pointify'); ?></a>
								</div>

								<div class="job-additional-details">

									<div class="job-add-detail-caption">

										<div class="job-add-detail-content">
											<h4><?php echo __('Job Title', 'pointify'); ?></h4>
											<p><?php echo $job_title; ?></p>
										</div>

										<div class="job-add-detail-content">
											<h4><?php echo __('Job Type', 'pointify'); ?></h4>
											<p>
												<?php 
													if (!empty($job_types) && !is_wp_error($job_types)) {
														$job_type = $job_types[0]; ?>
													<span class="job-type-cls"><?php echo esc_html($job_type->name); ?></span>
												<?php } ?>
											</p>
										</div>
										
										<?php if(!empty($job_location)) { ?>
											<div class="job-add-detail-content">
												<h4><?php echo __('Location', 'pointify'); ?></h4>
												<p><?php echo $job_location; ?></p>
											</div>
										<?php } ?>

										<?php if(!empty($job_salary)) { ?>
											<div class="job-add-detail-content">
												<h4><?php echo __('Offered Salary', 'pointify'); ?></h4>
												<p><?php echo $job_salary_currency .' '. $job_salary; ?></p>
											</div>
										<?php } ?>

										<?php if(!empty($job_salary)) { ?>
											<div class="job-add-detail-content">
												<h4><?php echo __('Salary Unit', 'pointify'); ?></h4>
												<p><?php echo $job_salary_unit; ?></p>
											</div>
										<?php } ?>

										
										<div class="job-add-detail-content">
											<h4><?php echo __('Date Posted', 'pointify'); ?></h4>
											<p><?php echo $formatted_date; ?></p>
										</div>
										


									</div>

									<?php 
										if (! is_position_filled() ) : 
											if ( $apply = get_the_job_application_method() ) :
												wp_enqueue_script( 'wp-job-manager-job-application' );
												?>
												<div class="job_application application">
													<?php do_action( 'job_application_start', $apply ); ?>

													<input type="button" class="application_button button" value="<?php esc_attr_e( 'Apply for job', 'pointify' ); ?>" />

													<div class="application_details">
														<?php
															/**
															 * job_manager_application_details_email or job_manager_application_details_url hook
															 */
															do_action( 'job_manager_application_details_' . $apply->type, $apply );
														?>
													</div>
													<?php do_action( 'job_application_end', $apply ); ?>
												</div>
										<?php 
											endif; 
										endif; 
									?>

								</div>

							</div>
						</div>
					<?php } elseif ($style_demo === 'lawyer') { ?>
						<div class="col-md-<?php if ( class_exists( 'Extensify' ) ) { ?>8<?php }else{ ?>12<?php } ?>">
							<div class="single-content-wrapper single_job_listing job_board_single_listing">
								<div class="job_board_single_header">
									<div class="lawyer-listing-caption">
										<div class="company-logo">
											<img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" alt="<?php echo $job_title; ?>">
										</div>
										<div class="lawyer-listing-content">
											<?php if(!empty($job_title)) { ?>
												<div class="job-title">
													<h4><?php echo $job_title; ?></h4>
												</div>
											<?php } ?>
											<div class="job-add-detail-content">
												<p>
													<?php 
														if (!empty($job_types) && !is_wp_error($job_types)) {
															$job_type = $job_types[0]; ?>
														<span class="job-type-cls"><?php echo esc_html($job_type->name); ?></span>
													<?php } ?>
												</p>
											</div>
										<?php
											if(class_exists('WP_Job_Manager_Reviews')) { ?>
												<div class="listing_review_cls">
													<?php
														echo wpjmr_reviews_get_stars($job_id);
														echo wpjmr_get_reviews_average($job_id);
													?>
												</div>
											<?php }
											if(!empty($job_location)){
												?>
												<div class="job-location">
													<span><?php echo $job_location; ?></span>
												</div>
											<?php } ?>
											<div class="job-company-link">
												<a class="website" href="<?php echo esc_url($company_website); ?>" target="_blank" rel="nofollow" title="<?php echo esc_attr( 'Website', 'pointify'); ?>"><i class="fa fa-globe" aria-hidden="true"></i> <?php echo esc_html($company_website); ?></a>
											</div>
											<?php if(!empty($job_salary)) { ?>
												<div class="listing-pricing">
													<h5><?php echo $job_salary_currency .' '. $job_salary.'/'.$job_salary_unit; ?></h5>
												</div>
											<?php } ?>
											<div class="company twitter_site">
												<a href="https://twitter.com/<?php echo $company_twitter; ?>" class="company_twitter" title="<?php echo $company_twitter; ?>">
													<?php echo __('Twitter', 'pointify'); ?>
												</a>
											</div>
											<?php
												if ( comments_open() ) {
												?>
												<div class="review_btn_cls">
													<a href="#respond" title="<?php _e( 'Review', 'pointify' ); ?>"><?php _e( 'Write a Review', 'pointify' ); ?></a>
												</div>
												<?php } 
												if ( class_exists( 'Extensify' ) ) {
													$extensify_job_manager_claim_listing_enable = get_option( 'extensify_job_manager_claim_listing_enable' );
													if( $extensify_job_manager_claim_listing_enable ){
														do_action( 'pointify_single_job_listing_actions_start' );
													}
												}
												do_action( 'single_job_listing_meta_after' );
											?>
										</div>
									</div>
								</div>
								<?php 
									if($company_video) {
										?>
										<div class="company-content">
											<h3><?php _e( 'Company info', 'pointify' ); ?></h3>
											<?php the_company_video(); ?>
										</div>
										<?php
									}
								 ?>

								<div class="post-content-sec">
									<h3><?php _e( 'Job Description', 'pointify' ); ?></h3>
									<?php the_content(); ?>
								</div>
								<?php
									// If comments are open or we have at least one comment, load up the comment template.
									if ( comments_open() || get_comments_number() ) :
										comments_template();
									endif;
								?>
							</div>
						</div>
						<?php if ( class_exists( 'Extensify' ) ) { ?>
							<div class="col-md-4">
								<?php
									$location = get_post_meta( $job_id, '_job_location', true );
									if ( $location ) {
										?>
										<div class="listing-location-info">
											<?php
												if(!empty($title)){ ?>
													<div class="location_title">
														<h2 class="widget-title"><?php echo $title; ?></h2>
													</div><?php
												}
											?>
											<div id="job-listing-map" style="width: 100%; height: 250px;"></div>
											<script>
												function initMap() {
													var geocoder = new google.maps.Geocoder();
													var map = new google.maps.Map(document.getElementById('job-listing-map'), {
														zoom: 12,
														center: {lat: -34.397, lng: 150.644} // Default center if geocoding fails
													});
													geocoder.geocode({ 'address': '<?php echo esc_js( $location ); ?>' }, function(results, status) {
														if (status === 'OK') {
															map.setCenter(results[0].geometry.location);
															var marker = new google.maps.Marker({
																map: map,
																position: results[0].geometry.location
															});
														}
													});
												}
												initMap();
											</script>
											<?php  
												$google_api = get_option( 'job_manager_google_maps_api_key' );
											?>
											<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo $google_api; ?>&callback=initMap" async defer></script>
											<div class="job-add-detail-content">
											<h4><?php echo __('Specialist', 'pointify'); ?></h4>
											<p>
												<?php 
													if (!empty($job_types) && !is_wp_error($job_types)) {
														$job_type = $job_types[0]; ?>
													<span class="job-type-cls"><?php echo esc_html($job_type->name); ?></span>
												<?php } ?>
											</p>
										</div>
										<?php if(!empty($job_location)) { ?>
											<div class="job-add-detail-content">
												<h4><?php echo __('Location', 'pointify'); ?></h4>
												<p><?php echo $job_location; ?></p>
											</div>
										<?php }
										if (! is_position_filled() ) : 
											if ( $apply = get_the_job_application_method() ) :
												wp_enqueue_script( 'wp-job-manager-job-application' );
												?>
												<div class="job_application application">
													<?php do_action( 'job_application_start', $apply ); ?>

													<input type="button" class="application_button button" value="<?php esc_attr_e( 'Contact Now', 'pointify' ); ?>" />

													<div class="application_details">
														<?php
															/**
															 * job_manager_application_details_email or job_manager_application_details_url hook
															 */
															do_action( 'job_manager_application_details_' . $apply->type, $apply );
														?>
													</div>
													<?php do_action( 'job_application_end', $apply ); ?>
												</div>
										<?php 
											endif; 
										endif; ?>
										</div>
										<?php
									}
								?>
							</div>
						<?php } ?>	
					<?php } else { ?>
						<div class="col-md-<?php if ( class_exists( 'Extensify' ) ) { ?>9<?php }else{ ?>10 offset-md-1<?php } ?>">
							<div class="single-content-wrapper single_job_listing">
								<div class="post-content-sec">
									<h3><?php _e( 'Overview', 'pointify' ); ?></h3>
									<?php the_content(); ?>
								</div>
								<div class="company">
									<h3><?php _e( 'Company Info', 'pointify' ); ?></h3>
									<div class="company_header">
										<div class="company_name_desc">
											<p class="name">			
												<strong><?php echo $company_name; ?></strong>		
											</p>
											<p class="tagline"><?php echo $company_tagline; ?></p>
										</div>
										<div class="twitter_site">
											<a href="https://twitter.com/<?php echo $company_twitter; ?>" class="company_twitter" title="<?php echo $company_twitter; ?>">
												<?php echo $company_twitter; ?>
											</a>
											<a class="website" href="<?php echo esc_url($company_website); ?>" target="_blank" rel="nofollow" title="<?php echo esc_attr( 'Website', 'pointify'); ?>"><?php echo esc_html( 'Website', 'pointify'); ?></a>
										</div>
									</div>
									
									<?php the_company_video(); ?>
									
									<div class="meta">
										<?php if ( is_position_filled() ) : ?>
											<span class="position-filled"><?php _e( 'This position has been filled up', 'pointify' ); ?></span>
										<?php elseif ( ! candidates_can_apply() && 'preview' !== $post->post_status ) : ?>
											<span class="listing-expired"><?php _e( 'Applications have closed', 'pointify' ); ?></span>
										<?php endif; ?>
									</div>								

									<?php 
										if (! is_position_filled() ) : 
											if ( $apply = get_the_job_application_method() ) :
												wp_enqueue_script( 'wp-job-manager-job-application' );
												?>
												<div class="job_application application">
													<?php do_action( 'job_application_start', $apply ); ?>

													<input type="button" class="application_button button" value="<?php esc_attr_e( 'Apply for job', 'pointify' ); ?>" />

													<div class="application_details">
														<?php
															/**
															 * job_manager_application_details_email or job_manager_application_details_url hook
															 */
															do_action( 'job_manager_application_details_' . $apply->type, $apply );
														?>
													</div>
													<?php do_action( 'job_application_end', $apply ); ?>
												</div>
										<?php 
											endif; 
										endif; 
									?>
								</div>

								<?php
									do_action( 'single_job_listing_meta_after' );
									// If comments are open or we have at least one comment, load up the comment template.
									if ( comments_open() || get_comments_number() ) :
										comments_template();
									endif;
								?>

							</div>
						</div>
						<?php 
							if ( class_exists( 'Extensify' ) ) {
								?>
								<div class="col-md-3">
									<?php dynamic_sidebar( 'widget-area-job-single-listing-sidebar-page' ); ?>
								</div>
								<?php
							}
					}  

					if( class_exists('WP_Job_Manager_Reporting_2') ) {
						echo '<div class="report-spam-button wp-job-manager-report-job-widget-button-contain">';
							$current_post_id = get_the_ID();
							if( $current_post_id ){
								echo '<a href="#" post-id="'.$current_post_id.'" class="report-post-link wp-job-manager-report-job-widget-button wjmrjw-button button btn-primary" >Report Post</a>';     
							}
						echo '</div>'; 
					}
					?>
				</div>
			</div>

			<?php
				if ($style_demo === 'job_board') { 
				// Get the related jobs
				$related_jobs = pointify_get_related_jobs(get_the_ID());

				if ($related_jobs->have_posts()) : ?>
					<div class="related-jobs">
						<div class="container">
							<div class="related-jobs-caption">
								<div class="related-jobs-caption-content">
									<h2><?php _e('Related Jobs', 'pointify'); ?></h2>
									<ul>
										<?php while ($related_jobs->have_posts()) : $related_jobs->the_post(); ?>
											<?php get_template_part('job-manager/job-board/content', 'job_board_listing'); ?>
										<?php endwhile; ?>
									</ul>
								</div>
							</div>
						</div>
					</div>
					<?php wp_reset_postdata(); ?>
				<?php endif; 
			} ?>

		</div>

	</main><!-- #main -->

<?php
get_footer();
