<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Pointify_-_Listing_Directory_WordPress_Theme
 */

get_header();
?>
	<main id="primary" class="site-main">
		<div class="page_header_section" style="background-image: url(<?php echo esc_url(get_theme_mod('archive_page_header_background_image', 'full')); ?>);">
			<div class="pointify-page-header">
				<h2 class="pointify-blog-title"><?php printf( esc_html__( get_search_query()  )); ?></h2>
			</div>
			 <div class="page_breadcrumb_sec">
				 <?php echo pointify_page_breadcrumb(); ?>
			 </div>
		</div>
		<div class="post-pg-main-sec">
			 <div class="container">
				 <div class="row">
					 <div class="col-md-9">
						 <div class="post-main-box">
							<?php if ( have_posts() ) : ?>
								<?php
								/* Start the Loop */
								while ( have_posts() ) :
									the_post();

									/**
									 * Run the loop for the search to output the results.
									 * If you want to overload this in a child theme then include a file
									 * called content-search.php and that will be used instead.
									 */
									get_template_part( 'template-parts/content', 'search' );

								endwhile;

								?>
								<div class="post-pagination-sec">
									<?php
									echo pointify_post_pagination();
									?>
								</div>
								<?php
							else :

								get_template_part( 'template-parts/content', 'none' );

							endif;
							?>
						</div>	 
					</div>
					<div class="col-md-3">
							<div class="sidebar-content">
								<?php get_sidebar(); ?>
							</div>
					</div>
				</div>
			</div>
		</div>
	</main><!-- #main -->
<?php
get_footer();
