<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Pointify_Widget_Search_Hero extends WP_Widget {

    // Widget setup.
    public function __construct() {
        $widget_ops = array(
            'classname'   => 'widget-home-hero-search',
            'description' => esc_html__( 'Display a "hero" search area.', 'pointify' ),
        );
        parent::__construct( 'pointify_widget_search_hero', esc_html__( 'Pointify - Page: Search Hero', 'pointify' ), $widget_ops );
    }

    // Widget form creation
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $light_title = !empty($instance['light_title']) ? $instance['light_title'] : '';
        $span_text = !empty($instance['span_text']) ? $instance['span_text'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        $highlighted_description = !empty($instance['highlighted_description']) ? $instance['highlighted_description'] : '';
        $background_image = !empty($instance['background_image']) ? $instance['background_image'] : '';
        wp_enqueue_media();
        wp_enqueue_script( 'pointify-admin-widget-media' ); 
        // Widget title
        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

	    if($style_demo === 'job_board' || $style_demo === 'lawyer'  ){ ?>
            <p>
                <label for="<?php echo $this->get_field_id('light_title'); ?>"><?php _e('Light Heading:', 'pointify'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('light_title'); ?>" name="<?php echo $this->get_field_name('light_title'); ?>" type="text" value="<?php echo esc_attr($light_title); ?>">
            </p>
        <?php } ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <!-- Widget span text -->
        <p>
            <label for="<?php echo $this->get_field_id('span_text'); ?>"><?php _e('Highlighted Text:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('span_text'); ?>" name="<?php echo $this->get_field_name('span_text'); ?>" type="text" value="<?php echo esc_attr($span_text); ?>">
            <span><?php _e('Please add specific text from above title', 'pointify'); ?></span>
        </p>

        <!-- Widget description -->
        <p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'pointify'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>

        <?php
        if( $style_demo === 'lawyer'  ){ ?>
            <p>
                <label for="<?php echo $this->get_field_id('highlighted_description'); ?>"><?php _e('Highlighted description:', 'pointify'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('highlighted_description'); ?>" name="<?php echo $this->get_field_name('highlighted_description'); ?>" type="text" value="<?php echo esc_attr($highlighted_description); ?>">
            </p>
        <?php } ?>

        <!-- Widget background image -->
        <p>
            <label for="<?php echo $this->get_field_id('background_image'); ?>"><?php _e('Background Image:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('background_image'); ?>" name="<?php echo $this->get_field_name('background_image'); ?>" type="text" value="<?php echo esc_attr($background_image); ?>">
            <button class="button button-secondary" onclick="openMediaUploader(this); return false;"><?php _e('Select Image', 'pointify'); ?></button>
            <a class="button pointify-widget-media-clear"><?php esc_html_e( 'Clear', 'pointify' ); ?></a>
        </p>
        <?php
    }

    // Widget update
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['light_title'] = (!empty($new_instance['light_title'])) ? sanitize_text_field($new_instance['light_title']) : '';
        $instance['span_text'] = !empty($new_instance['span_text']) ? sanitize_text_field($new_instance['span_text']) : '';
        $instance['description'] = (!empty($new_instance['description'])) ? sanitize_text_field($new_instance['description']) : '';
        $instance['highlighted_description'] = (!empty($new_instance['highlighted_description'])) ? sanitize_text_field($new_instance['highlighted_description']) : '';
        $instance['background_image'] = (!empty($new_instance['background_image'])) ? esc_url($new_instance['background_image']) : '';

        return $instance;
    }

    // Widget display
    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );
	    if($style_demo === 'job_board' || $style_demo === 'lawyer' ){
            $light_title = isset($instance['light_title']) ? esc_html($instance['light_title']) : '';
        }
        $span_text = esc_html($instance['span_text']);
        $description = esc_html($instance['description']);
        if($style_demo === 'lawyer' ){
            $highlighted_description = isset($instance['highlighted_description']) ? esc_html($instance['highlighted_description']) : '';
        }
        $background_image = esc_url($instance['background_image']);

        // Output before widget
        echo $args['before_widget'];

        ?>
        <div class="pointify-hero-search" style="background-image: url(<?php echo esc_url($background_image); ?>);">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="content-section">
                            <?php
                                if (!empty($light_title) ) {
                                    echo '<h2 class="hero-light-title">' . $light_title . '</h2>';
                                }
                                if (!empty($title) ) {
                                    echo '<h2 class="hero-title" data-highlighted="'.$span_text.'"><span>' . $title . '</span></h2>';
                                }
                                if($style_demo === 'lawyer' ){
                                    if (!empty($description)) {
                                        echo '<p class="' . (!empty($highlighted_description) ? ' hero-desc' : '') . '"' . (!empty($highlighted_description) ? ' data-highlighted-desc="' . $highlighted_description . '"' : '') . '>' . $description . '</p>';
                                    }
                                } else {
                                    if (!empty($description)) {
                                        echo '<p>' . $description . '</p>';
                                    }
                                }
                                //echo do_shortcode('[jobs search="true" show_filters="true"]');
                                get_template_part( 'job', 'filters-flat');

                                //include(locate_template('job-filters-flat.php'));
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        echo $args['after_widget'];
    }

}

// Register the widget.
function register_pointify_widget_search_hero() {
    register_widget( 'Pointify_Widget_Search_Hero' );
}
add_action( 'widgets_init', 'register_pointify_widget_search_hero' );

