<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Pointify_Pricing_Table_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'pointify_pricing_table_widget',
            __('Pointify - Page: Pricing Table Widget', 'pointify'),
            array('description' => __('A pointify widget for pricing table', 'pointify'))
        );
    }

    // Widget backend
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'pointify'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>
        <?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['description'] = (!empty($new_instance['description'])) ? sanitize_text_field($new_instance['description']) : '';

        return $instance;
    }

    // Widget frontend
    public function widget($args, $instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'Popular Listings';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        $packages = $this->get_packages();
		$count    = count( $packages );
        $stacked     = isset( $instance['stacked'] ) && 1 === (int) $instance['stacked'] ? true : false;
        $packages_class = $stacked ? 'job-packages job-packages--stacked' : "job-packages job-packages--inline job-packages--count-{$count}";
		if ( $count > 3 ) {
			$count = 3;
		}

		if ( ! $packages ) {
			return;
		}
        echo $args['before_widget'];      

        ?>
        <div class="popular-listing-section">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="widget-title-desc-caption">
                            <?php
                                if (!empty($title) ) {
                                    ?>
                                    <h3><?php echo $title; ?></h3>
                                    <?php
                                }
                                if (!empty($description)) {
                                    ?>
                                    <p><?php echo esc_html($description); ?></p>
                                    <?php
                                }
                            ?>
                        </div>
                        <ul class="<?php echo esc_attr( $packages_class ); ?>">
                            <?php
                            foreach ( $packages as $package ) :
                                $product = wc_get_product( method_exists( $package, 'get_id' ) ? $package : $package->ID );
                                ?>

                                <?php
                                $tags       = wc_get_product_tag_list( $product->get_id() );
                                $action_url = add_query_arg( 'choose_package', $product->get_id(), job_manager_get_permalink( 'submit_job_form' ) );

                                // Dynamic HTML Classes.
                                // @todo: Style it using parent div instead of adding "stacked" class to each element.
                                $package_class  = $stacked ? 'job-package job-package--stacked' : 'job-package';
                                $tag_class      = $stacked ? 'job-package-tag job-package-tag--stacked' : 'job-package-tag';
                                $header_class   = $stacked ? 'job-package-header job-package-header--stacked' : 'job-package-header';
                                $title_class    = $stacked ? 'job-package-title job-package-title--stacked' : 'job-package-title';
                                $price_class    = $stacked ? 'job-package-price job-package-price--stacked' : 'job-package-price';
                                $purchase_class = $stacked ? 'job-package-purchase job-package-purchase--stacked' : 'job-package-purchase';
                                $includes_class = $stacked ? 'job-package-includes job-package-includes--stacked' : 'job-package-includes';
                                ?>

                            <li class="<?php echo esc_attr( $package_class ); ?>">
                                <?php if ( $tags ) : ?>
                                <span class="<?php echo esc_attr( $tag_class ); ?>"><span class="job-package-tag__text"><?php echo esc_html( strip_tags( $tags ) ); ?></span></span>
                            <?php endif; ?>

                            <div class="<?php echo esc_attr( $header_class ); ?>">
                                <div class="<?php echo esc_attr( $price_class ); ?>">
                                    <?php echo $product->get_price_html(); // WPCS: XSS ok. ?>
                                </div>
                                <div class="<?php echo esc_attr( $title_class ); ?>">
                                    <div class="product-title-cls">
                                        <?php echo esc_attr( $product->get_title() ); ?>
                                    </div>
                                    <div class="product-short-desc">
                                        <?php echo esc_attr( $product->get_short_description() ); ?>
                                    </div>
                                </div>
                                
                            </div>

                            <div class="<?php echo esc_attr( $includes_class ); ?>">
                                <?php
                                    $content = $product->get_description();
                                    $content = (array) explode( "\n", $content );
                                ?>
                                <ul>
                                    <li><?php echo implode( '</li><li>', $content ); // WPCS: XSS ok. ?></li>
                                </ul>
                            </div>

                            <div class="<?php echo esc_attr( $purchase_class ); ?>">
                                <a href="<?php echo esc_url( $action_url ); ?>" class="button" title="<?php esc_attr_e( 'Get Started Now', 'pointify' ); ?>"><?php esc_html_e( 'Get Started Now', 'pointify' ); ?></a>
                            </div>
                            </li>

                            <?php endforeach; ?>

                        </ul>

                    </div>
                </div>
            </div>
        </div>
        <?php
        // Add your popular listings code here
        echo $args['after_widget'];
    }

    private function get_packages() {
        $packages = array();
    
        $extensify_job_manager_listing_payment_enable = get_option( 'extensify_job_manager_listing_payment_enable' );
        if( $extensify_job_manager_listing_payment_enable ){
            add_filter( 'astoundify_wpjmlp_get_job_packages_args', array( $this, 'get_packages_filter' ) );
            $packages = astoundify_wpjmlp_get_job_packages();
        }
    
        return apply_filters( 'pointify_pricing_table_packages_results', $packages );
    }
    
    public function get_packages_filter( $args ) {
        return apply_filters( 'pointify_pricing_table_packages', $args );
    }

}

// Register and load the widget
function pointify_pricing_table_widget() {
    register_widget('Pointify_Pricing_Table_Widget');
}
add_action('widgets_init', 'pointify_pricing_table_widget');
