<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Pointify_Widget_Listing_Review extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'pointify_listing_review_widget',
            __('Pointify - Page: Listing Review Widget', 'pointify'),
            array('description' => __('A pointify widget for listing review', 'pointify'))
        );
    }

    // Widget backend
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $heading = ! empty( $instance['heading'] ) ? $instance['heading'] : '';
        $highlighted_title = ! empty( $instance['highlighted_title'] ) ? $instance['highlighted_title'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        $number = ! empty( $instance['number'] ) ? $instance['number'] : 4;
        $background_image = !empty($instance['background_image']) ? $instance['background_image'] : '';
        
        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

		if($style_demo === 'lawyer'){
        ?>
			<p>
				<label for="<?php echo $this->get_field_id( 'heading' ); ?>">Heading:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'heading' ); ?>" name="<?php echo $this->get_field_name( 'heading' ); ?>" type="text" value="<?php echo esc_attr( $heading ); ?>">
			</p>
		<?php } ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <?php
		if($style_demo === 'lawyer'){
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'highlighted_title' ); ?>">Highlighted Title:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'highlighted_title' ); ?>" name="<?php echo $this->get_field_name( 'highlighted_title' ); ?>" type="text" value="<?php echo esc_attr( $highlighted_title ); ?>">
			</p>
		<?php } 
            if($style_demo !== 'lawyer'){
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'pointify'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>

        <?php } ?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of reviews to display:', 'pointify' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" min="1">
        </p>

        <?php 
        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

        if ($style_demo === 'job_board') {
        ?>
        <!-- Widget background image -->
        <p>
            <label for="<?php echo $this->get_field_id('background_image'); ?>"><?php _e('Background Image:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('background_image'); ?>" name="<?php echo $this->get_field_name('background_image'); ?>" type="text" value="<?php echo esc_attr($background_image); ?>">
            <button class="button button-secondary" onclick="openMediaUploader(this); return false;"><?php _e('Select Image', 'pointify'); ?></button>
            <a class="button pointify-widget-media-clear"><?php esc_html_e( 'Clear', 'pointify' ); ?></a>
        </p>
        <?php
        }
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['heading'] = ( ! empty( $new_instance['heading'] ) ) ? sanitize_text_field( $new_instance['heading'] ) : '';
        $instance['highlighted_title'] = ( ! empty( $new_instance['highlighted_title'] ) ) ? sanitize_text_field( $new_instance['highlighted_title'] ) : '';
        $instance['description'] = (!empty($new_instance['description'])) ? sanitize_text_field($new_instance['description']) : '';
        $instance['number'] = ( ! empty( $new_instance['number'] ) ) ? absint( $new_instance['number'] ) : 4;
        $instance['background_image'] = (!empty($new_instance['background_image'])) ? esc_url($new_instance['background_image']) : '';

        return $instance;
    }

    // Widget frontend
    public function widget($args, $instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'Popular Listings';

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

        if($style_demo !== 'lawyer'){
            $description = !empty($instance['description']) ? $instance['description'] : '';
        }

	    if($style_demo === 'job_board'){
            $background_image = esc_url($instance['background_image']);
        }

        if($style_demo === 'lawyer'){ 
            $highlighted_title = !empty($instance['highlighted_title']) ? $instance['highlighted_title'] : '';
            $heading = !empty($instance['heading']) ? $instance['heading'] : '';
        }

        echo $args['before_widget'];

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

        ?>
        <div class="popular-listing-section <?php if ($style_demo === 'job_board') { ?> review_job_board_cls <?php } ?>" <?php if ($style_demo === 'job_board') { ?> style="background-image: url(<?php echo esc_url($background_image); ?>);" <?php } ?> >
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="widget-title-desc-caption">
                            <?php
                                if (!empty($heading) ) {
                                    ?>
                                    <h4><?php echo $heading; ?></h4>
                                    <?php
                                }
                                if (!empty($title) ) {
                                    ?>
                                    <h3 class="high_text" data-hight-text="<?php echo $highlighted_title; ?>"><?php echo $title; ?></h3>
                                    <?php
                                }
                                if (!empty($description)) {
                                    ?>
                                    <p><?php echo esc_html($description); ?></p>
                                    <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>

            <?php
                $post_type = 'job_listing';
                $comment_num = !empty($instance['number']) ? $instance['number'] : '-1';                    

                // Query arguments to retrieve comments for the specified post type
                $comments_args = array(
                    'post_type' => $post_type,
                    'status' => 'approve', 
                    'number' => $comment_num,
                );
                
                // Get comments based on the arguments
                $comments = get_comments($comments_args);

                if ($style_demo === 'job_board') { ?>
                <div class="gallery testimonial-wrapper">                
                    <div class="swiper-container gallery-slider">
                        <div class="swiper-wrapper">
                            <?php
                                if ($comments) {
                                    foreach ($comments as $comment) {
                            ?>
                            <div class="swiper-slide">
                                <div class="testimonial_content">
                                    <h5><?php echo $comment->comment_content; ?></h5>
                                    <?php
                                        if(class_exists('WP_Job_Manager_Reviews')) {
                                            echo '<div class="review_comment_raiting">';
                                                    $average_rating = (float) get_comment_meta( $comment->comment_ID, 'review_average', true );
                                                    if($average_rating){
                                                        echo pointify_reviews_get_stars($comment->comment_ID);
                                                    }
                                            echo '</div>';        
                                        }
                                    ?>
                                    <h4><?php echo $comment->comment_author; ?></h4>
                                </div>
                            </div>
                            <?php 
                                    }
                                }
                            ?>
                        </div>
                        <div class="swiper-button-prev"></div>
                        <div class="swiper-button-next"></div>
                    </div>

                    <div class="swiper-container gallery-thumbs">
                        <div class="swiper-wrapper">
                            <?php
                                if ($comments) {
                                    foreach ($comments as $comment) {
                            ?>
                                <div class="swiper-slide">
                                    <div class="review_author_img">
                                        <?php echo get_avatar( $comment->comment_author ); ?>
                                    </div>
                                </div>
                            <?php 
                                    }
                                }
                            ?>
                        </div>
                    </div>
                </div>
            <?php } elseif ( $style_demo === 'lawyer' ) { ?>
            <div class="container">    
                <div class="row review-main-section" id="masonry-grid">
                    <?php
                        if ($comments) {
                            foreach ($comments as $comment) {
                    ?>
                            <div class="col-md-4 col-lg-3 grid-item">
                                <div class="testimonial_content">
                                    <h5><?php echo $comment->comment_content; ?></h5>
                                    <div class="author-details">
                                        <div class="review_author_img">
                                            <?php echo get_avatar( $comment->comment_author ); ?>
                                        </div>
                                        <div class="author_info">
                                            <h4><?php echo $comment->comment_author; ?></h4>
                                            <?php
                                                if(class_exists('WP_Job_Manager_Reviews')) {
                                                    echo '<div class="review_comment_raiting">';
                                                            $average_rating = (float) get_comment_meta( $comment->comment_ID, 'review_average', true );
                                                            if($average_rating){
                                                                echo pointify_reviews_get_stars($comment->comment_ID);
                                                            }
                                                    echo '</div>';        
                                                }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    <?php 
                            }
                        }
                    ?>
                    <!-- Add more items as needed -->
                </div>
            </div>
            <script>
                document.addEventListener("DOMContentLoaded", function() {
                var elem = document.querySelector('#masonry-grid');
                var msnry = new Masonry(elem, {
                    // options
                    itemSelector: '.grid-item',
                    columnWidth: '.grid-item',
                    percentPosition: true
                });
                });
            </script>
            <?php } else { ?>
                <div class="review_slider owl-carousel">
                    <?php                    
                        // Check if comments exist
                        if ($comments) {
                            // Loop through each comment and display/comment as desired
                            foreach ($comments as $comment) {
                                echo '<div class="item">';
                                    echo '<div class="review_caption_content">';
                                        echo '<div class="review_author_img">';
                                            echo get_avatar( $comment->comment_author );
                                        echo '</div>';
                                        echo '<div class="review_auhtor_content">';
                                            echo '<div class="review_comment">';
                                                echo $comment->comment_content;
                                            echo '</div>';

                                            if(class_exists('WP_Job_Manager_Reviews')) {
                                                echo '<div class="review_comment_raiting">';
                                                        $average_rating = (float) get_comment_meta( $comment->comment_ID, 'review_average', true );
                                                        if($average_rating){
                                                            echo pointify_reviews_get_stars($comment->comment_ID);
                                                        }
                                                echo '</div>';        
                                            }
                                            
                                            echo '<div class="review_auhtor_name">';
                                                echo $comment->comment_author.' - ';
                                                echo pointify_time_ago($comment->comment_date);
                                            echo '</div>';
                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                            }
                        } else {
                            echo _e('No comments found for this post type.', 'pointify');
                        }
                    ?>
                </div>
            <?php } ?>
        </div>
        <?php
        // Add your popular listings code here
        echo $args['after_widget'];
    }

}

// Register and load the widget
function pointify_listing_review_widget() {
    register_widget('Pointify_Widget_Listing_Review');
}
add_action('widgets_init', 'pointify_listing_review_widget');
