<?php
class Pointify_Image_Content_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'pointify-image-content_widget',
            __('Pointify - Page: Image Content Widget', 'pointify'),
            array('description' => __('A widget for uploading images and adding a heading, subheading, and button.', 'pointify'))
        );
    }

    public function widget($args, $instance) {
		
        echo $args['before_widget'];
		$type = !empty($instance['type']) ? $instance['type'] : 'type_one';
        $image_url = !empty($instance['image_url']) ? $instance['image_url'] : '';
        $heading = !empty($instance['heading']) ? $instance['heading'] : '';
        $subheading = !empty($instance['subheading']) ? $instance['subheading'] : '';
        $button_text = !empty($instance['button_text']) ? $instance['button_text'] : '';
        $button_url = !empty($instance['button_url']) ? $instance['button_url'] : '';
		$button_two_text = !empty($instance['button_two_text']) ? $instance['button_two_text'] : '';
        $button_two_url = !empty($instance['button_two_url']) ? $instance['button_two_url'] : '';
        ?>
		<div class="<?php if($type == 'type_two'){echo 'pointify-image-content-type-two';}?> pointify-image-content">
			<div class="container">			
				<div class="pointify-image-content-widget">
					<div class="pointify-image">
					<?php if ($image_url): ?>
						<img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($heading); ?>">
					<?php endif; ?>
					</div>
					<div class="pointify-content">
						<?php if ($heading): ?>
							<h2><?php echo esc_html($heading); ?></h2>
						<?php endif; ?>
						<?php if ($subheading): ?>
							<p><?php echo esc_html($subheading); ?></p>
						<?php endif; ?>
						<?php if ($button_text && $button_url): ?>
							<a href="<?php echo esc_url($button_url); ?>" class="btn-primary"><?php echo esc_html($button_text); ?></a>
						<?php endif; ?>
						<?php if ($type == 'type_two'): ?>
							<?php if ($button_two_text && $button_two_url): ?>
								<a href="<?php echo esc_url($button_two_url); ?>" class="btn-primary"><?php echo esc_html($button_two_text); ?></a>
							<?php endif; ?>
						<?php endif; ?>
					</div>
				</div>				
			</div>
		</div>
        <?php
		
        echo $args['after_widget'];
    }
	
    public function form($instance) {
		$type = !empty($instance['type']) ? $instance['type'] : 'type_one';
        $image_url = !empty($instance['image_url']) ? $instance['image_url'] : '';
        $heading = !empty($instance['heading']) ? $instance['heading'] : '';
        $subheading = !empty($instance['subheading']) ? $instance['subheading'] : '';
        $button_text = !empty($instance['button_text']) ? $instance['button_text'] : '';
        $button_url = !empty($instance['button_url']) ? $instance['button_url'] : '';
		$button_two_text = !empty($instance['button_two_text']) ? $instance['button_two_text'] : '';
        $button_two_url = !empty($instance['button_two_url']) ? $instance['button_two_url'] : '';
		
        ?>
		 <p>
            <label for="<?php echo esc_attr($this->get_field_id('type')); ?>"><?php _e('Type:', 'pointify'); ?></label>
            <select id="<?php echo esc_attr($this->get_field_id('type')); ?>" name="<?php echo esc_attr($this->get_field_name('type')); ?>" class="widefat" style="width:100%;">
                <option value="type_one" <?php selected($type, 'type_one'); ?>>Type 1</option>
                <option value="type_two" <?php selected($type, 'type_two'); ?>>Type 2</option>
            </select>
        </p>
        <!-- <p>
            <label for="<?php //echo $this->get_field_id('image_url'); ?>"><?php //_e('Image URL:', 'pointify'); ?></label>
            <input class="widefat image-url" id="<?php //echo $this->get_field_id('image_url'); ?>" name="<?php //echo $this->get_field_name('image_url'); ?>" type="text" value="<?php //echo esc_attr($image_url); ?>">
            <button class="button select-image"><?php // _e('Select Image', 'pointify'); ?></button>
        </p> -->

        <p>
            <label for="<?php echo $this->get_field_id('image_url'); ?>"><?php _e('Image:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('image_url'); ?>" name="<?php echo $this->get_field_name('image_url'); ?>" type="text" value="<?php echo esc_attr($image_url); ?>">
            <button class="button button-secondary" onclick="openMediaUploader(this); return false;"><?php _e('Select Image', 'pointify'); ?></button>
            <a class="button pointify-widget-media-clear"><?php esc_html_e( 'Clear', 'pointify' ); ?></a>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('heading'); ?>"><?php _e('Heading:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('heading'); ?>" name="<?php echo $this->get_field_name('heading'); ?>" type="text" value="<?php echo esc_attr($heading); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('subheading'); ?>"><?php _e('Subheading:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('subheading'); ?>" name="<?php echo $this->get_field_name('subheading'); ?>" type="text" value="<?php echo esc_attr($subheading); ?>">
        </p>
		
			 <p>
            <label for="<?php echo $this->get_field_id('button_text'); ?>"><?php _e('Button Text:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('button_text'); ?>" name="<?php echo $this->get_field_name('button_text'); ?>" type="text" value="<?php echo esc_attr($button_text); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('button_url'); ?>"><?php _e('Button URL:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('button_url'); ?>" name="<?php echo $this->get_field_name('button_url'); ?>" type="text" value="<?php echo esc_attr($button_url); ?>">
        </p>
		<?php 
		if ($type == 'type_two') { ?>
			<p>
				<label for="<?php echo $this->get_field_id('button_two_text'); ?>"><?php _e('Button Two Text:', 'pointify'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('button_two_text'); ?>" name="<?php echo $this->get_field_name('button_two_text'); ?>" type="text" value="<?php echo esc_attr($button_two_text); ?>">
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('button_two_url'); ?>"><?php _e('Button URL:', 'pointify'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('button_two_url'); ?>" name="<?php echo $this->get_field_name('button_two_url'); ?>" type="text" value="<?php echo esc_attr($button_two_url); ?>">
			</p>
		<?php	
		}
		
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
		$instance['type'] = (!empty($new_instance['type'])) ? strip_tags($new_instance['type']) : '';
        $instance['image_url'] = (!empty($new_instance['image_url'])) ? strip_tags($new_instance['image_url']) : '';
        $instance['heading'] = (!empty($new_instance['heading'])) ? strip_tags($new_instance['heading']) : '';
        $instance['subheading'] = (!empty($new_instance['subheading'])) ? strip_tags($new_instance['subheading']) : '';
        $instance['button_text'] = (!empty($new_instance['button_text'])) ? strip_tags($new_instance['button_text']) : '';
        $instance['button_url'] = (!empty($new_instance['button_url'])) ? strip_tags($new_instance['button_url']) : '';
	    $instance['button_two_text'] = (!empty($new_instance['button_two_text'])) ? strip_tags($new_instance['button_two_text']) : '';
        $instance['button_two_url'] = (!empty($new_instance['button_two_url'])) ? strip_tags($new_instance['button_two_url']) : '';
        return $instance;
    }
}

function register_pointify_image_content_widget() {
    register_widget('Pointify_Image_Content_Widget');
}
add_action('widgets_init', 'register_pointify_image_content_widget');
?>

