<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Pointify_Widget_How_It_Works extends WP_Widget {

    // Widget setup.
    public function __construct() {
        $widget_ops = array(
            'classname'   => 'widget-home-how-it-works',
            'description' => esc_html__( 'Display a how it work area.', 'pointify' ),
        );
        parent::__construct( 'pointify_widget_how_it_works', esc_html__( 'Pointify - Page: How it works', 'pointify' ), $widget_ops );
    }

    // Widget form creation
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $heading = ! empty( $instance['heading'] ) ? $instance['heading'] : '';
        $highlighted_title = ! empty( $instance['highlighted_title'] ) ? $instance['highlighted_title'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        $background_image = !empty($instance['background_image']) ? $instance['background_image'] : '';
        $content = ! empty( $instance['content'] ) ? $instance['content'] : '';

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

		if($style_demo === 'lawyer'){
        ?>
			<p>
				<label for="<?php echo $this->get_field_id( 'heading' ); ?>">Heading:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'heading' ); ?>" name="<?php echo $this->get_field_name( 'heading' ); ?>" type="text" value="<?php echo esc_attr( $heading ); ?>">
			</p>
		<?php } ?>

        <!-- Widget title -->
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <?php
		if($style_demo === 'lawyer'){
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'highlighted_title' ); ?>">Highlighted Title:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'highlighted_title' ); ?>" name="<?php echo $this->get_field_name( 'highlighted_title' ); ?>" type="text" value="<?php echo esc_attr( $highlighted_title ); ?>">
			</p>
		<?php } ?>

        <!-- Widget description -->
        <p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'pointify'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>

        <!-- Widget background image -->
        <p>
            <label for="<?php echo $this->get_field_id('background_image'); ?>"><?php _e('Background Image:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('background_image'); ?>" name="<?php echo $this->get_field_name('background_image'); ?>" type="text" value="<?php echo esc_attr($background_image); ?>">
            <button class="button button-secondary" onclick="openMediaUploader(this); return false;"><?php _e('Select Image', 'pointify'); ?></button>
            <a class="button pointify-widget-media-clear"><?php esc_html_e( 'Clear', 'pointify' ); ?></a>
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"><?php _e( 'Content:', 'pointify' ); ?></label>
            <?php wp_editor( $content, $this->get_field_id( 'content' ), array( 'textarea_name' => $this->get_field_name( 'content' ) ) ); ?>
        </p>

        <?php
    }

    // Widget update
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['heading'] = ( ! empty( $new_instance['heading'] ) ) ? sanitize_text_field( $new_instance['heading'] ) : '';
        $instance['highlighted_title'] = ( ! empty( $new_instance['highlighted_title'] ) ) ? sanitize_text_field( $new_instance['highlighted_title'] ) : '';
        $instance['description'] = (!empty($new_instance['description'])) ? sanitize_text_field($new_instance['description']) : '';
        $instance['background_image'] = (!empty($new_instance['background_image'])) ? esc_url($new_instance['background_image']) : '';
        $instance['content'] = ( ! empty( $new_instance['content'] ) ) ? $new_instance['content'] : '';

        return $instance;
    }

    // Widget display
    public function widget($args, $instance) {

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

        $title = apply_filters('widget_title', $instance['title']);
        if($style_demo === 'lawyer'){ 
            $highlighted_title = !empty($instance['highlighted_title']) ? $instance['highlighted_title'] : '';
            $heading = !empty($instance['heading']) ? $instance['heading'] : '';
        }
        $description = esc_html($instance['description']);
        $background_image = esc_url($instance['background_image']);

        // Output before widget
        echo $args['before_widget'];

        ?>
        <div class="pointify-how-it-works" style="background-image: url(<?php echo esc_url($background_image); ?>);">
            <div class="container">
                    <?php 
                        if($style_demo === 'lawyer'){ 
                    ?>
                    <div class="row <?php if($style_demo === 'lawyer'){ ?>lawyer_work_sec<?php } ?> ">
                        <div class="col-md-6">
                            <div class="widget-title-desc-caption">
                                <?php
                                    if (!empty($description)) {
                                        ?>
                                        <p><?php echo esc_html($description); ?></p>
                                        <?php
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="widget-title-desc-caption">
                                <?php
                                    if (!empty($heading) ) {
                                        ?>
                                        <h4><?php echo $heading; ?></h4>
                                        <?php
                                    }
                                    if (!empty($title) ) {
                                        ?>
                                        <h3 class="high_text" data-hight-text="<?php echo $highlighted_title; ?>"><?php echo $title; ?></h3>
                                        <?php
                                    }
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="how-it-work-feature">
                            <div class="feature-box-main-section">
                                <div class="row">
                                    <?php
                                        echo ! empty( $instance['content'] ) ? $instance['content'] : '';
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                        <?php
                        } else {
                        ?>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="widget-title-desc-caption">
                                <?php
                                    if (!empty($title) ) {
                                        ?>
                                        <h3><?php echo $title; ?></h3>
                                        <?php
                                    }
                                    if (!empty($description)) {
                                        ?>
                                        <p><?php echo esc_html($description); ?></p>
                                        <?php
                                    }
                                ?>
                            </div>
                            <div class="how-it-work-feature">
                                <div class="feature-box-main-section">
                                    <div class="row">
                                        <?php
                                            echo ! empty( $instance['content'] ) ? $instance['content'] : '';
                                        ?>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    <?php } ?>
                
            </div>
        </div>
        <?php
        echo $args['after_widget'];
    }

}

// Register the widget.
function register_pointify_widget_how_it_works() {
    register_widget( 'Pointify_Widget_How_It_Works' );
}
add_action( 'widgets_init', 'register_pointify_widget_how_it_works' );

