<?php
/**
 * Home: Taxonomy Image Grid
 *
 * @since Pointify 1.0.0
 */

// Widget class
class Pointify_Widget_Taxonomy_Image_Grid extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'register_pointify_taxonomy_image_grid_widget',
            'Pointify - Taxonomy Image Grid Widget',
            array( 'description' => 'Display a grid of images from a taxonomy.' )
        );
    }

    public function widget( $args, $instance ) {
        // Widget output
        echo $args['before_widget'];

        // Widget title
        $title = !empty($instance['title']) ? $instance['title'] : '';

		$style_demo = get_theme_mod( 'pointify_demo_selection', '' );
		if($style_demo === 'lawyer'){ 
			$heading = !empty($instance['heading']) ? $instance['heading'] : '';
			$highlighted_title = !empty($instance['highlighted_title']) ? $instance['highlighted_title'] : '';
		}
		$description = !empty($instance['description']) ? $instance['description'] : '';
		
		?>

		<div class="popular-listing-section taxonomy-widget-section">
			<div class="container">
				<div class="row">
					<?php 
						

						if($style_demo === 'job_board'){ 
					?>
						<div class="col-md-12">
							<div class="widget-title-desc-caption">
								<?php
									if (!empty($title) ) {
										?>
										<h3><?php echo $title; ?></h3>
										<?php
									}
									if (!empty($description)) {
										?>
										<p><?php echo esc_html($description); ?></p>
										<?php
									}
								?>
							</div>
						</div>
					<?php	
						}elseif ( $style_demo === 'lawyer' ) {
							?>
							<div class="col-md-6">
								<div class="widget-title-desc-caption">
									<?php
										if(!empty($heading)){ ?>
											<h4><?php echo $heading; ?></h4>
									<?php }
										if (!empty($title) ) {
											?>
											<h3 class="high_text" data-hight-text="<?php echo $highlighted_title; ?>"><?php echo $title; ?></h3>
											<?php
										}
										if (!empty($description)) {
											?>
											<p><?php echo esc_html($description); ?></p>
											<?php
										}
									?>
								</div>
							</div>
						<?php
						} else { 
					?>
					<div class="col-md-6">
						<div class="widget-title-desc-caption">
							<?php
								if (!empty($title) ) {
									?>
									<h3><?php echo $title; ?></h3>
									<?php
								}
							?>
						</div>
					</div>
					<div class="col-md-6">
						<div class="widget-title-desc-caption">
							<?php
								if (!empty($description)) {
									?>
									<p><?php echo esc_html($description); ?></p>
									<?php
								}
							?>
						</div>
					</div>
					<?php } ?>
				</div>
			</div>

			<div class="taxonomy-main-section">
				<?php 

					// Widget content
					$taxonomy = 'job_listing_category';
					$terms = get_terms( array(
						'taxonomy' => $taxonomy,
						'hide_empty' => false,
						'number' => $instance['number'],
					) );

					$style_demo = get_theme_mod( 'pointify_demo_selection', '' );
						
					if ( $terms ) {
						?>
						<div class="custom-taxonomy-image-grid <?php if($style_demo !== 'lawyer'){ ?>  grid-taxonomy-<?php echo $instance['number']; } ?>">
						<?php	
						foreach ( $terms as $term ) {
			
							// $display_type = get_term_meta( $term->term_id );
			
							// echo '<pre>';
							// print_r($display_type);
							// echo '</pre>';	

						
							$term_details = get_term($term->term_id);
							$term_count = $term_details->count;


							$thumbnail_id = get_term_meta( $term->term_id, 'thumbnail_id', true );
							$thumbnail_bg_id = get_term_meta( $term->term_id, 'thumbnail_bg_id', true );
							$feature_image_url = wp_get_attachment_image_url( $thumbnail_id, 'thumbnail' );
							$feature_bg_image_url = wp_get_attachment_image_url( $thumbnail_bg_id, 'thumbnail' );

						?>
							<div class="term-list" <?php if($style_demo !== 'job_board' && $style_demo !== 'lawyer' ){ ?> style="background-image: url(<?php echo esc_url($feature_bg_image_url); ?>);" <?php } ?>>
								<div class="term-details">
									<?php if($feature_image_url) { ?>
										<div class="cat-feat-img">
											<img src="<?php echo esc_url($feature_image_url); ?>" alt="<?php echo esc_attr( $term->name ); ?>"/>
										</div>
									<?php } ?>
									<h4><a href="<?php echo esc_url(get_term_link( $term )); ?>" title="<?php echo esc_html( $term->name );  ?>"><?php echo esc_html( $term->name );  ?></a></h4>
									<?php 
									if($style_demo === 'job_board' ){
										if (!empty($instance['display_count'])) {  
									?>
											<p><?php echo $term_count . ' Jobs'; ?></p>
									<?php 
										}
									} elseif ($style_demo === 'lawyer') {
										?>
											<p><?php echo $term_count . ' Advocate'; ?></p>
										<?php
									}
									?>
								</div>
							</div>
							<?php
						}
						?>
						</div>
						<?php
					}

				?>
			</div>
		</div>
		<?php
        echo $args['after_widget'];
    }

    public function form( $instance ) {
        // Widget form
        $title = ! empty( $instance['title'] ) ? $instance['title'] : '';
        $heading = ! empty( $instance['heading'] ) ? $instance['heading'] : '';
        $highlighted_title = ! empty( $instance['highlighted_title'] ) ? $instance['highlighted_title'] : '';
		$description = !empty($instance['description']) ? $instance['description'] : '';
		$number = ! empty( $instance['number'] ) ? $instance['number'] : '';
		$display_count = !empty($instance['display_count']) ? $instance['display_count'] : '0';
		$style_demo = get_theme_mod( 'pointify_demo_selection', '' );

		if($style_demo === 'lawyer'){
        ?>
			<p>
				<label for="<?php echo $this->get_field_id( 'heading' ); ?>">Heading:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'heading' ); ?>" name="<?php echo $this->get_field_name( 'heading' ); ?>" type="text" value="<?php echo esc_attr( $heading ); ?>">
			</p>
		<?php } ?>

        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>

		<?php
		if($style_demo === 'lawyer'){
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'highlighted_title' ); ?>">Highlighted Title:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'highlighted_title' ); ?>" name="<?php echo $this->get_field_name( 'highlighted_title' ); ?>" type="text" value="<?php echo esc_attr( $highlighted_title ); ?>">
			</p>
		<?php } ?>

		<p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'pointify'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>
		<p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of taxonomy to display:', 'pointify' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number" value="<?php echo esc_attr( $number ); ?>" min="1">
        </p>
		<?php
			if($style_demo === 'job_board'){
		?>
			<p>
				<input class="checkbox" type="checkbox" <?php checked($display_count, '1'); ?> id="<?php echo esc_attr($this->get_field_id('display_count')); ?>" name="<?php echo esc_attr($this->get_field_name('display_count')); ?>" value="1" />
				<label for="<?php echo esc_attr($this->get_field_id('display_count')); ?>"><?php _e('Display Count', 'pointify'); ?></label>
			</p>
		<?php
			}
    }

    public function update( $new_instance, $old_instance ) {
        // Save widget settings
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
        $instance['heading'] = ( ! empty( $new_instance['heading'] ) ) ? sanitize_text_field( $new_instance['heading'] ) : '';
        $instance['highlighted_title'] = ( ! empty( $new_instance['highlighted_title'] ) ) ? sanitize_text_field( $new_instance['highlighted_title'] ) : '';
		$instance['description'] = (!empty($new_instance['description'])) ? sanitize_text_field($new_instance['description']) : '';
		$instance['number'] = ( ! empty( $new_instance['number'] ) ) ? absint( $new_instance['number'] ) : '';
		$instance['display_count'] = (!empty($new_instance['display_count'])) ? strip_tags($new_instance['display_count']) : '0';

        return $instance;
    }
}

// Register the widget
function register_pointify_taxonomy_image_grid_widget() {
    register_widget( 'Pointify_Widget_Taxonomy_Image_Grid' );
}
add_action( 'widgets_init', 'register_pointify_taxonomy_image_grid_widget' );
