<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Pointify_Widget_Blog_Posts extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'pointify_blog_posts_widget',
            __('Pointify - Page: Blog Posts Widget', 'pointify'),
            array('description' => __('A pointify widget for blog posts', 'pointify'))
        );
    }

    // Widget backend
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $heading = ! empty( $instance['heading'] ) ? $instance['heading'] : '';
        $highlighted_title = ! empty( $instance['highlighted_title'] ) ? $instance['highlighted_title'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        $number = ! empty( $instance['number'] ) ? $instance['number'] : 4;

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

		if($style_demo === 'lawyer'){
        ?>
			<p>
				<label for="<?php echo $this->get_field_id( 'heading' ); ?>">Heading:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'heading' ); ?>" name="<?php echo $this->get_field_name( 'heading' ); ?>" type="text" value="<?php echo esc_attr( $heading ); ?>">
			</p>
		<?php } ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <?php
		if($style_demo === 'lawyer'){
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'highlighted_title' ); ?>">Highlighted Title:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'highlighted_title' ); ?>" name="<?php echo $this->get_field_name( 'highlighted_title' ); ?>" type="text" value="<?php echo esc_attr( $highlighted_title ); ?>">
			</p>
		<?php } 
        if($style_demo !== 'lawyer'){
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'pointify'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>
        <?php 
            }
            if($style_demo !== 'job_board'){ ?>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of posts to display:', 'pointify' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number" value="<?php echo esc_attr( $number ); ?>" min="1">
            </p>
        <?php
        }
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['heading'] = ( ! empty( $new_instance['heading'] ) ) ? sanitize_text_field( $new_instance['heading'] ) : '';
        $instance['highlighted_title'] = ( ! empty( $new_instance['highlighted_title'] ) ) ? sanitize_text_field( $new_instance['highlighted_title'] ) : '';
        $instance['description'] = (!empty($new_instance['description'])) ? sanitize_text_field($new_instance['description']) : '';
        $instance['number'] = ( ! empty( $new_instance['number'] ) ) ? absint( $new_instance['number'] ) : 4;

        return $instance;
    }

    // Widget frontend
    public function widget($args, $instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'Popular Listings';

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );
		if($style_demo === 'lawyer'){ 
			$heading = !empty($instance['heading']) ? $instance['heading'] : '';
			$highlighted_title = !empty($instance['highlighted_title']) ? $instance['highlighted_title'] : '';
		}

        if($style_demo !== 'lawyer'){
            $description = !empty($instance['description']) ? $instance['description'] : '';
        }

        echo $args['before_widget'];
        ?>
        <div class="popular-listing-section">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="widget-title-desc-caption">
                            <?php
                                if (!empty($heading) ) {
                                    ?>
                                    <h4><?php echo $heading; ?></h4>
                                    <?php
                                }
                                if (!empty($title) ) {
                                    ?>
                                    <h3 class="high_text" data-hight-text="<?php echo $highlighted_title; ?>"><?php echo $title; ?></h3>
                                    <?php
                                }
                                if (!empty($description)) {
                                    ?>
                                    <p><?php echo esc_html($description); ?></p>
                                    <?php
                                }
                            ?>
                        </div>
                        <?php
                            $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

                            if($style_demo === 'job_board'){
                                $post_num = 2;
                            }else{
                                $post_num = $instance['number'];
                            }
                        ?>
                        <div class="popular-listing-caption post-section grid-<?php echo $post_num; ?>">
                            <?php 
                                $query_args = array(
                                    'post_type'      => 'post',
                                    'posts_per_page' => $post_num,
                                );
                        
                                $latest_posts = new WP_Query( $query_args );
                        
                                if ( $latest_posts->have_posts() ) :
                                    while ( $latest_posts->have_posts() ) : $latest_posts->the_post(); ?>
                        
                                        <div class="post-grid-section">
                                            <?php 
                                                if($style_demo === 'job_board'){
                                                    pointify_get_the_category();
                                                }
                                                if ( has_post_thumbnail() ) : ?>
                                                <div class="post-thumbnail">
                                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                                        <?php the_post_thumbnail( 'full' ); ?>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                        
                                            <div class="post-content">
                                                <h4><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>
                                                <div class="post-pubished-details">
                                                    <?php
                                                        if($style_demo === 'job_board'){
                                                            echo get_the_author_meta('display_name');
                                                        }
                                                    ?>
                                                    <?php 
                                                        pointify_post_time_details(); 
                                                        if($style_demo !== 'job_board'){
                                                    ?>
                                                            <p class="comment-count"><?php comments_number( '0', '1', '%' ); ?></p>
                                                    <?php } ?>
                                                </div>
                                                <?php
                                                    if($style_demo === 'job_board'){
                                                        if ( has_excerpt() ) {
                                                            the_excerpt();
                                                        }
                                                ?>
                                                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="btn-primary"><?php _e('Read More', 'pointify'); ?></a>
                                                <?php } ?>
                                            </div>
                                        </div>
                        
                                    <?php endwhile;
                                    wp_reset_postdata();
                                endif;
                                
                            if($style_demo === 'job_board'){
                            ?>
                            <div class="shape_one">
                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/job-board/shape-1.png" />
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        // Add your popular listings code here
        echo $args['after_widget'];
    }

}

// Register and load the widget
function pointify_blog_posts_widget() {
    register_widget('Pointify_Widget_Blog_Posts');
}
add_action('widgets_init', 'pointify_blog_posts_widget');
