<?php
// Register the widget
function job_single_map_widgets_init() {
    register_widget( 'Job_Single_Map_Widget' );
}
add_action( 'widgets_init', 'job_single_map_widgets_init' );

// Create the widget class
class Job_Single_Map_Widget extends WP_Widget {

    // Constructor
    function __construct() {
        parent::__construct(
            'job_single_map_widgets_init',
            __( 'Pointify - Job Single Map Widget', 'pointify' ),
            array( 'description' => __( 'A widget to display map', 'pointify' ), )
        );
    }

    // Widget form
    public function form( $instance ) {
        $title = isset($instance['title']) ? $instance['title'] : '';
        $location_checked = isset( $instance['location'] ) ? $instance['location'] : '';
        $email_checked = isset( $instance['email'] ) ? $instance['email'] : '';
        $siteurl_checked = isset( $instance['siteurl'] ) ? $instance['siteurl'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Title:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <?php
    }

    // Update widget settings
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = sanitize_text_field($new_instance['title']);
        return $instance;
    }

    // Display the widget
    public function widget( $args, $instance ) {
        $title = isset($instance['title']) ? $instance['title'] : '';
        
        echo $args['before_widget'];
        $job_id = get_the_ID();
        $location = get_post_meta( $job_id, '_job_location', true );
        if ( $location ) {
            ?>
            <div class="listing-location-info">
                <?php
                    if(!empty($title)){ ?>
                        <div class="location_title">
                            <h2 class="widget-title"><?php echo $title; ?></h2>
                        </div><?php
                    }
                ?>
                <div id="job-listing-map" style="width: 100%; height: 250px;"></div>
                <script>
                    function initMap() {
                        var geocoder = new google.maps.Geocoder();
                        var map = new google.maps.Map(document.getElementById('job-listing-map'), {
                            zoom: 12,
                            center: {lat: -34.397, lng: 150.644} // Default center if geocoding fails
                        });
                        geocoder.geocode({ 'address': '<?php echo esc_js( $location ); ?>' }, function(results, status) {
                            if (status === 'OK') {
                                map.setCenter(results[0].geometry.location);
                                var marker = new google.maps.Marker({
                                    map: map,
                                    position: results[0].geometry.location
                                });
                            }
                        });
                    }
                    initMap();
                </script>
                <?php  
                    $google_api = get_option( 'job_manager_google_maps_api_key' );
                ?>
                <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo $google_api; ?>&callback=initMap" async defer></script>
            </div>
            <?php
        }
        ?>
        <?php        
        echo $args['after_widget'];
    }
}
