<?php

/**
 * Add Pointify Option Menu
 */

add_action('admin_menu', 'pointify_custom_menu');

function pointify_custom_menu() {
    add_menu_page(
        'Unlock Feature',  // Page title
        'Pointify Features',  // Menu title
        'manage_options', 
        'pointify-unlock-feature', 
        'pointify_unlock_feature_page',  
        'dashicons-unlock', 
        99 
    );
}

function pointify_unlock_feature_page() {
    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions to access this page.', 'pointify'));
    }
    ?>
    <style>
        img {
            width: 100%;
            max-width: 100%;
        }
        .pointify-plugin-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }
        .pointify-plugin-item {
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            text-align: left;
            position: relative;
        }
        .pointify-plugin-item-content {
            padding: 20px;
        }
        .pointify-plugin-item h3 {
            margin-top: 0;
            font-size: 1.2em;
            line-height: initial;
            min-height: 40px;
        }
        .pointify-plugin-item p {
            margin: 15px 0;
        }
        span.plugin_tag {
            position: absolute;
            top: 35px;
            left: 30px;
            padding: 2px 16px;
            color: #fff;
            font-size: 11px;
            font-style: normal;
            font-weight: 600;
            text-transform: uppercase;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50px;
            background: #13B837;
        }
        span.plugin_tag.paid {
            background: #247EF4;
        }
    </style>
    <div class="wrap">
        <h1><?php esc_html_e('Unlock Feature of pointify', 'pointify'); ?></h1>
        <div class="pointify-plugin-grid">

            <div class="pointify-plugin-item">
                <span class="plugin_tag paid">Paid</span>
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/extensify.png">
                <div class="pointify-plugin-item-content">
                    <h3>Extensify</h3>
                    <?php
                        $extensify_plug = 'extensify/extensify.php';
                        if (file_exists(WP_PLUGIN_DIR . '/' . $extensify_plug) && !is_plugin_active($extensify_plug) ) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary">Activate Plugin</a>
                            <?php
                        }else if(is_plugin_active($extensify_plug)) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary" disabled>Activated</a>
                            <?php
                        }else{   
                            $extensify_plug_url = 'https://astoundify.com/products/extensify/';
                    ?>
                        <a href="<?php echo esc_url($extensify_plug_url); ?>" target="_blank" class="button button-primary">Download Plugin</a>
                    <?php } ?>    
                </div>
            </div>

            <div class="pointify-plugin-item">
                <span class="plugin_tag">Free</span>
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/contact-listing.png">
                <div class="pointify-plugin-item-content">
                    <h3>Contact Listing for WP Job Manager</h3>
                    <?php
                        $contact_listing_plug = 'wp-job-manager-contact-listing/wp-job-manager-contact-listing.php';
                        if (file_exists(WP_PLUGIN_DIR . '/' . $contact_listing_plug) && !is_plugin_active($contact_listing_plug) ) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary">Activate Plugin</a>
                            <?php
                        }else if(is_plugin_active($contact_listing_plug)) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary" disabled>Activated</a>
                            <?php
                        }else{   
                            $contact_listing_plug_url = 'https://astoundify.com/products/wp-job-manager-contact-listing/';
                    ?>
                        <a href="<?php echo esc_url($contact_listing_plug_url); ?>" target="_blank" class="button button-primary">Download Plugin</a>
                    <?php } ?>

                </div>
            </div>

            <div class="pointify-plugin-item">
                <span class="plugin_tag">Free</span>
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/favorites.png">
                <div class="pointify-plugin-item-content">
                    <h3>Favorites by Astoundify</h3>
                    <?php
                        $favorites_plug = 'wp-favorites/astoundify-favorites.php';
                        if (file_exists(WP_PLUGIN_DIR . '/' . $favorites_plug) && !is_plugin_active($favorites_plug) ) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary">Activate Plugin</a>
                            <?php
                        }else if(is_plugin_active($favorites_plug)) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary" disabled>Activated</a>
                            <?php
                        }else{   
                            $favorites_plug_url = 'https://astoundify.com/products/favorites/';
                    ?>
                            <a href="<?php echo esc_url($favorites_plug_url); ?>" target="_blank" class="button button-primary">Download Plugin</a>
                    <?php } ?>        
                </div>
            </div>

            <div class="pointify-plugin-item">
                <span class="plugin_tag">Free</span>
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/listing-labels.png">
                <div class="pointify-plugin-item-content">
                    <h3>Listing Labels for WP Job Manager</h3>
                    <?php
                        $listing_labels_plug = 'wp-job-manager-listing-labels/wp-job-manager-listing-labels.php';
                        if (file_exists(WP_PLUGIN_DIR . '/' . $listing_labels_plug) && !is_plugin_active($listing_labels_plug) ) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary">Activate Plugin</a>
                            <?php
                        }else if(is_plugin_active($listing_labels_plug)) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary" disabled>Activated</a>
                            <?php
                        }else{   
                            $listing_labels_plug_url = 'https://astoundify.com/products/listing-labels/';
                    ?>
                            <a href="<?php echo esc_url($listing_labels_plug_url); ?>" target="_blank" class="button button-primary">Download Plugin</a>
                    <?php } ?>        
                </div>
            </div>

            <div class="pointify-plugin-item">
                <span class="plugin_tag">Free</span>
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/reviews.png">
                <div class="pointify-plugin-item-content">
                    <h3>Reviews for WP Job Manager</h3>
                    <?php
                        $reviews_plug = 'wp-job-manager-reviews/wp-job-manager-reviews.php';
                        if (file_exists(WP_PLUGIN_DIR . '/' . $reviews_plug) && !is_plugin_active($reviews_plug) ) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary">Activate Plugin</a>
                            <?php
                        }else if(is_plugin_active($reviews_plug)) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary" disabled>Activated</a>
                            <?php
                        }else{   
                            $reviews_plug_url = 'https://astoundify.com/products/wp-job-manager-reviews/';
                    ?>
                            <a href="<?php echo esc_url($reviews_plug_url); ?>" target="_blank" class="button button-primary">Download Plugin</a>
                    <?php } ?>        
                </div>    
            </div>

            <div class="pointify-plugin-item">
                <span class="plugin_tag">Free</span>
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/register.png">
                <div class="pointify-plugin-item-content">
                    <h3>Simple Registration for WooCommerce</h3>
                    <?php
                        $register_plug = 'wc-simple-registration/woocommerce-simple-registration.php';
                        if (file_exists(WP_PLUGIN_DIR . '/' . $register_plug) && !is_plugin_active($register_plug) ) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary">Activate Plugin</a>
                            <?php
                        }else if(is_plugin_active($register_plug)) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary" disabled>Activated</a>
                            <?php
                        }else{   
                            $register_plug_url = 'https://astoundify.com/products/woocommerce-simple-registration/';
                    ?>
                        <a href="<?php echo esc_url($register_plug_url); ?>" target="_blank" class="button button-primary">Download Plugin</a>
                    <?php } ?>    
                </div>
            </div>

            <div class="pointify-plugin-item">
                <span class="plugin_tag">Free</span>
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/region.png">
                <div class="pointify-plugin-item-content">
                    <h3>Predefined Regions</h3>
                    <?php
                        $region_plug = 'wp-job-manager-regions/wp-job-manager-locations.php';
                        if (file_exists(WP_PLUGIN_DIR . '/' . $region_plug) && !is_plugin_active($region_plug) ) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary">Activate Plugin</a>
                            <?php
                        }else if(is_plugin_active($region_plug)) {
                            ?>
                            <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" target="_blank" class="button button-primary" disabled>Activated</a>
                            <?php
                        }else{   
                            $region_plug_url = 'https://astoundify.com/products/predefined-regions/';
                    ?>
                        <a href="<?php echo esc_url($region_plug_url); ?>" target="_blank" class="button button-primary">Download Plugin</a>
                    <?php } ?>    
                </div>
            </div>

        </div>
    </div>
    <?php
}
