<?php
/**
 * Map Settings
 *
 * Lazy in one file for now.
 *
 * @uses $wp_customize
 * @since 3.5.0
 */

function pointify_customizer_map_sections($wp_customize) {

$wp_customize->add_section( 'map-settings', array(
	'title' => _x( 'Map Settings', 'customizer section title (colors)', 'pointify' ),
	'priority' => 50,
) );


// google api
// $wp_customize->add_setting( 'map-behavior-api-key', array(
// 	'default' => '',
// 	'sanitize_callback' => 'esc_attr',
// ) );

// $wp_customize->add_control( 'map-behavior-api-key', array(
// 	'label' => __( 'Google Maps API Key', 'pointify' ),
// 	'description' => sprintf( __( 'Learn how to %s', 'pointify' ), '<a href="' . esc_url( 'http://jobify.astoundify.com/article/856-create-a-google-maps-api-key' ) . '" target="_blank">' . __( 'create a Google Maps API key', 'pointify' ) . '</a>' ),
// 	'priority' => 10,
// 	'section' => 'map-settings',
// ) );

// Map Show
$wp_customize->add_setting( 'map-display', array(
	'default' => 'top',
	'sanitize_callback' => 'esc_attr',
) );

$wp_customize->add_control( 'map-display', array(
	'label' => __( 'Map Display', 'pointify' ),
	'priority' => 20,
	'type' => 'select',
	'choices' => array(
		'top' => __( 'Top', 'pointify' ),
		'right' => __( 'Right', 'pointify' ),
	),
	'section' => 'map-settings',
) );

// info trigger
// $wp_customize->add_setting( 'map-behavior-trigger', array(
// 	'default' => 'mouseover',
// 	'sanitize_callback' => 'esc_attr',
// ) );

// $wp_customize->add_control( 'map-behavior-trigger', array(
// 	'label' => __( 'Marker Popup Trigger', 'pointify' ),
// 	'priority' => 20,
// 	'type' => 'select',
// 	'choices' => array(
// 		'mouseover' => __( 'Hover', 'pointify' ),
// 		'click' => __( 'Click', 'pointify' ),
// 	),
// 	'section' => 'map-settings',
// ) );

// autofit
// $wp_customize->add_setting( 'map-behavior-autofit', array(
// 	'default' => true,
// 	'sanitize_callback' => 'esc_attr',
// ) );

// $wp_customize->add_control( 'map-behavior-autofit', array(
// 	'label' => __( 'Autofit Pins', 'pointify' ),
// 	'description' => __( 'Ensure all active pins are shown in the initial map view.', 'pointify' ),
// 	'type' => 'checkbox',
// 	'priority' => 28,
// 	'section' => 'map-settings',
// ) );

// center
// $wp_customize->add_setting( 'map-behavior-center', array(
// 	'default' => '',
// 	'sanitize_callback' => 'esc_attr',
// ) );

// $wp_customize->add_control( 'map-behavior-center', array(
// 	'label' => __( 'Default Location View', 'pointify' ),
// 	'description' => __( 'The default coordinates view if autofit is disabled. Ex <code>42.0616453, -88.2670675</code>', 'pointify' ),
// 	'priority' => 30,
// 	'section' => 'map-settings',
// ) );

// clusters
// $wp_customize->add_setting( 'map-behavior-clusters', array(
// 	'default' => true,
// 	'sanitize_callback' => 'esc_attr',
// ) );

// $wp_customize->add_control( 'map-behavior-clusters', array(
// 	'label' => __( 'Cluster Markers in Proximity', 'pointify' ),
// 	'priority' => 50,
// 	'type' => 'checkbox',
// 	'section' => 'map-settings',
// ) );

// grid size
// $wp_customize->add_setting( 'map-behavior-grid-size', array(
// 	'default' => 60,
// 	'sanitize_callback' => 'esc_attr',
// ) );

// $wp_customize->add_control( 'map-behavior-grid-size', array(
// 	'label' => __( 'Cluster Grid Size (px)', 'pointify' ),
// 	'priority' => 60,
// 	'description' => __( 'How close the markers are before the clusters appear.', 'pointify' ),
// 	'section' => 'map-settings',
// ) );

// default zoom
// $wp_customize->add_setting( 'map-behavior-zoom', array(
// 	'default' => 3,
// 	'sanitize_callback' => 'esc_attr',
// ) );

// $wp_customize->add_control( 'map-behavior-zoom', array(
// 	'label' => __( 'Default Zoom', 'pointify' ),
// 	'description' => __( '<strong>1</strong>: World, <strong>5</strong>: Landmass/continent, <strong>10</strong>: City, <strong>15</strong>: Streets, <strong>20</strong>: Buildings', 'pointify' ),
// 	'choices' => range( 1, 20 ),
// 	'type' => 'select',
// 	'priority' => 70,
// 	'section' => 'map-settings',
// ) );

// max zoom in
// $wp_customize->add_setting( 'map-behavior-max-zoom', array(
// 	'default' => 17,
// 	'sanitize_callback' => 'esc_attr',
// ) );

// $wp_customize->add_control( 'map-behavior-max-zoom', array(
// 	'label' => __( 'Maximum Zoom In', 'pointify' ),
// 	'description' => __( 'Must be larger than Default Zoom and Maximum Zoom Out', 'pointify' ),
// 	'choices' => range( 1, 20 ),
// 	'type' => 'select',
// 	'priority' => 80,
// 	'section' => 'map-settings',
// ) );

// // max zoom out
// $wp_customize->add_setting( 'map-behavior-max-zoom-out', array(
// 	'default' => 3,
// 	'sanitize_callback' => 'esc_attr',
// ) );

// $wp_customize->add_control( 'map-behavior-max-zoom-out', array(
// 	'label' => __( 'Maximum Zoom Out', 'pointify' ),
// 	'description' => __( 'Must be equal to or larger than Default Zoom and less than Maximum Zoom In', 'pointify' ),
// 	'choices' => range( 1, 20 ),
// 	'type' => 'select',
// 	'priority' => 90,
// 	'section' => 'map-settings',
// ) );

// // scrollwheel
// $wp_customize->add_setting( 'map-behavior-scrollwheel', array(
// 	'default' => false,
// 	'sanitize_callback' => 'esc_attr',
// ) );

// $wp_customize->add_control( 'map-behavior-scrollwheel', array(
// 	'label' => __( 'Zoom with Scrollwheel', 'pointify' ),
// 	'type' => 'checkbox',
// 	'priority' => 100,
// 	'section' => 'map-settings',
// ) );

}
add_action('customize_register', 'pointify_customizer_map_sections');