<?php
/**
 * Colors: Global
 *
 * @since 1.0.0
 */ 
 
// Add a Customizer Section
function pointify_customizer_sections($wp_customize) {
    $wp_customize->add_panel('theme_colors', array(
        'title' => __('Theme Colors', 'pointify'),
        'priority' => 30,
    ));

	// Add a section for each tab
    $wp_customize->add_section( 'global_colors', array(
        'title'    => __( 'Global Color', 'pointify' ),
        'panel'    => 'theme_colors',
        'priority' => 10,
    ) );

    $wp_customize->add_section( 'header_colors', array(
        'title'    => __( 'Header Color', 'pointify' ),
        'panel'    => 'theme_colors',
        'priority' => 10,
    ) );

	$wp_customize->add_section( 'inputs_colors', array(
        'title'    => __( 'Inputs Color', 'pointify' ),
        'panel'    => 'theme_colors',
        'priority' => 20,
    ) );

    $wp_customize->add_section( 'footer_color', array(
        'title'    => __( 'Footer Color', 'pointify' ),
        'panel'    => 'theme_colors',
        'priority' => 20,
    ) );

}
add_action('customize_register', 'pointify_customizer_sections');

//Add Color Setting
function pointify_customizer_settings($wp_customize) {
	
	// Add Color Default
	// global Color start
    $wp_customize->add_setting('background_colors', array(
        'default' => '#FFFFFF',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
	
	$style_demo = get_theme_mod( 'pointify_demo_selection', '' );

	if ($style_demo === 'business') {
		$wp_customize->add_setting('primary_color', array(
			'default' => '#FF7200',
			'sanitize_callback' => 'sanitize_hex_color',
		));
	} elseif ($style_demo === 'job_board') {
		$wp_customize->add_setting('primary_color', array(
			'default' => '#4AC710',
			'sanitize_callback' => 'sanitize_hex_color',
		));
	} elseif ($style_demo === 'lawyer') {
		$wp_customize->add_setting('primary_color', array(
			'default' => '#E2B418',
			'sanitize_callback' => 'sanitize_hex_color',
		));
	}
	
	$wp_customize->add_setting('accent_color', array(
        'default' => '#000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	if ($style_demo === 'lawyer') {
		$wp_customize->add_setting('secondary_color', array(
			'default' => '#3B475C',
			'sanitize_callback' => 'sanitize_hex_color',
		));
	}
	
	if ($style_demo === 'job_board') {
		$wp_customize->add_setting('body_text_color', array(
			'default' => '#696969',
			'sanitize_callback' => 'sanitize_hex_color',
		));
	} else {
		$wp_customize->add_setting('body_text_color', array(
			'default' => '#666666',
			'sanitize_callback' => 'sanitize_hex_color',
		));
	}
	
	$wp_customize->add_setting('link_color', array(
        'default' => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('dark_bg_text_color', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	//Add Color Control
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'background_color_control', array(
        'label' => __('Background', 'pointify'),
        'section' => 'global_colors',
        'settings' => 'background_colors',
    )));
	
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'primary_color_control', array(
        'label' => __('Primary', 'pointify'),
        'section' => 'global_colors',
        'settings' => 'primary_color',
    )));
	
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'accent_color_control', array(
        'label' => __('Accent', 'pointify'),
        'section' => 'global_colors',
        'settings' => 'accent_color',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'secondary_color_control', array(
        'label' => __('Secondary', 'pointify'),
        'section' => 'global_colors',
        'settings' => 'secondary_color',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'body_text_control', array(
        'label' => __('Body Text', 'pointify'),
        'section' => 'global_colors',
        'settings' => 'body_text_color',
    )));
	
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'link_control', array(
        'label' => __('Link', 'pointify'),
        'section' => 'global_colors',
        'settings' => 'link_color',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'dark_bg_text_color', array(
        'label' => __('Dark Background Text Color', 'pointify'),
        'section' => 'global_colors',
        'settings' => 'dark_bg_text_color',
    )));

	// global Color end

	// Header Color start
    $wp_customize->add_setting('header_background_colors', array(
        'default' => '#FFFFFF',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('navigation_text_colors', array(
        'default' => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('navigation_dropdown_text_colors', array(
        'default' => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('sticky_navigation_text_colors', array(
        'default' => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('sticky_navigation_dropdown_text_colors', array(
        'default' => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('header_btn_text_colors', array(
        'default' => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('header_btn_bg_colors', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('header_btn_border_colors', array(
        'default' => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
	
	$wp_customize->add_setting('header_btn_text_hover_colors', array(
        'default' => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('header_btn_bg_hover_colors', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('header_btn_hover_border_colors', array(
        'default' => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	//Add Color Control
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_background_colors', array(
        'label' => __('Header Background', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'header_background_colors',
    )));
	
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'navigation_text_colors', array(
        'label' => __('Navigation Text Color', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'navigation_text_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'navigation_dropdown_text_colors', array(
        'label' => __('Navigation Dropdown Text Color', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'navigation_dropdown_text_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'sticky_navigation_text_colors', array(
        'label' => __(' Sticky Navigation Text Color', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'sticky_navigation_text_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'sticky_navigation_dropdown_text_colors', array(
        'label' => __('Sticky Navigation Dropdown Text Color', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'sticky_navigation_dropdown_text_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_btn_text_colors', array(
        'label' => __('Header Button Text Color', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'header_btn_text_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_btn_bg_colors', array(
        'label' => __('Header Button Background Color', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'header_btn_bg_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_btn_border_colors', array(
        'label' => __('Header Button Border Color', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'header_btn_border_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_btn_text_hover_colors', array(
        'label' => __('Header Button Hover Text Color', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'header_btn_text_hover_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_btn_bg_hover_colors', array(
        'label' => __('Header Button Hover Background Color', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'header_btn_bg_hover_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_btn_hover_border_colors', array(
        'label' => __('Header Button Hover Border Color', 'pointify'),
        'section' => 'header_colors',
        'settings' => 'header_btn_hover_border_colors',
    )));

	// header Color end
	
	// Footer Color Start

	$wp_customize->add_setting('footer_background_colors', array(
        'default' => '#2B2C30',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('footer_text_colors', array(
        'default' => '#888888',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('footer_widgets_background_colors', array(
        'default' => '#191A1C',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('footer_widgets_title_text_colors', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('footer_widgets_body_text_colors', array(
        'default' => '#DBDBDB',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	//Add Color Control
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_background_colors', array(
        'label' => __('Footer Background', 'pointify'),
        'section' => 'footer_color',
        'settings' => 'footer_background_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_text_colors', array(
        'label' => __('Footer Text Color', 'pointify'),
        'section' => 'footer_color',
        'settings' => 'footer_text_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_widgets_background_colors', array(
        'label' => __('Footer Widget Background', 'pointify'),
        'section' => 'footer_color',
        'settings' => 'footer_widgets_background_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_widgets_title_text_colors', array(
        'label' => __('Footer Title Text Color', 'pointify'),
        'section' => 'footer_color',
        'settings' => 'footer_widgets_title_text_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_widgets_body_text_colors', array(
        'label' => __('Footer Body Text Color', 'pointify'),
        'section' => 'footer_color',
        'settings' => 'footer_widgets_body_text_colors',
    )));

	// Footer Color End

	// Inputs Color start

	$wp_customize->add_setting('inputs_text_colors', array(
        'default' => '#263238',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('inputs_background_colors', array(
        'default' => '#FDFDFD',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	$wp_customize->add_setting('inputs_border_colors', array(
        'default' => '#c7c7c759',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

	//Add Color Control
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'inputs_text_colors', array(
        'label' => __('Input Text Color', 'pointify'),
        'section' => 'inputs_colors',
        'settings' => 'inputs_text_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'inputs_background_colors', array(
        'label' => __('Input Background Color', 'pointify'),
        'section' => 'inputs_colors',
        'settings' => 'inputs_background_colors',
    )));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'inputs_border_colors', array(
        'label' => __('Input Border Color', 'pointify'),
        'section' => 'inputs_colors',
        'settings' => 'inputs_border_colors',
    )));

	// Inputs Color end

}
add_action('customize_register', 'pointify_customizer_settings');


//Apply Changes
function pointify_apply_customizer_styles() { ?>
    <style type="text/css">

		/* Site Bg */

		body{
			background: <?php echo esc_html(get_theme_mod('background_color', '#F6F6F6')); ?>;	
		}
		<?php
		$style_demo = get_theme_mod( 'pointify_demo_selection', '' );

		if ($style_demo === 'job_board') { ?>
			body.job_board div#job-manager-job-dashboard nav.job-manager-pagination ul.page-numbers li .page-numbers.current,
			body.job_board div#job-manager-job-dashboard nav.job-manager-pagination ul.page-numbers li .page-numbers:hover, 
			body.job_board div.job_listings .job-manager-pagination ul li span.current, 
			body.job_board div.job_listings .job-manager-pagination ul li a:hover,
			body.job_board ul.tabbed-listings-tabs li a.active, 
			body.job_board ul.tabbed-listings-tabs li a:hover,
			.job_board_main_list .content-box .job-bottom-content .job-single-btn-cls a:hover,
			body.job_board .pointify-image-content .pointify-image-content-widget .pointify-content a.btn-sec:hover,
			.job-company-caption .job-company-link a.website:hover,
			.pointify-image-content .pointify-image-content-widget .pointify-content a.button,
			.pointify-image-content .pointify-image-content-widget .pointify-content a.btn-sec:hover,
			body.job_board ul.job-packages li.job-package:hover .job-package-purchase .button,
			body.job_board form#company_preview .company_preview_title .button:hover, 
			body.job_board form#job_preview .job_listing_preview_title .button:hover,
			.job-company-caption .job-additional-details .job_application input.application_button:hover,
			body.job_board .review_btn_cls a:hover,
			body.job_board form.pm-form.pm-form--compose-message input#pm_send_message:hover,
			body.job_board p.pm-action-row a.button:hover,
			body.job_board form.pm-form.pm-form--filters input[type="submit"]:hover ,
			body.job_board .recently-viewed-jobs ul.recently-viewed-job_listings ul.slick-dots li.slick-active button,
			body.job_board .home-feature:hover .home-feature-media,
			body.job_board .term-list .term-details .cat-feat-img,
			body.job_board .btn-primary:hover,
			body.job_board .comment-form .form-submit .submit:hover,
			body.job_board .post-pagination-sec .page-numbers.current, 
			body.job_board .post-pagination-sec .page-numbers:hover,
			body.job_board .post-detail-content-sec .more-link:hover,
			body.job_board .astoundify-favorites-submit-field button,
			body.job_board .review_slider .owl-dots button.owl-dot.active span,
			body.job_board .application_details form input[type="submit"],
			body.job_board .widget_wp-job-manager-report-post .report-post-link, 
			body.job_board .single-listing-section .single_job_listing .company .button,
			body.job_board section.shipping-calculator-form button.button,
			body.job_board .cart-collaterals .cart_totals .wc-proceed-to-checkout a.checkout-button,
			body.job_board table.shop_table_responsive tr.woocommerce-cart-form__cart-item.cart_item td.product-remove a:hover,
			body.job_board table.shop_table tbody tr td.actions button.button,
			body.job_board.single-product .woocommerce-tabs.wc-tabs-wrapper ul.tabs.wc-tabs li a:before,
			body.job_board .woocommerce-pagination .page-numbers li a.page-numbers:hover,
			body.job_board .woocommerce-pagination .page-numbers li span.page-numbers.current,
			body.job_board .woocommerce-Reviews div#review_form_wrapper form#commentform input#submit, 
			body.job_board button.single_add_to_cart_button, 
			body.job_board .products .product .button, 
			body.job_board .products .product .added_to_cart,
			body.job_board .product span.onsale,
			body.job_board .product-sidebar .widget.widget_price_filter .ui-slider .ui-slider-range,
			body.job_board .product-sidebar .widget.widget_price_filter .ui-slider .ui-slider-handle,
			body.job_board .product-sidebar button,
			body.job_board form.woocommerce-ResetPassword button.woocommerce-Button.button, 
			body.job_board form.woocommerce-form.woocommerce-form-register.register button.woocommerce-button.button, 
			body.job_board form.woocommerce-form.woocommerce-form-login button.woocommerce-button.button, 
			body.job_board .woocommerce-MyAccount-content form.woocommerce-EditAccountForm button.woocommerce-Button.button, 
			body.job_board .woocommerce-MyAccount-content form .woocommerce-address-fields button.button, 
			body.job_board .woocommerce-checkout-review-order div#payment button#place_order,
			body.job_board .avatar-image-section a.gravatar-link,
			body.job_board .job-manager-form fieldset .field span.select2 span.select2-selection ul.select2-selection__rendered li.select2-selection__choice, 
			body.job_board form.job_filters .search_jobs .select2 span.selection span.select2-selection ul.select2-selection__rendered li.select2-selection__choice,
			body.job_board div#job-manager-job-dashboard .account-sign-in .button, 
			body.job_board .job-manager-form fieldset .field.account-sign-in a.button,
			body.job_board div#astoundify-favorites-dashboard-lists tr#astoundify-favorite-list-new a.astoundify-favorites-create-list, 
			body.job_board .job-manager-form input.button, 
			body.job_board table.job-manager-jobs tfoot a, 
			body.job_board div.job_listings .load_more_jobs,
			body.job_board  form#job_package_selection .job_listing_packages_title input.button, 
			body.job_board .pointify-hero-search form.job_search_form .search_jobs .search_submit input[type="submit"], 
			body.job_board form.job_filters .search_jobs .search_submit input,
			body.job_board .site-header .header-right .header_btn a:hover,
			body.job_board .user-icon .custom-user-menu-container ul li:hover,
			body.job_board .custom-menu-container .custom-menu li ul li:hover {
				background: <?php echo esc_html(get_theme_mod('primary_color', '#4AC710')); ?>;	
			}
			<?php
		} elseif ( $style_demo === 'lawyer' ) { ?>

			body.lawyer div#job-manager-job-dashboard nav.job-manager-pagination ul.page-numbers li .page-numbers.current,
			body.lawyer div#job-manager-job-dashboard nav.job-manager-pagination ul.page-numbers li .page-numbers:hover, 
			body.lawyer div.job_listings .job-manager-pagination ul li span.current, 
			body.lawyer div.job_listings .job-manager-pagination ul li a:hover,
			body.lawyer .close,
			body.lawyer .btn-primary,
			body.lawyer .job_application.application input.application_button.button:hover,
			body.lawyer .recently-viewed-jobs ul.job_listings.recently-viewed-job_listings button.slick-arrow:hover,
			body.lawyer .sidebar-content .tagcloud a:hover,
			body.lawyer ul.tabbed-listings-tabs li a::after,
			.job_board_main_list .content-box .job-bottom-content .job-single-btn-cls a:hover,
			body.lawyer .pointify-image-content .pointify-image-content-widget .pointify-content a.btn-sec:hover,
			.job-company-caption .job-company-link a.website:hover,
			.pointify-image-content .pointify-image-content-widget .pointify-content a.button,
			.pointify-image-content .pointify-image-content-widget .pointify-content a.btn-sec:hover,
			body.lawyer ul.job-packages li.job-package:hover .job-package-purchase .button,
			body.lawyer form#company_preview .company_preview_title .button:hover, 
			body.lawyer form#job_preview .job_listing_preview_title .button:hover,
			.job-company-caption .job-additional-details .job_application input.application_button:hover,
			body.lawyer .review_btn_cls a:hover,
			body.lawyer form.pm-form.pm-form--compose-message input#pm_send_message:hover,
			body.lawyer p.pm-action-row a.button:hover,
			body.lawyer form.pm-form.pm-form--filters input[type="submit"]:hover ,
			body.lawyer .recently-viewed-jobs ul.recently-viewed-job_listings ul.slick-dots li.slick-active button,
			body.lawyer .term-list .term-details .cat-feat-img,
			body.lawyer .comment-form .form-submit .submit:hover,
			body.lawyer .post-pagination-sec .page-numbers.current, 
			body.lawyer .post-pagination-sec .page-numbers:hover,
			body.lawyer .post-detail-content-sec .more-link:hover,
			body.lawyer .astoundify-favorites-submit-field button,
			body.lawyer .review_slider .owl-dots button.owl-dot.active span,
			body.lawyer .application_details form input[type="submit"],
			body.lawyer .widget_wp-job-manager-report-post .report-post-link, 
			body.lawyer .single-listing-section .single_job_listing .company .button,
			body.lawyer section.shipping-calculator-form button.button,
			body.lawyer .cart-collaterals .cart_totals .wc-proceed-to-checkout a.checkout-button,
			body.lawyer table.shop_table_responsive tr.woocommerce-cart-form__cart-item.cart_item td.product-remove a:hover,
			body.lawyer table.shop_table tbody tr td.actions button.button,
			body.lawyer.single-product .woocommerce-tabs.wc-tabs-wrapper ul.tabs.wc-tabs li a:before,
			body.lawyer .woocommerce-pagination .page-numbers li a.page-numbers:hover,
			body.lawyer .woocommerce-pagination .page-numbers li span.page-numbers.current,
			body.lawyer .woocommerce-Reviews div#review_form_wrapper form#commentform input#submit, 
			body.lawyer button.single_add_to_cart_button, 
			body.lawyer .products .product .button, 
			body.lawyer .products .product .added_to_cart,
			body.lawyer .product span.onsale,
			body.lawyer .product-sidebar .widget.widget_price_filter .ui-slider .ui-slider-range,
			body.lawyer .product-sidebar .widget.widget_price_filter .ui-slider .ui-slider-handle,
			body.lawyer .product-sidebar button,
			body.lawyer form.woocommerce-ResetPassword button.woocommerce-Button.button, 
			body.lawyer form.woocommerce-form.woocommerce-form-register.register button.woocommerce-button.button, 
			body.lawyer form.woocommerce-form.woocommerce-form-login button.woocommerce-button.button, 
			body.lawyer .woocommerce-MyAccount-content form.woocommerce-EditAccountForm button.woocommerce-Button.button, 
			body.lawyer .woocommerce-MyAccount-content form .woocommerce-address-fields button.button, 
			body.lawyer .woocommerce-checkout-review-order div#payment button#place_order,
			body.lawyer .avatar-image-section a.gravatar-link,
			body.lawyer .job-manager-form fieldset .field span.select2 span.select2-selection ul.select2-selection__rendered li.select2-selection__choice, 
			body.lawyer form.job_filters .search_jobs .select2 span.selection span.select2-selection ul.select2-selection__rendered li.select2-selection__choice,
			body.lawyer div#job-manager-job-dashboard .account-sign-in .button, 
			body.lawyer .job-manager-form fieldset .field.account-sign-in a.button,
			body.lawyer div#astoundify-favorites-dashboard-lists tr#astoundify-favorite-list-new a.astoundify-favorites-create-list, 
			body.lawyer .job-manager-form input.button, 
			body.lawyer table.job-manager-jobs tfoot a, 
			body.lawyer div.job_listings .load_more_jobs,
			body.lawyer  form#job_package_selection .job_listing_packages_title input.button, 
			body.lawyer .pointify-hero-search form.job_search_form .search_jobs .search_submit input[type="submit"], 
			body.lawyer form.job_filters .search_jobs .search_submit input,
			body.lawyer .site-header .header-right .header_btn a:hover,
			body.lawyer .user-icon .custom-user-menu-container ul li:hover,
			body.lawyer .custom-menu-container .custom-menu li ul li:hover {
				background: <?php echo esc_html(get_theme_mod('primary_color', '#E2B418')); ?>;
			}

		<?php
		} else { ?>

			/*=====Primary-color======*/
			.widget_wp-job-manager-report-post .report-post-link,
			form#job_package_selection .job_listing_packages_title input.button,
			table.shop_table_responsive tr.woocommerce-cart-form__cart-item.cart_item td.product-remove a:hover,
			section.shipping-calculator-form button.button,
			.cart-collaterals .cart_totals .wc-proceed-to-checkout a.checkout-button,
			table.shop_table tbody tr td.actions button.button,
			.single-product .woocommerce-tabs.wc-tabs-wrapper ul.tabs.wc-tabs li a:before,
			.woocommerce-pagination .page-numbers li a.page-numbers:hover,
			.woocommerce-pagination .page-numbers li span.page-numbers.current,
			.product-sidebar .widget.widget_price_filter .ui-slider .ui-slider-handle,
			.product-sidebar .widget.widget_price_filter .ui-slider .ui-slider-range,
			.woocommerce-Reviews div#review_form_wrapper form#commentform input#submit, 
			button.single_add_to_cart_button, 
			.products .product .button, 
			.products .product .added_to_cart,
			.product span.onsale,
			.product-sidebar button,
			form.pm-form.pm-form--compose-message input#pm_send_message, 
			p.pm-action-row a.button, form.pm-form.pm-form--filters input[type="submit"],
			.astoundify-favorites-submit-field button,
			.job-manager-form fieldset .field span.select2 span.select2-selection ul.select2-selection__rendered li.select2-selection__choice, 
			form.job_filters .search_jobs .select2 span.selection span.select2-selection ul.select2-selection__rendered li.select2-selection__choice,
			form.woocommerce-ResetPassword button.woocommerce-Button.button, 
			form.woocommerce-form.woocommerce-form-register.register button.woocommerce-button.button, 
			form.woocommerce-form.woocommerce-form-login button.woocommerce-button.button, 
			.woocommerce-MyAccount-content form.woocommerce-EditAccountForm button.woocommerce-Button.button, 
			.woocommerce-MyAccount-content form .woocommerce-address-fields button.button, 
			.woocommerce-checkout-review-order div#payment button#place_order,
			nav.woocommerce-MyAccount-navigation ul li.woocommerce-MyAccount-navigation-link.is-active a, 
			nav.woocommerce-MyAccount-navigation ul li.woocommerce-MyAccount-navigation-link.is-active,
			.single-listing-section .single_job_listing .company .button,
			div#job-manager-job-dashboard .account-sign-in .button, 
			.job-manager-form fieldset .field.account-sign-in a.button,
			.close,
			.btn-primary,
			.review_slider .owl-dots button.owl-dot.active span,
			ul.tabbed-listings-tabs li a::after,
			div#astoundify-favorites-dashboard-lists tr#astoundify-favorite-list-new a.astoundify-favorites-create-list, 
			.job-manager-form input.button, 
			table.job-manager-jobs tfoot a, 
			div.job_listings .load_more_jobs,
			.pointify-hero-search form.job_search_form .search_jobs .search_submit input[type="submit"], 
			form.job_filters .search_jobs .search_submit input,
			.pointify .user-icon .custom-user-menu-container ul li:hover, 
			.pointify .custom-menu-container .custom-menu li ul li:hover{
				background: <?php echo esc_html(get_theme_mod('primary_color', '#FF7200')); ?>;	
			}
		<?php } 
		
		if ($style_demo === 'job_board') { ?>
			body.job_board div#job-manager-job-dashboard nav.job-manager-pagination ul.page-numbers li .page-numbers.current,
			body.job_board div#job-manager-job-dashboard nav.job-manager-pagination ul.page-numbers li .page-numbers:hover, 
			body.job_board div.job_listings .job-manager-pagination ul li span.current, 
			body.job_board div.job_listings .job-manager-pagination ul li a:hover,
			.gallery.testimonial-wrapper .gallery-thumbs .swiper-wrapper .swiper-slide.swiper-slide-active .review_author_img:before,
			body.job_board ul.tabbed-listings-tabs li a.active, 
			body.job_board ul.tabbed-listings-tabs li a:hover,
			.pointify-image-content .pointify-image-content-widget .pointify-content a.button,
			.job_board_main_list .content-box .job-bottom-content .job-single-btn-cls a:hover,
			body.job_board .pointify-image-content .pointify-image-content-widget .pointify-content a.btn-sec:hover,
			.job-company-caption .job-company-link a.website:hover,
			.pointify-image-content .pointify-image-content-widget .pointify-content a.btn-sec:hover,
			body.job_board form#company_preview .company_preview_title .button:hover, 
			body.job_board form#job_preview .job_listing_preview_title .button:hover,
			.job-company-caption .job-additional-details .job_application input.application_button:hover,
			body.job_board .review_btn_cls a:hover,
			body.job_board form.pm-form.pm-form--compose-message input#pm_send_message:hover,
			body.job_board p.pm-action-row a.button:hover,
			body.job_board form.pm-form.pm-form--filters input[type="submit"]:hover,
			body.job_board .home-feature:hover .home-feature-media,
			body.job_board .term-list .term-details .cat-feat-img,
			body.job_board .btn-primary:hover,
			body.job_board .comment-form .form-submit .submit:hover,
			body.job_board .post-pagination-sec .page-numbers.current, 
			body.job_board .post-pagination-sec .page-numbers:hover,
			body.job_board .post-detail-content-sec .more-link:hover,
			body.job_board .astoundify-favorites-submit-field button,
			body.job_board .application_details form input[type="submit"],
			body.job_board .widget_wp-job-manager-report-post .report-post-link, 
			body.job_board .single-listing-section .single_job_listing .company .button,
			body.job_board section.shipping-calculator-form button.button,
			body.job_board .cart-collaterals .cart_totals .wc-proceed-to-checkout a.checkout-button,
			body.job_board table.shop_table tbody tr td.actions button.button,
			body.job_board .woocommerce-pagination .page-numbers li a.page-numbers:hover,
			body.job_board .woocommerce-pagination .page-numbers li span.page-numbers.current,
			body.job_board .woocommerce-Reviews div#review_form_wrapper form#commentform input#submit, 
			body.job_board button.single_add_to_cart_button, 
			body.job_board .products .product .button, 
			body.job_board .products .product .added_to_cart,
			body.job_board .product-sidebar button,
			body.job_board form.woocommerce-ResetPassword button.woocommerce-Button.button, 
			body.job_board form.woocommerce-form.woocommerce-form-register.register button.woocommerce-button.button, 
			body.job_board form.woocommerce-form.woocommerce-form-login button.woocommerce-button.button, 
			body.job_board .woocommerce-MyAccount-content form.woocommerce-EditAccountForm button.woocommerce-Button.button, 
			body.job_board .woocommerce-MyAccount-content form .woocommerce-address-fields button.button, 
			body.job_board .woocommerce-checkout-review-order div#payment button#place_order,
			body.job_board .avatar-image-section a.gravatar-link:before,
			body.job_board .job-manager-form fieldset .field span.select2 span.select2-selection ul.select2-selection__rendered li.select2-selection__choice, 
			body.job_board form.job_filters .search_jobs .select2 span.selection span.select2-selection ul.select2-selection__rendered li.select2-selection__choice,
			body.job_board div#job-manager-job-dashboard .account-sign-in .button, 
			body.job_board .job-manager-form fieldset .field.account-sign-in a.button,
			body.job_board div#astoundify-favorites-dashboard-lists tr#astoundify-favorite-list-new a.astoundify-favorites-create-list, 
			body.job_board .job-manager-form input.button, 
			body.job_board table.job-manager-jobs tfoot a, 
			body.job_board div.job_listings .load_more_jobs,
			body.job_board form#job_package_selection .job_listing_packages_title input.button, 
			body.job_board .pointify-hero-search form.job_search_form .search_jobs .search_submit input[type="submit"], 
			body.job_board form.job_filters .search_jobs .search_submit input,
			body.job_board .site-header .header-right .header_btn a:hover,
			body.job_board .user-icon .custom-user-menu-container ul li:hover,
			body.job_board .custom-menu-container .custom-menu li ul li:hover {
				border-color: <?php echo esc_html(get_theme_mod('primary_color', '#4AC710')); ?>;
			}
		<?php
		} elseif ( $style_demo === 'lawyer'  ) { ?>

			body.lawyer div#job-manager-job-dashboard nav.job-manager-pagination ul.page-numbers li .page-numbers.current,
			body.lawyer div#job-manager-job-dashboard nav.job-manager-pagination ul.page-numbers li .page-numbers:hover, 
			body.lawyer div.job_listings .job-manager-pagination ul li span.current, 
			body.lawyer div.job_listings .job-manager-pagination ul li a:hover,
			body.lawyer .close,
			body.lawyer .btn-primary,
			body.lawyer ul.job-packages li.job-package:hover .job-package-purchase .button,
			body.lawyer .job_application.application input.application_button.button:hover,
			body.lawyer .recently-viewed-jobs ul.job_listings.recently-viewed-job_listings button.slick-arrow:hover,
			body.lawyer .comment-form textarea:focus, 
			body.lawyer .comment-form input:focus,
			body.lawyer .sidebar-content .tagcloud a:hover,
			body.lawyer ul.tabbed-listings-tabs li a.active, 
			body.lawyer ul.tabbed-listings-tabs li a:hover,
			.pointify-image-content .pointify-image-content-widget .pointify-content a.button,
			.job_board_main_list .content-box .job-bottom-content .job-single-btn-cls a:hover,
			body.lawyer .pointify-image-content .pointify-image-content-widget .pointify-content a.btn-sec:hover,
			.job-company-caption .job-company-link a.website:hover,
			.pointify-image-content .pointify-image-content-widget .pointify-content a.btn-sec:hover,
			body.lawyer form#company_preview .company_preview_title .button:hover, 
			body.lawyer form#job_preview .job_listing_preview_title .button:hover,
			.job-company-caption .job-additional-details .job_application input.application_button:hover,
			body.lawyer .review_btn_cls a:hover,
			body.lawyer form.pm-form.pm-form--compose-message input#pm_send_message:hover,
			body.lawyer p.pm-action-row a.button:hover,
			body.lawyer form.pm-form.pm-form--filters input[type="submit"]:hover,
			body.lawyer .term-list .term-details .cat-feat-img,
			body.lawyer .btn-primary:hover,
			body.lawyer .comment-form .form-submit .submit:hover,
			body.lawyer .post-pagination-sec .page-numbers.current, 
			body.lawyer .post-pagination-sec .page-numbers:hover,
			body.lawyer .post-detail-content-sec .more-link:hover,
			body.lawyer .astoundify-favorites-submit-field button,
			body.lawyer .application_details form input[type="submit"],
			body.lawyer .widget_wp-job-manager-report-post .report-post-link, 
			body.lawyer .single-listing-section .single_job_listing .company .button,
			body.lawyer section.shipping-calculator-form button.button,
			body.lawyer .cart-collaterals .cart_totals .wc-proceed-to-checkout a.checkout-button,
			body.lawyer table.shop_table tbody tr td.actions button.button,
			body.lawyer .woocommerce-pagination .page-numbers li a.page-numbers:hover,
			body.lawyer .woocommerce-pagination .page-numbers li span.page-numbers.current,
			body.lawyer .woocommerce-Reviews div#review_form_wrapper form#commentform input#submit, 
			body.lawyer button.single_add_to_cart_button, 
			body.lawyer .products .product .button, 
			body.lawyer .products .product .added_to_cart,
			body.lawyer .product-sidebar button,
			body.lawyer form.woocommerce-ResetPassword button.woocommerce-Button.button, 
			body.lawyer form.woocommerce-form.woocommerce-form-register.register button.woocommerce-button.button, 
			body.lawyer form.woocommerce-form.woocommerce-form-login button.woocommerce-button.button, 
			body.lawyer .woocommerce-MyAccount-content form.woocommerce-EditAccountForm button.woocommerce-Button.button, 
			body.lawyer .woocommerce-MyAccount-content form .woocommerce-address-fields button.button, 
			body.lawyer .woocommerce-checkout-review-order div#payment button#place_order,
			body.lawyer .avatar-image-section a.gravatar-link:before,
			body.lawyer .job-manager-form fieldset .field span.select2 span.select2-selection ul.select2-selection__rendered li.select2-selection__choice, 
			body.lawyer form.job_filters .search_jobs .select2 span.selection span.select2-selection ul.select2-selection__rendered li.select2-selection__choice,
			body.lawyer div#job-manager-job-dashboard .account-sign-in .button, 
			body.lawyer .job-manager-form fieldset .field.account-sign-in a.button,
			body.lawyer div#astoundify-favorites-dashboard-lists tr#astoundify-favorite-list-new a.astoundify-favorites-create-list, 
			body.lawyer .job-manager-form input.button, 
			body.lawyer table.job-manager-jobs tfoot a, 
			body.lawyer div.job_listings .load_more_jobs,
			body.lawyer form#job_package_selection .job_listing_packages_title input.button, 
			body.lawyer .pointify-hero-search form.job_search_form .search_jobs .search_submit input[type="submit"], 
			body.lawyer form.job_filters .search_jobs .search_submit input,
			body.lawyer .site-header .header-right .header_btn a:hover,
			body.lawyer .user-icon .custom-user-menu-container ul li:hover,
			body.lawyer .custom-menu-container .custom-menu li ul li:hover {
				border-color: <?php echo esc_html(get_theme_mod('primary_color', '#E2B418')); ?>;
			}
		<?php
		} else { ?>

			form#job_package_selection .job_listing_packages_title input.button,
			section.shipping-calculator-form button.button,
			.cart-collaterals .cart_totals .wc-proceed-to-checkout a.checkout-button,
			table.shop_table tbody tr td.actions button.button,
			.woocommerce-pagination .page-numbers li a.page-numbers:hover,
			.woocommerce-pagination .page-numbers li span.page-numbers.current,
			.woocommerce-Reviews div#review_form_wrapper form#commentform input#submit, 
			button.single_add_to_cart_button, 
			.products .product .button, 
			.products .product .added_to_cart,
			.product-sidebar button,
			form.pm-form.pm-form--compose-message input#pm_send_message, 
			p.pm-action-row a.button, form.pm-form.pm-form--filters input[type="submit"],
			.astoundify-favorites-submit-field button,
			.job-manager-form fieldset .field span.select2 span.select2-selection ul.select2-selection__rendered li.select2-selection__choice, 
			form.job_filters .search_jobs .select2 span.selection span.select2-selection ul.select2-selection__rendered li.select2-selection__choice,
			form.woocommerce-ResetPassword button.woocommerce-Button.button, 
			form.woocommerce-form.woocommerce-form-register.register button.woocommerce-button.button, 
			form.woocommerce-form.woocommerce-form-login button.woocommerce-button.button, 
			.woocommerce-MyAccount-content form.woocommerce-EditAccountForm button.woocommerce-Button.button, 
			.woocommerce-MyAccount-content form .woocommerce-address-fields button.button, 
			.woocommerce-checkout-review-order div#payment button#place_order,
			.single-listing-section .single_job_listing .company .button,
			div#job-manager-job-dashboard .account-sign-in .button, 
			.job-manager-form fieldset .field.account-sign-in a.button,
			.close,
			div#astoundify-favorites-dashboard-lists tr#astoundify-favorite-list-new a.astoundify-favorites-create-list:hover, .job-manager-form input.button:hover, table.job-manager-jobs tfoot a:hover, div.job_listings .load_more_jobs:focus, div.job_listings .load_more_jobs:hover,
			.btn-primary,
			div#astoundify-favorites-dashboard-lists tr#astoundify-favorite-list-new a.astoundify-favorites-create-list, 
			.job-manager-form input.button, 
			table.job-manager-jobs tfoot a, 
			div.job_listings .load_more_jobs,
			.pointify-hero-search form.job_search_form .search_jobs .search_submit input[type="submit"], 
			form.job_filters .search_jobs .search_submit input,
			.single-post-main-section .post-content-sec blockquote,
			.pointify .user-icon .custom-user-menu-container ul li:hover, 
			.pointify .custom-menu-container .custom-menu li ul li:hover{
				border-color: <?php echo esc_html(get_theme_mod('primary_color', '#FF7200')); ?>;	
			}
		<?php } 
		if ($style_demo === 'job_board') { ?>
			body.job_board form.job_filters .search_jobs .search_remote_position input[type="checkbox"]::before, 
			body.job_board form.job_filters ul.job_types li label input[type="checkbox"]::before {
				box-shadow: inset 1em 1em <?php echo esc_html(get_theme_mod('primary_color', '#4AC710')); ?>;
			}
			body.job_board form.job_filters .search_jobs input:focus {
				border-bottom-color: <?php echo esc_html(get_theme_mod('primary_color', '#4AC710')); ?>;
			}
			body.job_board .product span.onsale:before {
				border-left-color: <?php echo esc_html(get_theme_mod('primary_color', '#4AC710')); ?>;
			}
		<?php } elseif ( $style_demo === 'lawyer' ) { ?>
			body.lawyer .job-manager-message.job-manager-message {
				border-top-color: <?php echo esc_html(get_theme_mod('primary_color', '#E2B418')); ?>;
			}
			body.lawyer form.job_filters .search_jobs input:focus {
				border-bottom-color: <?php echo esc_html(get_theme_mod('primary_color', '#E2B418')); ?>;
			}
			body.lawyer form.job_filters .search_jobs .search_remote_position input[type="checkbox"]::before, 
			body.lawyer form.job_filters ul.job_types li label input[type="checkbox"]::before {
				box-shadow: inset 1em 1em <?php echo esc_html(get_theme_mod('primary_color', '#E2B418')); ?>;
			}
		<?php
		} else { ?>		
			form.job_filters .search_jobs .search_remote_position input[type="checkbox"]::before, 
			form.job_filters ul.job_types li label input[type="checkbox"]::before {
				box-shadow: inset 1em 1em <?php echo esc_html(get_theme_mod('primary_color', '#FF7200')); ?>;
			}
		<?php } ?>
			.single-post-main-section .post-tags-sec svg path{
				fill: <?php echo esc_html(get_theme_mod('primary_color', '#FF7200')); ?>;
			}

		<?php if ($style_demo === 'job_board') { ?>
			.job_board_list .job-listing-details span.job-type-cls,
			body.job_board table.job-manager-jobs tfoot a:hover, 
			body.job_board form#wpjmcl_submit_claim .field a:hover,
			body.job_board .job-manager-form fieldset .field a,
			body.job_board form.pm-form.pm-form--filters a:hover,
			body.job_board .close:hover span.cross-span,
			body.job_board .term-list:hover .term-details h4,
			body.job_board .term-list:hover .term-details h4 a,
			body.job_board .job-manager-message.job-manager-message::before, 
			body.job_board .job-manager-message.job-manager-message a,
			body.job_board .post-detail-content-sec .more-link:hover, 
			body.job_board .astoundify-favorites-submit-field button:hover,
			body.job_board .astoundify-favorites-submit-field .astoundify-favorites-remove-favorite, 
			body.job_board div#astoundify-favorites-dashboard-view-tabs a.astoundify-favorites-tab--active, 
			body.job_board div#astoundify-favorites-dashboard-lists table tbody .astoundify-favorite-list .astoundify-favorite-list-actions a:hover, 
			body.job_board div#astoundify-favorites-dashboard-favorites table tbody .astoundify-favorite .astoundify-favorite-actions a:hover, 
			body.job_board form.job_filters .search_jobs .astoundify-listing-labels span.filter_by_tag_cloud a:hover,
			body.job_board .application_details form input[type="submit"]:hover,
			body.job_board .widget_wp-job-manager-report-post .report-post-link:hover, 
			body.job_board .single-listing-section .single_job_listing .company .button:hover,
			body.job_board .account-notice-cls a,
			body.job_board section.shipping-calculator-form button.button:hover,
			body.job_board .cart-collaterals .cart_totals .wc-proceed-to-checkout a.checkout-button:hover, 
			body.job_board table.shop_table tbody tr td.actions button.button:hover, 
			body.job_board table.shop_table tbody tr td.actions .coupon button.button, 
			body.job_board.single-product .woocommerce-tabs.wc-tabs-wrapper ul.tabs.wc-tabs li.active a, 
			body.job_board.single-product .woocommerce-tabs.wc-tabs-wrapper ul.tabs.wc-tabs li a:hover,  
			body.job_board .woocommerce-Reviews div#review_form_wrapper form#commentform input#submit:hover, 
			body.job_board button.single_add_to_cart_button:hover, 
			body.job_board .products .product .button:hover, 
			body.job_board .products .product .added_to_cart:hover, 
			body.job_board .product-sidebar .widget ul li a:hover, 
			body.job_board .product-sidebar .widget button:hover, 
			body.job_board form.woocommerce-ResetPassword button.woocommerce-Button.button:hover, 
			body.job_board form.woocommerce-form.woocommerce-form-register.register button.woocommerce-button.button:hover, 
			body.job_board form.woocommerce-form.woocommerce-form-login button.woocommerce-button.button:hover, 
			body.job_board .woocommerce-MyAccount-content form.woocommerce-EditAccountForm button.woocommerce-Button.button:hover, 
			body.job_board .woocommerce-MyAccount-content form .woocommerce-address-fields button.button:hover, 
			body.job_board .woocommerce-checkout-review-order div#payment button#place_order:hover, 
			body.job_board table.job-manager-jobs tbody tr td span.featured-job-icon, 
			body.job_board nav.tertiary-navigation ul.tertiary li a:hover, 
			body.job_board div#job-manager-job-dashboard .account-sign-in .button:hover, 
			body.job_board .job-manager-form fieldset .field.account-sign-in a.button:hover, 
			body.job_board div#astoundify-favorites-dashboard-lists tr#astoundify-favorite-list-new a.astoundify-favorites-create-list:hover, 
			body.job_board .job-manager-form input.button:hover, table.job-manager-jobs tfoot a:hover, 
			body.job_board div.job_listings .load_more_jobs:focus, 
			body.job_board div.job_listings .load_more_jobs:hover, 
			body.job_board .job_listings ul.job_listings li.job_listing a .location, 
			body.job_board form#job_package_selection .job_listing_packages_title input.button:hover, 
			body.job_board .pointify-hero-search form.job_search_form .search_jobs .search_submit input[type="submit"]:hover, 
			body.job_board form.job_filters .search_jobs .search_submit input:hover,
			body.job_board span.special-widget-text,
			body.job_board .footer-widget ul li a:hover {
				color: <?php echo esc_html(get_theme_mod('primary_color', '#4AC710')); ?>;
			}
		<?php } elseif ( $style_demo === 'lawyer' ) { ?>
			body.lawyer .sidebar-content .widget_categories li a:hover,
			body.lawyer table.job-manager-jobs tfoot a:hover, 
			body.lawyer form#wpjmcl_submit_claim .field a:hover,
			body.lawyer .job-manager-form fieldset .field a,
			body.lawyer .close:hover span.cross-span,
			body.lawyer .term-list:hover .term-details h4,
			body.lawyer .term-list:hover .term-details h4 a,
			body.lawyer .job-manager-message.job-manager-message::before, 
			body.lawyer .job-manager-message.job-manager-message a,
			body.lawyer .post-detail-content-sec .more-link:hover, 
			body.lawyer .astoundify-favorites-submit-field button:hover,
			body.lawyer .astoundify-favorites-submit-field .astoundify-favorites-remove-favorite, 
			body.lawyer div#astoundify-favorites-dashboard-view-tabs a.astoundify-favorites-tab--active, 
			body.lawyer div#astoundify-favorites-dashboard-lists table tbody .astoundify-favorite-list .astoundify-favorite-list-actions a:hover, 
			body.lawyer div#astoundify-favorites-dashboard-favorites table tbody .astoundify-favorite .astoundify-favorite-actions a:hover, 
			body.lawyer form.job_filters .search_jobs .astoundify-listing-labels span.filter_by_tag_cloud a:hover,
			body.lawyer .application_details form input[type="submit"]:hover,
			body.lawyer .widget_wp-job-manager-report-post .report-post-link:hover, 
			body.lawyer .single-listing-section .single_job_listing .company .button:hover,
			body.lawyer .account-notice-cls a,
			body.lawyer section.shipping-calculator-form button.button:hover,
			body.lawyer .cart-collaterals .cart_totals .wc-proceed-to-checkout a.checkout-button:hover, 
			body.lawyer table.shop_table tbody tr td.actions button.button:hover, 
			body.lawyer table.shop_table tbody tr td.actions .coupon button.button, 
			body.lawyer.single-product .woocommerce-tabs.wc-tabs-wrapper ul.tabs.wc-tabs li.active a, 
			body.lawyer.single-product .woocommerce-tabs.wc-tabs-wrapper ul.tabs.wc-tabs li a:hover,  
			body.lawyer .woocommerce-Reviews div#review_form_wrapper form#commentform input#submit:hover, 
			body.lawyer button.single_add_to_cart_button:hover, 
			body.lawyer .products .product .button:hover, 
			body.lawyer .products .product .added_to_cart:hover, 
			body.lawyer .product-sidebar .widget ul li a:hover, 
			body.lawyer .product-sidebar .widget button:hover, 
			body.lawyer form.woocommerce-ResetPassword button.woocommerce-Button.button:hover, 
			body.lawyer form.woocommerce-form.woocommerce-form-register.register button.woocommerce-button.button:hover, 
			body.lawyer form.woocommerce-form.woocommerce-form-login button.woocommerce-button.button:hover, 
			body.lawyer .woocommerce-MyAccount-content form.woocommerce-EditAccountForm button.woocommerce-Button.button:hover, 
			body.lawyer .woocommerce-MyAccount-content form .woocommerce-address-fields button.button:hover, 
			body.lawyer .woocommerce-checkout-review-order div#payment button#place_order:hover, 
			body.lawyer table.job-manager-jobs tbody tr td span.featured-job-icon, 
			body.lawyer nav.tertiary-navigation ul.tertiary li a:hover, 
			body.lawyer div#job-manager-job-dashboard .account-sign-in .button:hover, 
			body.lawyer .job-manager-form fieldset .field.account-sign-in a.button:hover, 
			body.lawyer .btn-primary:hover, 
			body.lawyer div#astoundify-favorites-dashboard-lists tr#astoundify-favorite-list-new a.astoundify-favorites-create-list:hover, 
			body.lawyer .job-manager-form input.button:hover, table.job-manager-jobs tfoot a:hover, 
			body.lawyer div.job_listings .load_more_jobs:focus, 
			body.lawyer div.job_listings .load_more_jobs:hover, 
			body.lawyer .job_listings ul.job_listings li.job_listing a .location, 
			body.lawyer form#job_package_selection .job_listing_packages_title input.button:hover, 
			body.lawyer .pointify-hero-search form.job_search_form .search_jobs .search_submit input[type="submit"]:hover, 
			body.lawyer form.job_filters .search_jobs .search_submit input:hover,
			body.lawyer span.special-widget-text,
			body.lawyer .footer-widget ul li a:hover {
				color: <?php echo esc_html(get_theme_mod('primary_color', '#E2B418')); ?>;
			}
		<?php
		} else { ?>	

			.widget_wp-job-manager-report-post .report-post-link:hover,
			form#job_package_selection .job_listing_packages_title input.button:hover,
			a.navigation-bar-toggle,
			nav.tertiary-navigation ul.tertiary li a:hover,
			section.shipping-calculator-form button.button:hover,
			table.shop_table tbody tr td.actions .coupon button.button,
			.cart-collaterals .cart_totals .wc-proceed-to-checkout a.checkout-button:hover,
			table.shop_table tbody tr td.actions button.button:hover,
			.single-product .woocommerce-tabs.wc-tabs-wrapper ul.tabs.wc-tabs li.active a, 
			.single-product .woocommerce-tabs.wc-tabs-wrapper ul.tabs.wc-tabs li a:hover,
			.product-sidebar .widget ul li a:hover,
			.woocommerce-Reviews div#review_form_wrapper form#commentform input#submit:hover, 
			button.single_add_to_cart_button:hover, 
			.products .product .button:hover, 
			.products .product .added_to_cart:hover,
			.product-sidebar button:hover,
			.astoundify-favorites-notices p a,
			table.pm-table.pm-table--messages-list tr td.pm-column.pm-column--actions a:hover, 
			table.pm-table.pm-table--message-list a:hover,
			form.pm-form.pm-form--filters a:hover,
			form.pm-form.pm-form--compose-message input#pm_send_message:hover, 
			p.pm-action-row a.button:hover, 
			form.pm-form.pm-form--filters input[type="submit"]:hover,
			form.job_filters .search_jobs .astoundify-listing-labels span.filter_by_tag_cloud a:hover,
			.account-notice-cls a,
			.post-share-section a:hover,
			.review_comment_raiting span.stars-rating span.dashicons.dashicons-star-half, 
			.review_comment_raiting span.stars-rating span.dashicons.dashicons-star-filled,
			.astoundify-favorites-submit-field .astoundify-favorites-remove-favorite,
			div#astoundify-favorites-dashboard-view-tabs a.astoundify-favorites-tab--active, div#astoundify-favorites-dashboard-lists table tbody .astoundify-favorite-list .astoundify-favorite-list-actions a:hover, 
			div#astoundify-favorites-dashboard-favorites table tbody .astoundify-favorite .astoundify-favorite-actions a:hover,
			.company-listings-tabs .panel a,
			.job-manager-form fieldset .field a,
			table.job-manager-jobs tbody tr td span.featured-job-icon,
			form.woocommerce-ResetPassword button.woocommerce-Button.button:hover, 
			form.woocommerce-form.woocommerce-form-register.register button.woocommerce-button.button:hover, 
			form.woocommerce-form.woocommerce-form-login button.woocommerce-button.button:hover, 
			.woocommerce-MyAccount-content form.woocommerce-EditAccountForm button.woocommerce-Button.button:hover, 
			.woocommerce-MyAccount-content form .woocommerce-address-fields button.button:hover, 
			.woocommerce-checkout-review-order div#payment button#place_order:hover,
			.single-listing-section .single_job_listing .company .button:hover,
			div#job-manager-job-dashboard .account-sign-in .button:hover, 
			.job-manager-form fieldset .field.account-sign-in a.button:hover,
			.close:hover span.cross-span,
			.btn-primary:hover,
			div#astoundify-favorites-dashboard-lists tr#astoundify-favorite-list-new a.astoundify-favorites-create-list:hover, 
			.job-manager-form input.button:hover, 
			table.job-manager-jobs tfoot a:hover, 
			div.job_listings .load_more_jobs:focus, 
			div.job_listings .load_more_jobs:hover,
			.pointify-hero-search form.job_search_form .search_jobs .search_submit input[type="submit"]:hover, form.job_filters .search_jobs .search_submit input:hover,
			.footer-widget ul li a:hover,
			span.special-widget-text {
				color: <?php echo esc_html(get_theme_mod('primary_color', '#FF7200')); ?>;
			}

		<?php } ?>

		/*=====Accent-color======*/

		<?php if ($style_demo === 'job_board') { ?>

			.job-add-detail-content h4,
			.job_board_single_listing .job-title h4,
			body.job_board .claim-user-notice a, 
			body.job_board .claim-listing span, 
			body.job_board .claim-verified,
			body.job_board ul.job-packages li.job-package .job-package-header .job-package-title .product-title-cls, 
			body.job_board ul.job-packages li.job-package:hover .job-package-header .job-package-price, 
			body.job_board ul.job-packages li.job-package:hover .job-package-header .job-package-title .product-title-cls,
			.gallery.testimonial-wrapper .swiper-slide .testimonial_content h4,
			body.job_board form.pm-form.pm-form--filters a,
			body.job_board .woocommerce-message a.button.wc-forward,
			body.job_board .product_meta,
			body.job_board.single-product .price,
			body.job_board .form-title h2, 
			body.job_board form#job_package_selection .job_listing_packages_title h2,
			body.job_board .woocommerce-notice.woocommerce-notice--success.woocommerce-thankyou-order-received,
			body.job_board form.checkout #order_review_heading,
			body.job_board form.checkout #customer_details h3 span,
			body.job_board table.shop_table tr.cart_item td.product-name a,
			body.job_board .cart-collaterals .cart_totals h2,
			body.job_board section.related.products>h2,
			body.job_board.single-product .product_title.entry-title,
			body.job_board .woocommerce-loop-product__title,
			body.job_board .product-sidebar .widget-title,
			body.job_board .woocommerce-MyAccount-content form h3, 
			body.job_board .woocommerce-MyAccount-content .u-columns.woocommerce-Addresses .woocommerce-Address h3, 
			body.job_board section.woocommerce-order-details .woocommerce-order-details__title, 
			body.job_board section.woocommerce-customer-details section.woocommerce-columns .woocommerce-column .woocommerce-column__title,
			body.job_board .woocommerce-MyAccount-content form.woocommerce-EditAccountForm fieldset legend, 
			body.job_board form.checkout #customer_details h3,
			body.job_board form.astoundify-favorites-form-list-edit h3, 
			body.job_board .astoundify-favorites-popup .astoundify-favorites-form-favorite-edit h3,
			body.job_board .pm-message-subject, 
			body.job_board .pm-section-title,
			body.job_board div#astoundify-favorites-dashboard-view-tabs a,
			body.job_board div#astoundify-favorites-dashboard-lists table thead tr th, 
			body.job_board div#astoundify-favorites-dashboard-favorites table thead tr th,
			body.job_board div#astoundify-favorites-dashboard-favorites table tbody .astoundify-favorite td a.astoundify-favorites-target-link,
			body.job_board table.job-manager-jobs tbody tr td.job_title,
			body.job_board table.job-manager-jobs tbody tr td.job_title a,
			body.job_board .post-detail-content-sec .entry-title, 
			body.job_board .post-detail-content-sec .entry-title a,
			body.job_board section.no-results.not-found .page-title,
			body.job_board table.job-manager-jobs thead tr th,
			body.job_board .single-listing-section .single_job_listing h3,
			body.job_board .sidebar-content .widget-title,
			body.job_board .content-box .job-listing-details .job-title h4,
			body.job_board .content-box .job-listing-details .job-title h4 a,
			body.job_board .home-feature-title h4,
			body.job_board .post-section .post-grid-section .post-content h4,
			body.job_board .post-section .post-grid-section .post-content h4 a,
			body.job_board .single-post-main-section .post-detail-content-sec h2,
			body.job_board .single-post-main-section .post-details h3,
			.faq-section .faq-item .faq-question,
			.inner-sec-content-cls .widgettitle,
			.pointify-image-content .pointify-image-content-widget .pointify-content h2,
			.job-bottom-content .listing-pricing h5,
			body.job_board .term-list h4, 
			body.job_board .term-list h4 a,
			body.job_board .widget-title-desc-caption h3,
			body.job_board .widget-title-desc-caption p { 
				color: <?php echo esc_html(get_theme_mod('accent_color', '#000')); ?>;
			}

		<?php } else { ?>

			body.lawyer section.woocommerce-order-details table.woocommerce-table tbody tr.woocommerce-table__line-item.order_item td a,
			body.lawyer .woocommerce-Reviews ol.commentlist li.review .comment_container .comment-text .meta, 
			body.lawyer .woocommerce-Reviews ol.commentlist li.review .comment_container .comment-text .meta+time.woocommerce-review__published-date,
			body.lawyer.single-product .woocommerce-tabs.wc-tabs-wrapper ul.tabs.wc-tabs li a,
			body.lawyer .product_meta,
			body.lawyer .single-post-main-section .ele-listing-single .comment-form label, 
			body.lawyer.single-job_listing .single-post-main-section .comment-form label,
			body.lawyer .single-post-main-section .comments-title,
			body.lawyer span.claim-verified,
			body.lawyer .claim-listing,
			body.lawyer span.claim-user-notice a,
			body.lawyer .job-title h4,
			body.lawyer .job-manager-form h2,
			body.lawyer .sidebar-content .widget label.wp-block-search__label, 
			body.lawyer .sidebar-content .widget h2,
			body.lawyer .widget-title-desc-caption h4,
			body.lawyer .term-list h4 a,
			body.lawyer .testimonial_content .author-details .author_info h4,
			.single-product .price,	
			.form-title h2,
			form#job_package_selection .job_listing_packages_title h2,
			.woocommerce-notice.woocommerce-notice--success.woocommerce-thankyou-order-received,
			form.checkout #order_review_heading,
			form.checkout #customer_details h3 span,
			table.shop_table tr.cart_item td.product-name a,
			.cart-collaterals .cart_totals h2,
			section.related.products>h2,
			.single-product .product_title.entry-title,
			.woocommerce-loop-product__title,
			.product-sidebar .widget-title,
			.woocommerce-MyAccount-content form h3, 
			.woocommerce-MyAccount-content .u-columns.woocommerce-Addresses .woocommerce-Address h3, 
			section.woocommerce-order-details .woocommerce-order-details__title, 
			section.woocommerce-customer-details section.woocommerce-columns .woocommerce-column .woocommerce-column__title,
			.woocommerce-MyAccount-content form.woocommerce-EditAccountForm fieldset legend, 
			form.checkout #customer_details h3,
			form.astoundify-favorites-form-list-edit h3, 
			.astoundify-favorites-popup .astoundify-favorites-form-favorite-edit h3,
			.pm-message-subject, 
			.pm-section-title,
			div#astoundify-favorites-dashboard-view-tabs a,
			div#astoundify-favorites-dashboard-lists table thead tr th, div#astoundify-favorites-dashboard-favorites table thead tr th,
			div#astoundify-favorites-dashboard-favorites table tbody .astoundify-favorite td a.astoundify-favorites-target-link,
			table.job-manager-jobs tbody tr td.job_title,
			table.job-manager-jobs tbody tr td.job_title a,
			.post-detail-content-sec .entry-title, 
			.post-detail-content-sec .entry-title a,
			section.no-results.not-found .page-title,
			table.job-manager-jobs thead tr th,
			.single-listing-section .single_job_listing h3,
			.sidebar-content .widget-title,
			.content-box .job-listing-details .job-title h4,
			.content-box .job-listing-details .job-title h4 a,
			.home-feature-title h4,
			.post-section .post-grid-section .post-content h4,
			.post-section .post-grid-section .post-content h4 a,
			.single-post-main-section .post-detail-content-sec h2,
			.single-post-main-section .post-details h3,
			.widget-title-desc-caption h3{ 
				color: <?php echo esc_html(get_theme_mod('accent_color', '#000')); ?>;
			}
		
		<?php } 
		
		if ($style_demo === 'lawyer') {
		?>
			body.lawyer .widget_price_filter .price_slider_amount .price_label,
			body.lawyer .application_details form label,
			body.lawyer .listing-location-info .job-add-detail-content h4,
			body.lawyer .widget-title-desc-caption h3 {
				color: <?php echo esc_html(get_theme_mod('secondary_color', '#3B475C')); ?>;
			}
		<?php 
		}

		if ($style_demo === 'job_board') { ?>

			/*=====Body-Text-color======*/
			body.job_board,
			.job-add-detail-content p,
			body.job_board form.woocommerce-ResetPassword p, 
			body.job_board form.woocommerce-form.woocommerce-form-register p,
			.job_board_single_listing .job-date-cls,
			body.job_board ul.job-packages li.job-package:hover .job-package-header .job-package-title .product-short-desc,
			body.job_board ul.job-packages li.job-package:hover .job-package-includes ul li,
			.inner-sec-content-cls p,
			body.job_board .sidebar-content #user-carousel p.roles-name,
			body.job_board .post-details-info-sec .author-name,
			body.job_board .post-section .post-grid-section .post-content p,
			.gallery.testimonial-wrapper .swiper-slide .testimonial_content h5,
			.job_board_list .job-listing-details span.job-publish-cls,
			.job-bottom-content .listing-pricing h4,
			.pointify-image-content .pointify-image-content-widget .pointify-content p,
			body.job_board .term-list .term-details p,
			body.job_board .sidebar-content .latest-post p.sidebar_description,
			body.job_board form#job_package_selection .job_listing_packages ul.job_packages li,
			body.job_board form#job_package_selection .job_listing_packages ul.job_packages li p,
			body.job_board form#job_package_selection .job_listing_packages ul.job_packages li label,
			body.job_board .woocommerce-order p,
			body.job_board section.woocommerce-order-details table.woocommerce-table tbody tr.woocommerce-table__line-item.order_item td,
			body.job_board section.woocommerce-order-details table.woocommerce-table tfoot tr th,
			body.job_board section.woocommerce-order-details table.woocommerce-table tfoot tr td,
			body.job_board .woocommerce-order ul.woocommerce-order-overview li,
			body.job_board .woocommerce-checkout-review-order div#payment .woocommerce-terms-and-conditions-wrapper,
			body.job_board .woocommerce-checkout-review-order div#payment ul li.wc_payment_method,
			body.job_board .woocommerce-checkout-review-order table.shop_table tfoot th, 
			body.job_board .woocommerce-checkout-review-order table.shop_table tfoot td,
			body.job_board table.shop_table tr.cart_item td,
			body.job_board .cart-collaterals .cart_totals table.shop_table tr td, 
			body.job_board .cart-collaterals .cart_totals table.shop_table tr th,
			body.job_board .woocommerce-Reviews div#review_form_wrapper form#commentform label,
			body.job_board.single-product .woocommerce-product-details__short-description,
			body.job_board.single-product .woocommerce-tabs.wc-tabs-wrapper .woocommerce-Tabs-panel p,
			body.job_board .product span.price,
			body.job_board .product-sidebar .widget ul li a,
			body.job_board .product-main-section .woocommerce-result-count,
			body.job_board .woocommerce-MyAccount-content .u-columns.woocommerce-Addresses .woocommerce-Address address, 
			body.job_board section.woocommerce-customer-details section.woocommerce-columns .woocommerce-column address,
			body.job_board form.woocommerce-ResetPassword label, 
			body.job_board form.woocommerce-form.woocommerce-form-register.register label, 
			body.job_board form.woocommerce-form.woocommerce-form-login.login label, 
			body.job_board .woocommerce-MyAccount-content form.woocommerce-EditAccountForm label, 
			body.job_board .woocommerce-MyAccount-content form .woocommerce-address-fields__field-wrapper label, 
			body.job_board form.checkout #customer_details label,
			body.job_board .woocommerce-MyAccount-content,
			body.job_board table.shop_table thead th,
			body.job_board .woocommerce-MyAccount-content table.woocommerce-orders-table tbody tr.woocommerce-orders-table__row td.woocommerce-orders-table__cell,
			body.job_board .mfp-close-btn-in .mfp-close,
			body.job_board form.pm-form.pm-form--compose-message label, 
			body.job_board form.pm-form.pm-form--compose-message p.pm-form__row.pm-form__row--attachments,
			body.job_board table.pm-table.pm-table--messages-list tr td.pm-column a,
			body.job_board div#astoundify-favorites-dashboard-lists table tbody .astoundify-favorite-list td, 
			body.job_board div#astoundify-favorites-dashboard-favorites table tbody .astoundify-favorite td,
			body.job_board div#astoundify-favorites-dashboard-lists table tbody .astoundify-favorite-list td a, 
			body.job_board div#astoundify-favorites-dashboard-favorites table tbody .astoundify-favorite td a,
			body.job_board #job-manager-job-dashboard table .job_title small,
			body.job_board table.job-manager-jobs tbody tr td .job-dashboard-actions a,
			body.job_board table.job-manager-jobs tbody tr td.date,
			body.job_board table.job-manager-jobs tbody tr td.expires,
			body.job_board .post-pagination-sec .page-numbers,
			body.job_board .post-detail-content-sec p,
			body.job_board .job-manager-form fieldset label,
			body.job_board div#job-manager-job-dashboard p,
			body.job_board .single_job_listing .company .tagline,
			body.job_board .single-post-main-section .comments-area .comment-content p,
			body.job_board .content-box .job-listing-details .job-location span,
			body.job_board .home-feature .home-feature-description p,
			body.job_board ul.tabbed-listings-tabs li a,
			body.job_board .review_slider .review_caption_content .review_auhtor_content .review_comment,
			body.job_board .post-section .post-grid-section .post-content .post-pubished-details,
			body.job_board .account-notice-cls,
			body.job_board .single-post-main-section .post-details p,
			body.job_board .post-share-section a,
			body.job_board .post-other-info .post-comment-count,
			body.job_board .post-details-section .post-time-info,
			body.job_board .sidebar-content .widget_categories li,
			body.job_board .sidebar-content .widget_categories li a, 
			body.job_board .post-share-section,
			body.job_board .author-info .author-name,
			body.job_board .single-post-main-section .post-content-sec p,
			body.job_board .single-post-main-section .post-published_date,
			body.job_board .single-post-main-section .comments-area .comment-metadata,		
			body.job_board .single-post-main-section .comments-title,
			body.job_board .single-post-main-section .comment-reply-title,
			body.job_board .single-post-main-section .comment-form textarea,
			body.job_board .single-post-main-section .comment-form input,
			body.job_board .single-post-main-section .comment-form textarea::placeholder,
			body.job_board .single-post-main-section .comment-form input::placeholder,
			body.job_board .single-post-main-section .comment-form .comment-notes,
			body.job_board .single-post-main-section .comment-form .comment-form-cookies-consent,
			body.job_board .single-post-main-section .comment-form .logged-in-as,
			body.job_board .single-post-main-section .comment-form .form-submit .submit,			
			body.job_board .sidebar-content #user-carousel p.admin-name,		
			body.job_board .sidebar-content .latest-post .post-content h4, 		
			body.job_board .post-detail-content-sec .entry-title, 
			body.job_board .single-post-main-section .comments-area footer.comment-meta a,
			body.job_board .search_popup_content .search-submit:hover {
				color: <?php echo esc_html(get_theme_mod('body_text_color', '#696969')); ?>;
			}

		<?php } else { ?>	
			/*=====Body-Text-color======*/
			body,
			body.lawyer .woocommerce-Reviews div#review_form_wrapper .comment-reply-title,
			body.lawyer .term-list .term-details p,
			body.lawyer .job-location span,
			body.lawyer .pointify-how-it-works .widget-title-desc-caption p,
			body.lawyer .content-box .listing_review_cls,
			body.lawyer .testimonial_content h5,
			body.lawyer .post-section .post-grid-section .post-content .post-pubished-details .comment-count,
			body.lawyer .job-company-link a,
			body.lawyer .listing-pricing h5,
			body.lawyer .listing-location-info .job-add-detail-content p,
			.sidebar-content .latest-post p.sidebar_description,
			form#job_package_selection .job_listing_packages ul.job_packages li,
			form#job_package_selection .job_listing_packages ul.job_packages li p,
			form#job_package_selection .job_listing_packages ul.job_packages li label,
			.woocommerce-order p,
			section.woocommerce-order-details table.woocommerce-table tbody tr.woocommerce-table__line-item.order_item td,
			section.woocommerce-order-details table.woocommerce-table tfoot tr th,
			section.woocommerce-order-details table.woocommerce-table tfoot tr td,
			.woocommerce-order ul.woocommerce-order-overview li,
			.woocommerce-checkout-review-order div#payment .woocommerce-terms-and-conditions-wrapper,
			.woocommerce-checkout-review-order div#payment ul li.wc_payment_method,
			.woocommerce-checkout-review-order table.shop_table tfoot th, 
			.woocommerce-checkout-review-order table.shop_table tfoot td,
			table.shop_table tr.cart_item td,
			.cart-collaterals .cart_totals table.shop_table tr td, 
			.cart-collaterals .cart_totals table.shop_table tr th,
			.woocommerce-Reviews div#review_form_wrapper form#commentform label,
			.single-product .woocommerce-product-details__short-description,
			.single-product .woocommerce-tabs.wc-tabs-wrapper .woocommerce-Tabs-panel p,
			.product span.price,
			.product-sidebar .widget ul li a,
			.product-main-section .woocommerce-result-count,
			.woocommerce-MyAccount-content .u-columns.woocommerce-Addresses .woocommerce-Address address, 
			section.woocommerce-customer-details section.woocommerce-columns .woocommerce-column address,
			form.woocommerce-ResetPassword label, 
			form.woocommerce-form.woocommerce-form-register.register label, 
			form.woocommerce-form.woocommerce-form-login.login label, 
			.woocommerce-MyAccount-content form.woocommerce-EditAccountForm label, 
			.woocommerce-MyAccount-content form .woocommerce-address-fields__field-wrapper label, 
			form.checkout #customer_details label,
			.woocommerce-MyAccount-content,
			table.shop_table thead th,
			.woocommerce-MyAccount-content table.woocommerce-orders-table tbody tr.woocommerce-orders-table__row td.woocommerce-orders-table__cell,
			.mfp-close-btn-in .mfp-close,
			form.pm-form.pm-form--compose-message label, 
			form.pm-form.pm-form--compose-message p.pm-form__row.pm-form__row--attachments,
			table.pm-table.pm-table--messages-list tr td.pm-column a,
			div#astoundify-favorites-dashboard-lists table tbody .astoundify-favorite-list td, div#astoundify-favorites-dashboard-favorites table tbody .astoundify-favorite td,
			div#astoundify-favorites-dashboard-lists table tbody .astoundify-favorite-list td a, div#astoundify-favorites-dashboard-favorites table tbody .astoundify-favorite td a,
			#job-manager-job-dashboard table .job_title small,
			table.job-manager-jobs tbody tr td .job-dashboard-actions a,
			table.job-manager-jobs tbody tr td.date,
			table.job-manager-jobs tbody tr td.expires,
			.post-pagination-sec .page-numbers,
			.post-detail-content-sec p,
			.job-manager-form fieldset label,
			div#job-manager-job-dashboard p,
			.single_job_listing .company .tagline,
			.single-post-main-section .comments-area .comment-content p,
			.widget-title-desc-caption p,
			.content-box .job-listing-details .job-location span,
			.home-feature .home-feature-description p,
			ul.tabbed-listings-tabs li a,
			.review_slider .review_caption_content .review_auhtor_content .review_comment,
			.post-section .post-grid-section .post-content .post-pubished-details,
			.account-notice-cls,
			.single-post-main-section .post-details p,
			.post-share-section a,
			.post-other-info .post-comment-count,
			.post-details-section .post-time-info,
			.sidebar-content .widget_categories li,
			.sidebar-content .widget_categories li a, 
			.post-share-section,
			.author-info .author-name,
			.single-post-main-section .post-content-sec p,
			.single-post-main-section .post-published_date,
			.pointify .custom-menu-container .menu-item-has-children:hover:after,
			.pointify .site-header .main-navigation ul li a:hover,
			.single-post-main-section .comments-area .comment-metadata,		
			.single-post-main-section .comments-title,
			.single-post-main-section .comment-reply-title,
			.single-post-main-section .comment-form textarea,
			.single-post-main-section .comment-form input,
			.single-post-main-section .comment-form textarea::placeholder,
			.single-post-main-section .comment-form input::placeholder,
			.single-post-main-section .comment-form .comment-notes,
			.single-post-main-section .comment-form .comment-form-cookies-consent,
			.single-post-main-section .comment-form .logged-in-as,
			.single-post-main-section .comment-form .form-submit .submit,			
			.sidebar-content #user-carousel p.admin-name,		
			.sidebar-content .latest-post .post-content h4, 		
			.post-detail-content-sec .entry-title, 
			.single-post-main-section .comments-area footer.comment-meta a,
			.search_popup_content .search-submit:hover{
				color: <?php echo esc_html(get_theme_mod('body_text_color', '#666666')); ?>;
			}
		<?php } ?>
		.post-pg-main-sec .page-content .search-form .search-submit:hover,
		.single-post-main-section .comments-area article .comment-author b:after,
		.page_header_section:before{
			background-color:<?php echo esc_html(get_theme_mod('body_text_color', '#000000')); ?>;
		}
		.post-pg-main-sec .page-content .search-form .search-submit:hover,
		.post-pagination-sec .page-numbers{
			border-color:<?php echo esc_html(get_theme_mod('body_text_color', '#000000')); ?>;
		}
		
		/*=====Link-color======*/
		
		nav.tertiary-navigation ul.tertiary li a,
		.review_btn_cls a:hover,
		nav.woocommerce-MyAccount-navigation ul li.woocommerce-MyAccount-navigation-link a,
		.woocommerce-MyAccount-content a,
		.sidebar-content .tagcloud a,
		.single-post-main-section .post-details .more-link,
		.sidebar-content .latest-post .post-content h4 a,
		.single-post-main-section .post-tags-sec .post-tag-cls a,
		.single-post-main-section .comments-area .reply a,
		.single-post-main-section .comments-area footer.comment-meta a,
		.post-detail-content-sec .more-link,
		a{
			color: <?php echo esc_html(get_theme_mod('link_color', '#000000')); ?>;
		}
		.sidebar-content .tagcloud a:hover,
		.post-detail-content-sec .more-link:hover{
			background-color:<?php echo esc_html(get_theme_mod('link_color', '#000000')); ?>;
		}
		
		/* Dark Background Text Color Start */

		body.lawyer .home-feature-title h4,
		body.lawyer .recently-viewed-jobs .widget-title-desc-caption h4, 
		body.lawyer .recently-viewed-jobs .widget-title-desc-caption h3, 
		body.lawyer .recently-viewed-jobs .widget-title-desc-caption p,
		body.job_board .review_job_board_cls .widget-title-desc-caption h3,
		body.job_board .review_job_board_cls .widget-title-desc-caption p,
		.claim-verified, 
		.claim-user-notice a,
		.job-title h4,
		.listing-pricing h5, 
		.job-location span,
		.review_btn_cls a,
		div#job-manager-job-dashboard .account-sign-in, 
		.job-manager-form fieldset .field.account-sign-in,
		.page_breadcrumb_sec,
		.page_header_section .page_breadcrumb_sec a,
		.pointify-page-header .pointify-page-title, 
		.pointify-page-header .pointify-blog-title,
		.pointify-cta-sections .widget-title-desc-caption h2,
		.pointify-cta-sections .widget-title-desc-caption p,
		.pointify-how-it-works .widget-title-desc-caption h3,
		.pointify-how-it-works .widget-title-desc-caption p,
		.term-list h4 a,
		.term-list h4,
		.content-section p,
		.content-section h2{
			color:<?php echo esc_html(get_theme_mod('dark_bg_text_color', '#fff')); ?>;
		}

		.review_btn_cls a:hover{
			background-color:<?php echo esc_html(get_theme_mod('dark_bg_text_color', '#fff')); ?>;
		}

		/* Dark Background Text Color Start */

		/* Header Dynamic CSS Start */

		.pointify .site-header{
			background-color:<?php echo esc_html(get_theme_mod('header_background_colors', '#fff')); ?>;
		}
		.pointify .custom-menu-container .menu-item-has-children:after,
		.pointify .site-header .mobile-navigation ul>li>a, 
		.pointify .site-header .main-navigation ul>li>a {
			color: <?php echo esc_html(get_theme_mod('navigation_text_colors', '#000000')); ?>;
		}
		.pointify .site-header .header-icons span svg path {
			fill: <?php echo esc_html(get_theme_mod('navigation_text_colors', '#000000')); ?>;
		}
		.pointify .user-icon .custom-user-menu-container ul li a,
		.pointify .site-header .main-navigation ul li ul.sub-menu ::after,
		.pointify .site-header .main-navigation ul li ul li a {
			color: <?php echo esc_html(get_theme_mod('navigation_dropdown_text_colors', '#000000')); ?>;
		}
		.pointify .site-header.sticky .custom-menu-container .menu-item-has-children:after,
		.pointify .site-header.sticky .main-navigation ul>li>a {
			color: <?php echo esc_html(get_theme_mod('sticky_navigation_text_colors', '#000000')); ?>;
		}
		.pointify .site-header.sticky .header-icons span svg path {
			fill: <?php echo esc_html(get_theme_mod('sticky_navigation_text_colors', '#000000')); ?>;
		}
		.pointify .site-header.sticky .user-icon .custom-user-menu-container ul li a,
		.pointify .site-header.sticky .main-navigation ul li ul.sub-menu ::after,
		.pointify .site-header.sticky .main-navigation ul li ul li a {
			color: <?php echo esc_html(get_theme_mod('sticky_navigation_dropdown_text_colors', '#000000')); ?>;
		}
		.pointify .site-header .header-right .header_btn a {
			color: <?php echo esc_html(get_theme_mod('header_btn_text_colors', '#000000')); ?>;
		}
		.pointify .site-header .header-right .header_btn a {
			background-color: <?php echo esc_html(get_theme_mod('header_btn_bg_colors', '#fff')); ?>;
		}
		.pointify .site-header .header-right .header_btn a {
			border-color: <?php echo esc_html(get_theme_mod('header_btn_border_colors', '#000000')); ?>;
		}
		.pointify .site-header .header-right .header_btn a:hover {
			color: <?php echo esc_html(get_theme_mod('header_btn_text_hover_colors', '#fff')); ?>;
		}
		.pointify .site-header .header-right .header_btn a:hover {
			background-color: <?php echo esc_html(get_theme_mod('header_btn_bg_hover_colors', '#000')); ?>;
		}
		.pointify .site-header .header-right .header_btn a:hover {
			border-color: <?php echo esc_html(get_theme_mod('header_btn_hover_border_colors', '#000000')); ?>;
		}

		/* Header Dynamic CSS End */

		/* Inputs Dynamic CSS start */

		.woocommerce-MyAccount-content form .woocommerce-address-fields__field-wrapper textarea, 
		form.checkout #customer_details textarea,
		table.shop_table tr.cart_item td.product-quantity input,
		table.shop_table tbody tr td.actions .coupon input,
		tr.woocommerce-shipping-totals.shipping input, 
		tr.woocommerce-shipping-totals.shipping span.select2.select2-container span.select2-selection,
		.woocommerce-Reviews div#review_form_wrapper form#commentform p.comment-form-author input, 
		.woocommerce-Reviews div#review_form_wrapper form#commentform p.comment-form-email input,
		.woocommerce-Reviews div#review_form_wrapper form#commentform p.comment-form-comment textarea,
		.product-main-section form.woocommerce-ordering select,
		.product-sidebar .widget form.woocommerce-product-search input,
		form.woocommerce-ResetPassword input, 
		form.woocommerce-form.woocommerce-form-register.register input, 
		form.woocommerce-form.woocommerce-form-login.login input, 
		.woocommerce-MyAccount-content form.woocommerce-EditAccountForm input, 
		.woocommerce-MyAccount-content form .woocommerce-address-fields__field-wrapper input, 
		form.checkout #customer_details input,
		.post-pg-main-sec .page-content .search-form .search-field,
		form.astoundify-favorites-form-list-edit input, 
		.astoundify-favorites-list-field select.astoundify_favorites_list,
		.astoundify-favorites-note-field,
		form.pm-form.pm-form--compose-message input, 
		form.pm-form.pm-form--compose-message span.select2,
		form.pm-form.pm-form--filters select,
		.job-manager-form fieldset .field input, 
		.job-manager-form fieldset .field select, 
		.job-manager-form fieldset .field span.select2 span.select2-selection,
		.theme-pointify .select2-container--default .select2-results__option,
		.pointify-hero-search form.job_search_form .search_jobs input, 
		.pointify-hero-search form.job_search_form .search_jobs select, 
		.pointify-hero-search form.job_search_form .search_jobs .select2-selection {
			color:<?php echo esc_html(get_theme_mod('inputs_text_colors', '#263238')); ?>;
		}

		.woocommerce-MyAccount-content form .woocommerce-address-fields__field-wrapper textarea, 
		form.checkout #customer_details textarea,
		table.shop_table tr.cart_item td.product-quantity input,
		table.shop_table tbody tr td.actions .coupon input,
		tr.woocommerce-shipping-totals.shipping input, 
		tr.woocommerce-shipping-totals.shipping span.select2.select2-container span.select2-selection,
		.woocommerce-Reviews div#review_form_wrapper form#commentform p.comment-form-author input, 
		.woocommerce-Reviews div#review_form_wrapper form#commentform p.comment-form-email input,
		.woocommerce-Reviews div#review_form_wrapper form#commentform p.comment-form-comment textarea,
		.product-sidebar .widget form.woocommerce-product-search input,
		.woocommerce-MyAccount-content form .woocommerce-address-fields__field-wrapper span.select2-selection, form.checkout #customer_details span.select2-selection,
		form.woocommerce-ResetPassword input, 
		form.woocommerce-form.woocommerce-form-register.register input, 
		form.woocommerce-form.woocommerce-form-login.login input, 
		.woocommerce-MyAccount-content form.woocommerce-EditAccountForm input, 
		.woocommerce-MyAccount-content form .woocommerce-address-fields__field-wrapper input, 
		form.checkout #customer_details input,
		.post-pg-main-sec .page-content .search-form .search-field,
		form.astoundify-favorites-form-list-edit input, 
		.astoundify-favorites-list-field select.astoundify_favorites_list,
		.astoundify-favorites-note-field,
		.select2-container--default .select2-selection--single .select2-selection__rendered,
		form.pm-form.pm-form--compose-message input, 
		form.pm-form.pm-form--compose-message span.select2,
		form.pm-form.pm-form--filters select,
		.pointify-hero-search form.job_search_form .search_jobs input, 
		.pointify-hero-search form.job_search_form .search_jobs select, 
		.pointify-hero-search form.job_search_form .search_jobs .select2-selection,
		.job-manager-form fieldset .field input, 
		.job-manager-form fieldset .field select, 
		.job-manager-form fieldset .field span.select2 span.select2-selection {
			background-color:<?php echo esc_html(get_theme_mod('inputs_background_colors', '#FDFDFD')); ?>;
		}

		.woocommerce-MyAccount-content form .woocommerce-address-fields__field-wrapper textarea, 
		form.checkout #customer_details textarea,
		table.shop_table tr.cart_item td.product-quantity input,
		table.shop_table tbody tr td.actions .coupon input,
		tr.woocommerce-shipping-totals.shipping input, 
		tr.woocommerce-shipping-totals.shipping span.select2.select2-container span.select2-selection,
		.woocommerce-Reviews div#review_form_wrapper form#commentform p.comment-form-author input, 
		.woocommerce-Reviews div#review_form_wrapper form#commentform p.comment-form-email input,
		.woocommerce-Reviews div#review_form_wrapper form#commentform p.comment-form-comment textarea,
		.product-sidebar .widget form.woocommerce-product-search input,
		.woocommerce-MyAccount-content form .woocommerce-address-fields__field-wrapper span.select2-selection, form.checkout #customer_details span.select2-selection,
		form.woocommerce-ResetPassword input, 
		form.woocommerce-form.woocommerce-form-register.register input, 
		form.woocommerce-form.woocommerce-form-login.login input, 
		.woocommerce-MyAccount-content form.woocommerce-EditAccountForm input, 
		.woocommerce-MyAccount-content form .woocommerce-address-fields__field-wrapper input, 
		form.checkout #customer_details input,
		.post-pg-main-sec .page-content .search-form .search-field,
		form.astoundify-favorites-form-list-edit input, 
		.astoundify-favorites-list-field select.astoundify_favorites_list,
		.astoundify-favorites-note-field,
		form.pm-form.pm-form--compose-message input, 
		form.pm-form.pm-form--compose-message span.select2,
		form.pm-form.pm-form--filters select,
		.pointify-hero-search form.job_search_form .search_jobs input, 
		.pointify-hero-search form.job_search_form .search_jobs select, 
		.pointify-hero-search form.job_search_form .search_jobs .select2-selection,
		.job-manager-form fieldset .field input, 
		.job-manager-form fieldset .field select, 
		.job-manager-form fieldset .field span.select2 span.select2-selection {
			border-color:<?php echo esc_html(get_theme_mod('inputs_border_colors', '#c7c7c759')); ?>;
		}

		/* Inputs Dynamic CSS end */

		/* Footer Dynamic CSS Start */

		footer.copyright_footer{
			background-color:<?php echo esc_html(get_theme_mod('footer_background_colors', '#2B2C30')); ?>;
		}
		footer.copyright_footer .copyright_text {
			color: <?php echo esc_html(get_theme_mod('footer_text_colors', '#888888')); ?>;
		}
		footer.widget_footer{
			background-color:<?php echo esc_html(get_theme_mod('footer_widgets_background_colors', '#191A1C')); ?>;
		}
		.footer-widget .widget-title {
			color: <?php echo esc_html(get_theme_mod('footer_widgets_title_text_colors', '#fff')); ?>;
		}
		.latest-post .post-content p,
		.latest-post .post-content h4, 
		.latest-post .post-content h4 a,
		.footer-widget .widget.widget_text .textwidget,
		.footer-widget ul li a {
			color: <?php echo esc_html(get_theme_mod('footer_widgets_body_text_colors', '#DBDBDB')); ?>;
		}

		/* Footer Dynamic CSS End */


    </style>
	<?php
}
add_action('wp_head', 'pointify_apply_customizer_styles'); 

