<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Pointify_-_Listing_Directory_WordPress_Theme
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site pointify">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'pointify' ); ?></a>
	<?php 
	$hedear_sticky = get_theme_mod('enable_sticky_header', false); 
	$hedear_transparent = get_theme_mod('header_transparent', false); 

	?>
	<header id="masthead" class="site-header <?php if($hedear_sticky){ echo 'header_sticky'; } if($hedear_transparent){ echo ' hedear_transparent'; } ?> <?php if ( !class_exists('WooCommerce')) { ?> default-theme  <?php } ?>">
		<div class="container">
			<div class="row pontify_header_content">
				<div class="<?php if (class_exists('WooCommerce')) { ?>col-6 col-md-2 col-lg-2 col-xl-3<?php }else{ ?>col-6 col-md-2 col-lg-2 col-xl-2<?php } ?>">
					<div class="site-branding">
						<?php
						$custom_logo_id = get_theme_mod('custom_logo');
						$logo_image = wp_get_attachment_image_src($custom_logo_id, 'full');
						if (!empty($logo_image)) { ?>
							<h1 class="site_logo">
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo( 'name' ); ?>" rel="home">
									<img src="<?php echo esc_url($logo_image[0]); ?>" alt="<?php bloginfo( 'name' ); ?>">
								</a>
							</h1>
						<?php } else { ?>
							<h1 class="site-title">
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo( 'name' ); ?>" rel="home">
									<?php bloginfo( 'name' ); ?>
								</a>
							</h1>
							<?php
						}
						?>
					</div><!-- .site-branding -->
				</div>				
				<div class="<?php if (class_exists('WooCommerce')) { ?>col-md-6 col-lg-6 col-xl-5<?php } else { ?>col-md-9 col-lg-9 col-xl-9<?php } ?>">	
					<nav id="site-navigation" class="main-navigation">
						<?php
							wp_nav_menu(array(
								'theme_location'  => 'menu-1',
								'container'       => 'nav',
								'container_class' => 'custom-menu-container',
								'menu_class'      => 'custom-menu',
								'depth'           => 3, // Set the depth for three levels of submenus
								'fallback_cb' => 'pointify_custom_menu_fallback',
							));
						?>
					</nav>
				</div>
				<!-- Login form Popup -->
				<div id="login-popup" class="popup">
					<div class="popup-content">
						<div class="popup-section">
							<div class="popup-section-image">
								<?php 
									$login_popup_img = get_theme_mod('login_popup_image');	
									if(!empty($login_popup_img)) {
										?>
										<img src="<?php echo esc_url($login_popup_img); ?>" alt="<?php esc_attr_e( 'form-image', 'pointify' ); ?>">
										<?php
									}else {
										?>
										<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/form-popup-img.jpg" alt="<?php esc_attr_e( 'form-image', 'pointify' ); ?>">
										<?php
									}
								?>
							</div>
							<div class="popup-form">
								<span class="close closePopup"><span class="cross-span">&times;</span></span>
								<?php if (!is_user_logged_in()) { ?>
									<div class="form-title">
										<h2><?php esc_html_e( 'Sign Up', 'pointify' ); ?></h2>
									</div>
								<?php }
									if (class_exists('WooCommerce')) {
										woocommerce_login_form();
									}
									if (is_user_logged_in()) {
										$current_user = wp_get_current_user();
										// Get the logout URL
										$logout_url = wp_logout_url();
										// Display the username and logout button
										echo '<span class="account-notice-cls">Welcome, ' . esc_html($current_user->user_login) . ' | <a href="' . esc_url($logout_url) . '">Logout</a></span>';
									}
									if (!is_user_logged_in()) {
								?>
								<span class="account-notice-cls"><?php esc_html_e( 'Dont’t have an account ?', 'pointify' ); ?> <a href="#" id="open-registration-popup"><?php esc_html_e( 'Sign up now', 'pointify' ); ?></a></span>
								<?php } ?>
							</div>
						</div>
						
					</div>
				</div>
				<!-- Register Form Popup -->
				<div id="registration-popup" class="popup" style="display: none;">
					<div class="popup-content">
						<div class="popup-section">
							<div class="popup-section-image">
								<?php 
									$signup_popup_image = get_theme_mod('signup_popup_image');	
									if(!empty($signup_popup_image)) {
										?>
										<img src="<?php echo esc_url($signup_popup_image); ?>" alt="<?php esc_attr_e( 'form-image', 'pointify' ); ?>">
										<?php
									}else {
										?>
										<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/register-form-popup-img.jpg" alt="<?php esc_attr_e( 'form-image', 'pointify' ); ?>">
										<?php
									}
								?>
							</div>
							<div class="popup-form">
								<span class="close closeRegisterPopup"><span class="cross-span">&times;</span></span>
								<?php if (!is_user_logged_in()) { ?>
									<div class="form-title">
										<h2><?php esc_html_e( 'Register', 'pointify' ); ?></h2>
									</div>
								<?php echo do_shortcode('[woocommerce_my_account register]'); } ?>
								<span class="account-notice-cls"><?php esc_html_e( 'Already have an account ?', 'pointify' ); ?> <a href="#" id="open-loggedin-popup" title="<?php esc_attr_e( 'Login now', 'pointify' ); ?>"><?php esc_html_e( 'Login now', 'pointify' ); ?></a></span>
							</div>
						</div>
						
					</div>
				</div>
				<div class="<?php if (class_exists('WooCommerce')) { ?>col-6 col-md-4 col-lg-4 col-xl-4<?php } else { ?>col-6 col-md-1 col-lg-1 col-xl-1<?php } ?>">
					<div class="header-right">
						<div class="header-icons">
							<!-- Search Icon -->
							<?php
							$search = get_theme_mod('hide_search', false); 
							if(! $search){
							?>
								<span class="search-icon">
									<a href="#" id="search-icon" title="<?php esc_attr_e( 'Search', 'pointify' ); ?>"><?php echo pointify_search_icon(); ?></a>
								</span>
								<div class="search-popup" id="search-popup">
									<div class="search_popup_content">
										<?php get_search_form(); ?>
										<span class="close-btn">
											<a href="#" title="<?php esc_attr_e( 'Close', 'pointify' ); ?>"><?php echo pointify_close_icon(); ?></a>
										</span>
									</div>
								</div>
								<?php
							} ?>
							<!-- User Icon -->
							<?php	
							// Check if WooCommerce is active
							if (class_exists('WooCommerce')) { ?>

								<span class="user-icon">
									<a class="user-icon-link" href="#" title="<?php esc_attr_e( 'user', 'pointify' ); ?>" >
										<?php echo pointify_user_icon(); ?>
										
									</a>
									<?php
										wp_nav_menu(array(
											'theme_location'  => 'user-menu',											
											'container_class' => 'custom-user-menu-container',
											'menu_class'      => 'custom-user-menu',
											'fallback_cb' => false,
										));
									?>
								</span>
							<?php
							}  
							?>
							<!-- Favorites Icon -->
							<?php
							//Favorites by Astoundify
							if (class_exists('Astoundify\Favorites\Favorite')) {
								$favorites = get_theme_mod('hide_favorites', false); 
								if(! $favorites){
								?>	<span class="favorites-icon">
										<a href="<?php echo esc_url( home_url( '/' ) ); ?>my-favorites/" title="<?php esc_attr_e( 'favorites', 'pointify' ); ?>"><?php echo pointify_favorites_icon(); ?></a>
									</span>
								<?php
								} 
							}
							?>
							<!-- Listing Button -->
							<?php
							if (class_exists('WP_Job_Manager')) {
									$add_listing_text = get_theme_mod('header_add_listing_text'); 
									$add_listing_url = get_theme_mod('header_add_listing_url'); 
								?>
								<span class="header_btn">
									<?php if(!empty($add_listing_text)) { ?>
									<a href="<?php echo $add_listing_url; ?>" class="listing-button" title="<?php esc_attr_e( 'Listing', 'pointify' ); ?>"><?php echo $add_listing_text; ?><i class="fa fa-plus" aria-hidden="true"></i></a>
									<?php } else {
										?>
									<a href="<?php echo $add_listing_url; ?>" class="listing-button" title="<?php esc_attr_e( 'Listing', 'pointify' ); ?>"><?php esc_html_e( 'Add Listing', 'pointify' ); ?><i class="fa fa-plus" aria-hidden="true"></i></a>
										<?php
									}?>
								</span>
							<?php
							}
							?>
						</div>
						<a href="#" id="toggle" class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
							<span class="menu-bar1 bar"></span>
							<span class="menu-bar2 bar"></span>
							<span class="menu-bar3 bar"></span>
						</a>
					</div>
				</div>
				<div class="col-md-12 mobile_navigation_wrapper">
					<nav class="mobile-navigation">
						<?php
							wp_nav_menu(array(
								'theme_location'  => 'menu-1',
								'container'       => 'nav',
								'container_class' => 'mobile-menu-container',
								'menu_class'      => 'mobile-menu',
								'depth'           => 3, // Set the depth for three levels of submenus
							)); 
						?>
					</nav><!-- #site-navigation -->
				</div>
			</div>
		</div>
	</header><!-- #masthead -->
	
	<div class="main-content" id="primary">
	<!-- #masthead -->
