<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Pointify_-_Listing_Directory_WordPress_Theme
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if (post_password_required()) {
    return;
}

// Check if comments are open or if there are comments.
if (comments_open() || get_comments_number()) :
?>
<div id="comments" class="comments-area">

    <?php if (have_comments()) : ?>
        <h2 class="comments-title">
            <?php
            $pointify_comments_number = get_comments_number();
            if ($pointify_comments_number === 1) {
                echo esc_html__('One Comment', 'pointify');
            } else {
                echo esc_html__('Comments 0', 'pointify'). esc_html($pointify_comments_number);
            }
            ?>
        </h2>

        <ol class="comment-list">
            <?php
            wp_list_comments(array(
                'style'       => 'ol',
                'short_ping'  => true,
                'avatar_size' => 60,
            ));
            ?>
        </ol>

        <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
            <nav id="comment-nav-below" class="comment-navigation" role="navigation">
                <div class="nav-previous"><?php previous_comments_link(esc_html__('Older Comments', 'pointify')); ?></div>
                <div class="nav-next"><?php next_comments_link(esc_html__('Newer Comments', 'pointify')); ?></div>
            </nav>
        <?php endif; ?>

    <?php endif; ?>

    <?php
    // If comments are closed and there are comments, show a notice.
    if (!comments_open() && get_comments_number() && post_type_supports(get_post_type(), 'comments')) :
    ?>
        <p class="no-comments"><?php esc_html_e('Comments are closed.', 'pointify'); ?></p>
    <?php endif; ?>

    <?php
		$placeholder_author = __('Full Name', 'pointify');
		$placeholder_email = __('Email', 'pointify');
		$placeholder_url = __('Website', 'pointify');
		$placeholder_comment = __('Your Message', 'pointify');
		$pointify_comment_form_args = array(
        'title_reply'          => esc_html__('Leave a Comment', 'pointify'),
        'comment_notes_before' => '<p class="comment-notes">' . esc_html__('Your email address will not be published. Required fields are marked *', 'pointify') . '</p>',
        'fields'               => array(
            'author' => '<p class="comment-form-author"><label for="author"></label> ' .
                        '<input id="author" name="author" type="text"  placeholder="'.$placeholder_author.'" value="' . esc_attr($commenter['comment_author']) . '" size="30" required /></p>',
            'email'  => '<p class="comment-form-email"><label for="email"></label> ' .
                        '<input id="email" name="email" type="email" placeholder="'.$placeholder_email.'" value="' . esc_attr($commenter['comment_author_email']) . '" size="30" required /></p>',
            'url'    => '<p class="comment-form-url"><label for="url"></label> ' .
                        '<input id="url" name="url" type="url" placeholder="'.$placeholder_url.'" value="' . esc_attr($commenter['comment_author_url']) . '" size="30" /></p>',
        ),
        'comment_field'        => '<p class="comment-form-comment"><label for="comment"></label> ' .
                                  '<textarea id="comment" placeholder="'.$placeholder_comment.'" name="comment" cols="45" rows="8" required></textarea></p>',
        'submit_button'        => '<input name="%1$s" type="submit" id="%2$s" class="%3$s" value="Comment" />',
        'format'               => 'xhtml',
    );

    comment_form($pointify_comment_form_args);
    ?>

</div><!-- #comments -->
<?php endif;
