/**
 * Toggle JS
 **/ 

jQuery(document).ready(function ($) {
	// Mobile Menu
	jQuery("#toggle").click(function(e) {
	  e.preventDefault(); 	
	  jQuery(this).toggleClass("toggle_active");
	  jQuery(".mobile-navigation").slideToggle();
	});
	
	jQuery(".pointify .custom-menu-container .custom-menu li ul>li>a, .pointify .site-header .mobile-navigation li ul>li>a").focus(function(){
		
		if(jQuery(this).closest('.menu-item-has-children').closest('.sub-menu').parent('li').hasClass('menu-item-has-children')){
			jQuery(this).closest('.menu-item-has-children').closest('.sub-menu').parent('li').addClass('focused');
			
		}else {
			jQuery(this).closest('.menu-item-has-children').addClass('focused');
		}
	});
	
	jQuery(".pointify .custom-menu-container .custom-menu li ul>li>ul>li>a, .pointify .site-header .mobile-navigation li ul>li>ul>li>a").focus(function(){
		jQuery(this).closest('.menu-item-has-children').addClass('focused');
	});

	jQuery(document).on('click', '.pointify .site-header .mobile-navigation li>a', function(){
		jQuery(this).closest('.menu-item-has-children').toggleClass('focused');
	});

	jQuery(".pointify .custom-menu-container .custom-menu li ul>li>a, .pointify .site-header .mobile-navigation li ul>li>a").focusout(function(){
		
		if(jQuery(this).closest('.menu-item-has-children').closest('.sub-menu').parent('li').hasClass('menu-item-has-children')){
			jQuery(this).closest('.menu-item-has-children').closest('.sub-menu').parent('li').removeClass('focused');
			jQuery(this).closest('.menu-item-has-children').removeClass('focused'); 
		}else {
			jQuery(this).closest('.menu-item-has-children').removeClass('focused');
		}
		
	});
	

	
	// Mobile Resize
	jQuery(window).on('resize', function() {
	if(jQuery(window).width() >= 992){
		jQuery('.mobile-navigation').hide();
	}
	}).trigger('resize');
	
	// Search
	jQuery('#search-icon').click(function(e) {
		e.preventDefault();
		jQuery('#search-popup').fadeIn();
	});
	
	/* Search on focus */
	jQuery("#search-icon").focus(function(){
		jQuery(this).parent().next().fadeIn();
		jQuery(this).parent().next().find('input[type="search"]').focus();
	});

	// Click event for .close-btn
	jQuery('.close-btn').click(function(e) {
		e.preventDefault();
		jQuery('body').css("overflow", "auto");
		jQuery('#search-popup').fadeOut();
	});
	
	// User Icon Toggle
	
	jQuery('.user-icon .user-icon-link').click(function(event) {
 		jQuery('.pointify .site-header .user-icon .custom-user-menu-container').toggleClass("user_active");
		event.stopPropagation();
		event.preventDefault();
	});
	jQuery(document).click(function() { 
		jQuery('.pointify .site-header .user-icon .custom-user-menu-container').removeClass('user_active');
	});	
	
	if ($('#masthead').hasClass('header_sticky')) {
		jQuery(window).scroll(function() {
			var scroll = jQuery(window).scrollTop();
			var header = jQuery('header');
			
			if (scroll >= 100) {
				header.addClass('sticky');
			} else {
				header.removeClass('sticky');
			}

		}); 
	}
	/****User Widget****/
	if ($('body').hasClass('rtl')) {
		if (jQuery("#user-carousel").length) {
			jQuery("#user-carousel").owlCarousel({ 
				items: 1,
				loop: true,
				margin: 10, 
				autoplay: true, 
				animateIn: 'fadeIn',
				touchDrag: false,
				mouseDrag: true,
				autoplayHoverPause: true ,
				dots:false,
				rtl: true
			});  
		}
	} else {
		if (jQuery("#user-carousel").length) {
			jQuery("#user-carousel").owlCarousel({ 
				items: 1,
				loop: true,
				margin: 10, 
				autoplay: true, 
				animateIn: 'fadeIn',
				touchDrag: false,
				mouseDrag: true,
				autoplayHoverPause: true ,
				dots:false,
			});  
		}
	}
	/**
	 * Review Slider CSS
	 */
	
	if ($('body').hasClass('rtl')) {
        // If body has 'rtl' class
        if ($(".review_slider").length) {
            $('.review_slider').owlCarousel({
                center: true,
                items: 1,
                loop: true,
                margin: 30,
                rtl: true,
                responsive: {
                    600: {
                        items: 2
                    }
                }
            });
        }
    } else {
        // If body does not have 'rtl' class
        if ($(".review_slider").length) {
            $('.review_slider').owlCarousel({
                center: true,
                items: 1,
                loop: true,
                margin: 30,
                responsive: {
                    600: {
                        items: 2
                    }
                }
            });
        }
    }

	// Tertiary Menu

	jQuery( '.navigation-bar-toggle' ).click(function(e) {
		e.preventDefault();
		$(this).toggleClass( 'active' ).next().toggleClass( 'active' );
	});

});


/**
 * Post Like Js
 */

jQuery(document).ready(function ($) {
    $('.custom-like-button').on('click', function () {
        var post_id = custom_like_vars.post_id;
        var nonce = custom_like_vars.nonce;

        $.ajax({
            type: 'post',
            url: custom_like_vars.ajax_url,
            data: {
                action: 'custom_like',
                post_id: post_id,
                nonce: nonce,
            },
            success: function (response) {
                console.log(response);
                $('.custom-like-count').html(response.likes);
            },
        });
    });
});

// Login Form Popup

jQuery(document).ready(function ($) {
	jQuery('.login-popup-trigger').click(function(e) {
		e.preventDefault();
		jQuery('#login-popup').css("display", "flex");
		jQuery('html').css("overflow", "hidden");
	});

	jQuery('.closePopup').click(function(e){
		e.preventDefault();
		jQuery('#login-popup').css("display", "none");
		jQuery('html').removeAttr("style");
	});
});

jQuery(document).ready(function($) {
    // Click event for the "Register" button
    $('#open-registration-popup').on('click', function(e) {
        e.preventDefault();
        // Show the registration popup
        $('#registration-popup').css("display", "flex");
		jQuery('#login-popup').removeAttr("style");
		jQuery('#registration-popup .u-column1').remove();
		jQuery('html').css("overflow", "hidden");
		jQuery('#registration-popup .woocommerce-privacy-policy-text').remove();
		jQuery('#registration-popup div#customer_login .u-column2 h2').remove();
    });

	jQuery('.closeRegisterPopup').click(function(e){
		e.preventDefault();
		jQuery('#registration-popup').css("display", "none");
		jQuery('html').removeAttr("style");
	});

	jQuery('#open-loggedin-popup').click(function(e) {
		e.preventDefault();
		jQuery('#registration-popup').css("display", "none");
		jQuery('#login-popup').css("display", "flex");
		jQuery('html').css("overflow", "hidden");
	});

	/**
	 * Higlisted text js
	 */

	var hero_title = $(".hero-title");
	var targetWord = hero_title.data('highlighted');
	var originalText = hero_title.text();
	var newText = originalText.replace(new RegExp(targetWord, "gi"), '<span class="special-widget-text">' + targetWord + '</span>');
	hero_title.html(newText);

	/**
	 * Higlisted desc text js
	 */

	var hero_desc = $(".hero-desc");
	var targetWord = hero_desc.data('highlighted-desc');
	var originalText = hero_desc.text();
	var newText = originalText.replace(new RegExp(targetWord, "gi"), '<span class="bold-widget-text">' + targetWord + '</span>');
	hero_desc.html(newText);

	/**
	 * Higlisted heading text js
	 */

	jQuery(".high_text").each(function() {
		var high_text = $(this);
		var targetWord = high_text.data('hight-text');
		var originalText = high_text.text();
		var newText = originalText.replace(new RegExp(targetWord, "gi"), '<span class="special-widget-text">' + targetWord + '</span>');
		high_text.html(newText);
	});
	
	// var high_text = $(".high_text");
	// var targetWord = high_text.data('hight-text');
	// var originalText = high_text.text();
	// var newText = originalText.replace(new RegExp(targetWord, "gi"), '<span class="special-widget-text">' + targetWord + '</span>');
	// high_text.html(newText);

	/**
	 * Tabbed Js
	 */
	var $tabWrapper = $( '.tabbed-listings-tabs-wrapper' );
	var $buttonsWrapper = $( '.tabbed-listings-tabs' );

	$tabWrapper.find( '> div' ).hide().filter( ':first-child' ).show();
	$buttonsWrapper.find( 'li:first-child a' ).addClass( 'active' );

	$buttonsWrapper.on( 'click', 'li a', function(e) {
		e.preventDefault();

		$buttonsWrapper.find( 'li a' ).removeClass( 'active' );
		$(this).addClass( 'active' );

		var activeTab = $(this).attr( 'href' );

		$( this ).parents( '.widget_pointify_tabbed_listing_widget' ).find( '.listings-tab' ).hide().filter( activeTab ).show();
	});

	// Review Slider 2

	// var swiper = new Swiper('.swiper-container', {
	// 	direction: 'vertical',
	// 	slidesPerView: 1,
	// 	spaceBetween: 20,
	// 	pagination:  false,
	// });


	if ($('body').hasClass('rtl')) {

		var slider = new Swiper(".gallery-slider", {
			slidesPerView: "auto",
			centeredSlides: true,
			spaceBetween: 20,
			loop: false,
			rtl: true,
			// loopedSlides: 5, 
			slideToClickedSlide: true,
			navigation: {
				nextEl: ".swiper-button-next",
				prevEl: ".swiper-button-prev"
			},
			breakpoints: {
				// When window width is <= 495px
				496: {
					slidesPerView: "auto",
					centeredSlides: true,
					spaceBetween: 20,
				},
				320: {
					slidesPerView: "auto",
					centeredSlides: false,
					spaceBetween: 20,
				}
			}
		});


		var thumbs = new Swiper(".gallery-thumbs", {
			slidesPerView: "auto",
			spaceBetween: 30,
			centeredSlides: true,
			loop: false,
			rtl: true,
			slideToClickedSlide: true
		});

		slider.controller.control = thumbs;
		thumbs.controller.control = slider;

	} else {

		var slider = new Swiper(".gallery-slider", {
			slidesPerView: 1,
			centeredSlides: true,
			spaceBetween: 20,
			loop: false,
			loopedSlides: 5, 
			navigation: {
				nextEl: ".swiper-button-next",
				prevEl: ".swiper-button-prev"
			}
		});


		var thumbs = new Swiper(".gallery-thumbs", {
			slidesPerView: "auto",
			spaceBetween: 20,
			centeredSlides: true,
			loop: false,
			slideToClickedSlide: true
		});

		slider.controller.control = thumbs;
		thumbs.controller.control = slider;

	}


	// How it work Faqs

	jQuery(document).ready(function($) {
		// Initially show the first FAQ item
		$('.faq-item').first().addClass('active').find('.faq-answer').show();
		
		$('.faq-question').on('click', function() {
			var $faqItem = $(this).closest('.faq-item');
			var $faqAnswer = $faqItem.find('.faq-answer');
			
			// Hide all answers and remove active class from all items
			$('.faq-item').not($faqItem).removeClass('active').find('.faq-answer').slideUp();
			// Toggle the FAQ answer visibility
			$faqAnswer.slideToggle();
			$faqItem.toggleClass('active');
			// $faqItem.removeClass('active').find('.faq-answer').slideUp();
		});
	});

});
