<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Pointify_-_Listing_Directory_WordPress_Theme
 */

get_header();
?>

	<main id="primary" class="site-main">

		<div class="page_header_section" style="background-image: url(<?php echo esc_url(get_theme_mod('error_page_header_background_image', 'full')); ?>);">
			<?php pointify_page_header(); ?>
			<div class="page_breadcrumb_sec">
				<?php echo pointify_page_breadcrumb(); ?>
			</div>
		</div>

		<div class="post-pg-main-sec error-pg-section">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<section class="error-404 not-found">
							<header class="page-header">
								<h2 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'pointify' ); ?></h2>
							</header><!-- .page-header -->

							<div class="page-content">
								<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'pointify' ); ?></p>
								<?php	get_search_form();	?>
							</div><!-- .page-content -->
						</section><!-- .error-404 -->
					</div>
				</div>
			</div>
		</div>
	</main><!-- #main -->

<?php
get_footer();
