<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Local Business Directory
 */

function local_business_directory_body_classes( $local_business_directory_classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$local_business_directory_classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$local_business_directory_classes[] = 'no-sidebar'; 
	}

	return $local_business_directory_classes;
}
add_filter( 'body_class', 'local_business_directory_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function local_business_directory_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'local_business_directory_pingback_header' );