<?php
/**
 * The header for our theme
 *
 * @package Local Business Directory
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'local-business-directory' ); ?></a>

    <?php
    $local_business_directory_preloader_wrap = absint( get_theme_mod( 'local_business_directory_enable_preloader', 0 ) );
    if ( $local_business_directory_preloader_wrap === 1 ) : ?>
        <div id="loader">
            <div class="loader-container">
                <div id="preloader" class="loader-2">
                    <div class="dot"></div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php 
    $local_business_directory_has_header_image = has_header_image();
    $local_business_directory_header_image_url = $local_business_directory_has_header_image ? esc_url( get_header_image() ) : '';
    ?>
    <header id="masthead" class="site-header">
        <div class="headermain">
            <div class="header-info-box">
                <div class="top-head">
                    <div class="container" style="background-image: url('<?php echo $local_business_directory_header_image_url; ?>'); background-repeat: no-repeat; background-size: cover;">
                        <div class="flex-row">
                            <div class="middle-left">
                                <div class="nav-menu-header-left">
                                    <div class="site-branding">
                                        <?php
                                        if ( function_exists( 'the_custom_logo' ) ) {
                                            the_custom_logo();
                                        }
                                        if ( is_front_page() && is_home() ) :
                                            if ( get_theme_mod( 'local_business_directory_site_title_text', true ) ) : ?>
                                                <h1 class="site-title">
                                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
                                                </h1>
                                            <?php endif;
                                        else :
                                            if ( get_theme_mod( 'local_business_directory_site_title_text', true ) ) : ?>
                                                <p class="site-title">
                                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
                                                </p>
                                            <?php endif;
                                        endif;
                                        $local_business_directory_description = get_bloginfo( 'description', 'display' );
                                        if ( $local_business_directory_description || is_customize_preview() ) :
                                            if ( get_theme_mod( 'local_business_directory_site_tagline_text', false ) ) : ?>
                                                <p class="site-description"><?php echo esc_html( $local_business_directory_description ); ?></p>
                                            <?php endif;
                                        endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="middle-center">
                                <div class="nav-menu-header-right">
                                    <nav id="site-navigation" class="main-navigation">
                                        <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                                            <span class="screen-reader-text"><?php esc_html_e( 'Primary Menu', 'local-business-directory' ); ?></span>
                                            <i class="fas fa-bars"></i>
                                        </button>
                                        <?php
                                        wp_nav_menu( array(
                                            'theme_location' => 'menu-1',
                                            'menu_id'        => 'primary-menu',
                                        ) );
                                        ?>
                                    </nav>
                                </div>
                            </div>
                            <div class="middle-right">
                                <div class="header-button">
                                    <?php 
                                    $local_business_directory_button_link = get_theme_mod('local_business_directory_header_button_link','#');
                                    $local_business_directory_button_text = get_theme_mod('local_business_directory_header_button_text', __('ADD LISTING', 'local-business-directory'));

                                    if ( $local_business_directory_button_link || $local_business_directory_button_text ) : ?>
                                        <a href="<?php echo esc_url( $local_business_directory_button_link ); ?>">
                                            <?php echo esc_html( $local_business_directory_button_text ); ?>
                                        </a>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </header>
</div>