<div class="changelog_container">
    <?php
    $local_business_directory_changelog_entries = local_business_directory_get_changelog_from_readme();
    if (!empty($local_business_directory_changelog_entries)) :
        foreach ($local_business_directory_changelog_entries as $local_business_directory_entry) :
            $local_business_directory_version = esc_html($local_business_directory_entry[1]);
            $local_business_directory_date = esc_html($local_business_directory_entry[2]);
            $local_business_directory_details = explode("\n", trim($local_business_directory_entry[3]));
            ?>
            <div class="changelog_element">
                <span class="theme_version">
                    <strong><?php echo 'v' . $local_business_directory_version; ?></strong>
                    <?php echo 'Release date: ' . $local_business_directory_date; ?>
                    <span class="dashicons dashicons-arrow-down-alt2"></span>
                </span>

                <div class="changelog_details" style="display: none;">
                    <ul>
                        <?php foreach ($local_business_directory_details as $local_business_directory_detail) : ?>
                            <li><?php echo esc_html(trim($local_business_directory_detail, "- \t")); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php
        endforeach;
    else :
        ?>
        <p><?php esc_html_e('No changelog available.', 'local-business-directory'); ?></p>
    <?php endif; ?>
</div>