<?php
/**
 * Pagination setting
 */

// Pagination setting.
$wp_customize->add_section(
	'express_news_pagination',
	array(
		'title' => esc_html__( 'Pagination', 'express-news' ),
		'panel' => 'express_news_theme_options_panel',
	)
);

// Pagination enable setting.
$wp_customize->add_setting(
	'express_news_pagination_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_pagination_enable',
		array(
			'label'    => esc_html__( 'Enable Pagination.', 'express-news' ),
			'settings' => 'express_news_pagination_enable',
			'section'  => 'express_news_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Style.
$wp_customize->add_setting(
	'express_news_pagination_type',
	array(
		'default'           => 'numeric',
		'sanitize_callback' => 'express_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'express_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Style', 'express-news' ),
		'section'         => 'express_news_pagination',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'express-news' ),
			'numeric' => __( 'Numeric', 'express-news' ),
		),
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'express_news_pagination_enable' )->value() );
		},
	)
);
