<?php
/**
 * Space Exploration: Customizer
 *
 * @subpackage Space Exploration
 * @since 1.0
 */

 function ev_charging_station_upgrade_pro_options( $wp_customize ) {

	wp_enqueue_style('customizercustom_css', esc_url( get_template_directory_uri() ). '/assets/css/customize-controls.css');

	$wp_customize->add_section(
		'upgrade_premium',
		array(
			'title'    => esc_html__( 'About EV Charging Station', 'ev-charging-station' ),
			'priority' => 1,
		)
	);

	class EV_Charging_Station_Pro_Button_Customize_Control extends WP_Customize_Control {
		public $type = 'upgrade_premium';

		function render_content() {
			?>
			<div class="pro_info">
				<ul>
					<li><a class="upgrade-to-pro pro-btn" href="<?php echo esc_url( EV_CHARGING_STATION_PREMIUM_PAGE ); ?>" target="_blank"><i class="dashicons dashicons-cart"></i><?php esc_html_e( 'Upgrade Pro', 'ev-charging-station' ); ?> </a></li>

					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EV_CHARGING_STATION_PRO_DEMO ); ?>" target="_blank"><i class="dashicons dashicons-awards"></i><?php esc_html_e( 'Premium Demo', 'ev-charging-station' ); ?> </a></li>
					
					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EV_CHARGING_STATION_REVIEW ); ?>" target="_blank"><i class="dashicons dashicons-star-filled"></i><?php esc_html_e( 'Rate Us', 'ev-charging-station' ); ?> </a></li>
					
					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EV_CHARGING_STATION_SUPPORT ); ?>" target="_blank"><i class="dashicons dashicons-lightbulb"></i><?php esc_html_e( 'Support Forum', 'ev-charging-station' ); ?> </a></li>	
					
					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EV_CHARGING_STATION_THEME_PAGE ); ?>" target="_blank"><i class="dashicons dashicons-admin-appearance"></i><?php esc_html_e( 'Theme Page', 'ev-charging-station' ); ?> </a></li>
				
					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EV_CHARGING_STATION_THEME_DOCUMENTATION ); ?>" target="_blank"><i class="dashicons dashicons-visibility"></i><?php esc_html_e( 'Theme Documentation', 'ev-charging-station' ); ?> </a></li>
				</ul>
			</div>
			<?php
		}
	}

	$wp_customize->add_setting(
		'pro_info_buttons',
		array(
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'ev_charging_station_sanitize_text',
		)
	);

	$wp_customize->add_control(
		new EV_Charging_Station_Pro_Button_Customize_Control(
			$wp_customize,
			'pro_info_buttons',
			array(
				'section' => 'upgrade_premium',
			)
		)
	);
}
add_action( 'customize_register', 'ev_charging_station_upgrade_pro_options' );