<?php


/**
 * EV Charging Station functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @subpackage EV Charging Station
 * @since EV Charging Station 1.0
 */

if ( ! function_exists( 'ev_charging_station_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function ev_charging_station_setup() {
	load_theme_textdomain( 'ev-charging-station', get_template_directory() . '/languages' );

	/**
	 * Theme Info Page.
	 */
	require get_template_directory() . '/inc/addon.php';

	/**
	 * Customizer
	 */
	require get_template_directory() . '/inc/customizer.php';

	/**
	 * Load TGM.
	 */
	require get_template_directory() . '/inc/tgm/tgm.php';

	/**
	 * Notice.
	 */
	require_once get_template_directory() . '/inc/notice/notice.php';

}
endif;
add_action( 'after_setup_theme', 'ev_charging_station_setup' );

function ev_charging_station_block_assets(){
	wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/font-awesome/css/all.css', array(), '7.1.0' );
	wp_enqueue_style( 'animatecss', get_template_directory_uri() . '/assets/css/animate.css');
	wp_enqueue_style( 'owlcarousel-css', get_template_directory_uri() . '/assets/css/owl.carousel.css');
	wp_enqueue_style( 'ev-charging-station-style', get_template_directory_uri() . '/style.css', array(), wp_get_theme()->get( 'Version' ) );
	wp_enqueue_script('wow-script', get_template_directory_uri() . '/assets/js/wow.js', array('jquery'));
	wp_enqueue_script('owlcarousel-js', get_template_directory_uri() . '/assets/js/owl.carousel.js', array('jquery'));
	wp_enqueue_script('ev-charging-station-script', get_template_directory_uri() . '/assets/js/script.js', array('jquery'), '1.0.0', true);
	wp_style_add_data( 'ev-charging-station-style', 'rtl', 'replace' );
}

add_action('enqueue_block_assets', 'ev_charging_station_block_assets');

function ev_charging_station_setup_theme() {
	if ( ! defined( 'EV_CHARGING_STATION_PREMIUM_PAGE' ) ) {
		define('EV_CHARGING_STATION_PREMIUM_PAGE',__('https://www.theclassictemplates.com/products/charging-station-wordpress-theme','ev-charging-station'));
	}
	if ( ! defined( 'EV_CHARGING_STATION_PRO_NAME' ) ) {
		define( 'EV_CHARGING_STATION_PRO_NAME', __( 'About EV Charging Station', 'ev-charging-station' ));
	}
	if ( ! defined( 'EV_CHARGING_STATION_THEME_PAGE' ) ) {
		define('EV_CHARGING_STATION_THEME_PAGE',__('https://www.theclassictemplates.com/collections/best-wordpress-templates','ev-charging-station'));
	}
	if ( ! defined( 'EV_CHARGING_STATION_SUPPORT' ) ) {
		define('EV_CHARGING_STATION_SUPPORT',__('https://wordpress.org/support/theme/ev-charging-station/','ev-charging-station'));
	}
	if ( ! defined( 'EV_CHARGING_STATION_REVIEW' ) ) {
		define('EV_CHARGING_STATION_REVIEW',__('https://wordpress.org/support/theme/ev-charging-station/reviews/','ev-charging-station'));
	}
	if ( ! defined( 'EV_CHARGING_STATION_PRO_DEMO' ) ) {
		define('EV_CHARGING_STATION_PRO_DEMO',__('https://live.theclassictemplates.com/ev-charging-station-pro/','ev-charging-station'));
	}
	if ( ! defined( 'EV_CHARGING_STATION_THEME_DOCUMENTATION' ) ) {
		define('EV_CHARGING_STATION_THEME_DOCUMENTATION',__('https://live.theclassictemplates.com/demo/docs/ev-charging-station-free/','ev-charging-station'));
	}
	if ( ! defined( 'EV_CHARGING_STATION_BUNDLE_PAGE' ) ) {
		define('EV_CHARGING_STATION_BUNDLE_PAGE',__('https://www.theclassictemplates.com/products/wordpress-theme-bundle','ev-charging-station'));
	}
}
add_action('after_setup_theme', 'ev_charging_station_setup_theme');

function ev_charging_station_enqueue_admin_script($hook) {
    // Enqueue admin JS for notices
    wp_enqueue_script('ev-charging-station-welcome-notice', get_template_directory_uri() . '/inc/notice/notice.js', array('jquery'), '', true);
    
    // Localize script to pass data to JavaScript
    wp_localize_script('ev-charging-station-welcome-notice', 'ev_charging_station_localize', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('ev_charging_station_welcome_nonce'),
        'dismiss_nonce' => wp_create_nonce('ev_charging_station_welcome_nonce'), 
        'redirect_url' => admin_url('themes.php?page=ev-charging-station')
    ));
}
add_action('admin_enqueue_scripts', 'ev_charging_station_enqueue_admin_script');

add_filter( 'woocommerce_enable_setup_wizard', '__return_false' );