jQuery(document).ready(function ($) {
    // Attach click event to the dismiss button
    $(document).on('click', '.welcome-notice button.notice-dismiss', function () {
        // Dismiss the notice via AJAX
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
                action: 'classified_listings_dismissed_notice',
            },
            success: function () {
                // Remove the notice on success
                $('.notice[data-notice="example"]').remove();
            }
        });
    });
});


// Plugin – AI Content Writer plugin activation
document.addEventListener('DOMContentLoaded', function () {
    const classified_listings_button = document.getElementById('install-activate-button');

    if (!classified_listings_button) return;

    classified_listings_button.addEventListener('click', function (e) {
        e.preventDefault();

        const classified_listings_redirectUrl = classified_listings_button.getAttribute('data-redirect');

        // Step 1: Check if plugin is already active
        const classified_listings_checkData = new FormData();
        classified_listings_checkData.append('action', 'check_plugin_activation');

        fetch(installPluginData.ajaxurl, {
            method: 'POST',
            body: classified_listings_checkData,
        })
        .then(res => res.json())
        .then(res => {
            if (res.success && res.data.active) {
                // Plugin is already active → just redirect
                window.location.href = classified_listings_redirectUrl;
            } else {
                // Not active → proceed with install + activate
                classified_listings_button.textContent = 'Installing & Activating...';

                const classified_listings_installData = new FormData();
                classified_listings_installData.append('action', 'install_and_activate_required_plugin');
                classified_listings_installData.append('_ajax_nonce', installPluginData.nonce);

                fetch(installPluginData.ajaxurl, {
                    method: 'POST',
                    body: classified_listings_installData,
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        window.location.href = classified_listings_redirectUrl;
                    } else {
                        alert('Activation error: ' + (res.data?.message || 'Unknown error'));
                        classified_listings_button.textContent = 'Try Again';
                    }
                })
                .catch(error => {
                    alert('Request failed: ' + error.message);
                    classified_listings_button.textContent = 'Try Again';
                });
            }
        })
        .catch(error => {
            alert('Check request failed: ' + error.message);
        });
    });
});
