<?php
// Add Getstart admin notice
function classified_listings_admin_notice() { 
    global $pagenow;
    $classified_listings_theme_args      = wp_get_theme();
    $classified_listings_meta            = get_option( 'classified_listings_admin_notice' );
    $classified_listings_name            = $classified_listings_theme_args->__get( 'Name' );
    $classified_listings_current_screen  = get_current_screen();

    if( !$classified_listings_meta ){
        if( is_network_admin() ){
            return;
        }

        if( ! current_user_can( 'manage_options' ) ){
            return;
        } if($classified_listings_current_screen->base != 'appearance_page_classified-listings-guide-page' && $classified_listings_current_screen->id != 'appearance_page_classified-listings-info' && $classified_listings_current_screen->base != 'toplevel_page_cretats-theme-showcase' ) { ?>
        <div class="notice notice-success is-dismissible welcome-notice">
            <div class="notice-row">
                <div class="notice-text">
                    <p class="welcome-text1"><?php esc_html_e( '🎉 Welcome to VW Themes,', 'classified-listings' ); ?></p>
                    <p class="welcome-text2"><?php esc_html_e( 'You are now using the Classified Listings, a beautifully designed theme to kickstart your website.', 'classified-listings' ); ?></p>
                    <p class="welcome-text3"><?php esc_html_e( 'To help you get started quickly, use the options below:', 'classified-listings' ); ?></p>

                    <span class="import-btn">
                        <a href="javascript:void(0);" id="install-activate-button" class="button admin-button info-button">
                           <?php echo __('GET STARTED', 'classified-listings'); ?>
                        </a>
                        <script type="text/javascript">
                            document.getElementById('install-activate-button').addEventListener('click', function () {
                                const classified_listings_button = this;
                                const classified_listings_redirectUrl = '<?php echo esc_url(admin_url("themes.php?page=classified-listings-info")); ?>';
                                // First, check if plugin is already active
                                jQuery.post(ajaxurl, { action: 'check_plugin_activation' }, function (response) {
                                    if (response.success && response.data.active) {
                                        // Plugin already active — just redirect
                                        window.location.href = classified_listings_redirectUrl;
                                    } else {
                                        // Show Installing & Activating only if not already active
                                        classified_listings_button.textContent = 'Installing & Activating...';

                                        jQuery.post(ajaxurl, {
                                            action: 'install_and_activate_required_plugin',
                                            nonce: '<?php echo wp_create_nonce("install_activate_nonce"); ?>'
                                        }, function (response) {
                                            if (response.success) {
                                                window.location.href = classified_listings_redirectUrl;
                                            } else {
                                                alert('Failed to activate the plugin.');
                                                classified_listings_button.textContent = 'Try Again';
                                            }
                                        });
                                    }
                                });
                            });
                        </script>
                    </span>

                    <span class="demo-btn">
                        <a href="https://www.vwthemes.net/classified-listings/" class="button button-primary" target="_blank">
                            <?php esc_html_e( 'VIEW DEMO', 'classified-listings' ); ?>
                        </a>
                    </span>

                    <span class="upgrade-btn">
                        <a href="https://www.vwthemes.com/products/classified-wordpress-theme" class="button button-primary" target="_blank">
                            <?php esc_html_e( 'UPGRADE TO PRO', 'classified-listings' ); ?>
                        </a>
                    </span>

                    <span class="bundle-btn">
                        <a href="https://www.vwthemes.com/products/wp-theme-bundle" class="button button-primary" target="_blank">
                            <?php esc_html_e( 'BUNDLE OF 400+ THEMES', 'classified-listings' ); ?>
                        </a>
                    </span>
                </div>

                <div class="notice-img1">
                    <img src="<?php echo esc_url( get_template_directory_uri() . '/images/arrow-notice.png' ); ?>" width="180" alt="<?php esc_attr_e( 'Classified Listings', 'classified-listings' ); ?>" />
                </div>

                <div class="notice-img2">
                    <img src="<?php echo esc_url( get_template_directory_uri() . '/images/bundle-notice.png' ); ?>" width="180" alt="<?php esc_attr_e( 'Classified Listings', 'classified-listings' ); ?>" />
                </div>
            </div>
        </div>
        <?php
    }
}
}

add_action( 'admin_notices', 'classified_listings_admin_notice' );

if( ! function_exists( 'classified_listings_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
*/
function classified_listings_update_admin_notice(){
    if ( isset( $_GET['classified_listings_admin_notice'] ) && $_GET['classified_listings_admin_notice'] = '1' ) {
        update_option( 'classified_listings_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'classified_listings_update_admin_notice' );

//After Switch theme function
add_action('after_switch_theme', 'classified_listings_getstart_setup_options');
function classified_listings_getstart_setup_options () {
    update_option('classified_listings_admin_notice', FALSE );
}


