<?php

function car_rental_hub_remove_customize_register() {
    global $wp_customize;
   
    $wp_customize->remove_section( 'automobile_hub_social_media' );
    $wp_customize->remove_setting( 'automobile_hub_search_icon' );
    $wp_customize->remove_control( 'automobile_hub_search_icon' );
    $wp_customize->remove_setting( 'automobile_hub_cart_option' );
    $wp_customize->remove_control( 'automobile_hub_cart_option' );
    $wp_customize->remove_setting( 'automobile_hub_cart_icon' );
    $wp_customize->remove_control( 'automobile_hub_cart_icon' );
    $wp_customize->remove_setting( 'automobile_hub_slider_icon' );
    $wp_customize->remove_control( 'automobile_hub_slider_icon' );
    $wp_customize->remove_setting( 'automobile_hub_about_icon' );
    $wp_customize->remove_control( 'automobile_hub_about_icon' );
    $wp_customize->remove_setting( 'automobile_hub_slider_text' );
    $wp_customize->remove_control( 'automobile_hub_slider_text' );

    $wp_customize->remove_setting( 'automobile_hub_tp_color_option_link' );
    $wp_customize->remove_control( 'automobile_hub_tp_color_option_link' );

}
add_action( 'customize_register', 'car_rental_hub_remove_customize_register', 11 );

if ( ! defined( 'CAR_RENTAL_HUB_TEXT' ) ) {
    define( 'CAR_RENTAL_HUB_TEXT', __( 'Car Rental Hub Pro','car-rental-hub' ));
}
if ( ! defined( 'CAR_RENTAL_HUB_BUY_TEXT' ) ) {
    define( 'CAR_RENTAL_HUB_BUY_TEXT', __( 'Upgrade Pro','car-rental-hub' ));
}


add_action( 'customize_register', function( $manager ) {

// Load custom sections.
load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

    $manager->register_section_type( Automobile_Hub_Button::class );

    $manager->add_section(
        new Automobile_Hub_Button( $manager, 'automobile_hub_pro', [
            'title'       => esc_html( CAR_RENTAL_HUB_TEXT,'car-rental-hub' ),
            'priority'    => 0,
            'button_text' => __( 'GET PREMIUM', 'car-rental-hub' ),
            'button_url'  => esc_url( AUTOMOBILE_HUB_PRO_THEME_URL )
        ] )
    );

} );

function car_rental_hub_customize_register( $wp_customize ) {

	// Pro Version
    class car_rental_hub_Customize_Pro_Version extends WP_Customize_Control {
        public $type = 'pro_options';

        public function render_content() {
            echo '<span>Unlock Premium <strong>'. esc_html( $this->label ) .'</strong>? </span>';
            echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<span class="dashicons dashicons-info"></span>';
                echo '<strong> '. esc_html( CAR_RENTAL_HUB_BUY_TEXT,'car-rental-hub' ) .'<strong></a>';
            echo '</a>';
        }
    }

    // Custom Controls
    function car_rental_hub_sanitize_custom_control( $input ) {
        return $input;
    }

	// Register the custom control type.
	$wp_customize->register_control_type( 'Car_Rental_Hub_Toggle_Control' );

	//contact section
	$wp_customize->add_setting('car_rental_hub_location_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('car_rental_hub_location_text',array(
		'label'	=> __('Add Location Text','car-rental-hub'),
		'section'	=> 'automobile_hub_topbar',
		'type'		=> 'text'
	));
    $wp_customize->selective_refresh->add_partial( 'car_rental_hub_location_text', array(
		'selector' => '#contact-info i',
		'render_callback' => 'automobile_hub_customize_partial_car_rental_hub_location_text',
	 ) );
	$wp_customize->add_setting('car_rental_hub_location',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('car_rental_hub_location',array(
		'label'	=> __('Add Location','car-rental-hub'),
		'section'	=> 'automobile_hub_topbar',
		'type'		=> 'text'
	));

	//Featured car section
	//Featured Car Section
	$wp_customize->add_section( 'car_rental_hub_featured_car_section' , array(
    	'title'      => __( 'Best Car Deals Settings', 'car-rental-hub' ),
		'panel' => 'automobile_hub_panel_id',
		'priority' => 4,
	) );
    $wp_customize->add_setting( 'car_rental_hub_featured_car_show_hide', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'automobile_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new car_rental_hub_Toggle_Control ( $wp_customize, 'car_rental_hub_featured_car_show_hide', array(
		'label'       => esc_html__( 'Show / Hide section', 'car-rental-hub' ),
		'section'     => 'car_rental_hub_featured_car_section',
		'type'        => 'toggle',
		'settings'    => 'car_rental_hub_featured_car_show_hide',
	) ) );

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$offer_cat[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$offer_cat[$category->slug] = $category->name;
	}
	$wp_customize->add_setting('car_rental_hub_featured_car_section_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'automobile_hub_sanitize_choices',
	));
	$wp_customize->add_control('car_rental_hub_featured_car_section_category',array(
		'type'    => 'select',
		'choices' => $offer_cat,
		'label' => __('Select Category','car-rental-hub'),
		'section' => 'car_rental_hub_featured_car_section',
	));

	$wp_customize->add_setting('car_rental_hub_num_posts', array(
	    'default' => 3,
	    'sanitize_callback' => 'absint',
	));
	$wp_customize->add_control('car_rental_hub_num_posts', array(
	    'label' => __('Number of Featured Cars', 'car-rental-hub'),
	    'section' => 'car_rental_hub_featured_car_section',
	    'type' => 'number',
	    'input_attrs' => array(
	        'min' => 1,
	        'step' => 1,
	    ),
	));

	// Get the number of posts to display from the customizer setting
	$car_rental_hub_num_posts = get_theme_mod('car_rental_hub_num_posts', 3); // Default to 3 if no setting is found

	// Loop through the number of posts and create settings for each
	for ($i = 1; $i <= $car_rental_hub_num_posts; $i++) {

	    $wp_customize->add_setting('car_rental_hub_body_type' . $i, array(
	        'default' => '',
	        'sanitize_callback' => 'sanitize_text_field',
	    ));
	    $wp_customize->add_control('car_rental_hub_body_type' . $i, array(
	        'label' => sprintf(__('Body Type %d', 'car-rental-hub'), $i),
	        'section' => 'car_rental_hub_featured_car_section',
	        'type' => 'text',
	    ));

	    $wp_customize->add_setting('car_rental_hub_model_year' . $i, array(
	        'default' => '',
	        'sanitize_callback' => 'sanitize_text_field',
	    ));
	    $wp_customize->add_control('car_rental_hub_model_year' . $i, array(
	        'label' => sprintf(__('Model Year %d', 'car-rental-hub'), $i),
	        'section' => 'car_rental_hub_featured_car_section',
	        'type' => 'text',
	    ));

	    $wp_customize->add_setting('car_rental_hub_mileage' . $i, array(
	        'default' => '',
	        'sanitize_callback' => 'sanitize_text_field',
	    ));
	    $wp_customize->add_control('car_rental_hub_mileage' . $i, array(
	        'label' => sprintf(__('Mileage %d', 'car-rental-hub'), $i),
	        'section' => 'car_rental_hub_featured_car_section',
	        'type' => 'text',
	    ));

	    $wp_customize->add_setting('car_rental_hub_compare_price' . $i, array(
	        'default' => '',
	        'sanitize_callback' => 'sanitize_text_field',
	    ));
	    $wp_customize->add_control('car_rental_hub_compare_price' . $i, array(
	        'label' => sprintf(__('Compare Price %d', 'car-rental-hub'), $i),
	        'section' => 'car_rental_hub_featured_car_section',
	        'type' => 'text',
	    ));
	}

	// Pro Version
    $wp_customize->add_setting( 'car_rental_hub_services_pro_version_logo', array(
        'sanitize_callback' => 'car_rental_hub_sanitize_custom_control'
    ));
    $wp_customize->add_control( new car_rental_hub_Customize_Pro_Version ( $wp_customize,'car_rental_hub_services_pro_version_logo', array(
        'section'     => 'car_rental_hub_featured_car_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'car-rental-hub' ),
        'description' => esc_url( AUTOMOBILE_HUB_PRO_THEME_URL ),
        'priority'    => 10,
    )));

}
add_action( 'customize_register', 'car_rental_hub_customize_register' );
