<?php
if ( ! class_exists( 'Business_Directory_Elementor_Plugin_Activation_WPElemento_Importer' ) ) {
    /**
     * Business_Directory_Elementor_Plugin_Activation_WPElemento_Importer initial setup
     *
     * @since 1.6.2
     */

    class Business_Directory_Elementor_Plugin_Activation_WPElemento_Importer {

        private static $business_directory_elementor_instance;
        public $business_directory_elementor_action_count;
        public $business_directory_elementor_recommended_actions;

        /** Initiator **/
        public static function get_instance() {
          if ( ! isset( self::$business_directory_elementor_instance) ) {
            self::$business_directory_elementor_instance = new self();
          }
          return self::$business_directory_elementor_instance;
        }

        /*  Constructor */
        public function __construct() {

            add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

            // ---------- wpelementoimpoter Plugin Activation -------
            add_filter( 'business_directory_elementor_recommended_plugins', array($this, 'business_directory_elementor_recommended_elemento_importer_plugins_array') );

            $business_directory_elementor_actions                   = $this->business_directory_elementor_get_recommended_actions();
            $this->business_directory_elementor_action_count        = $business_directory_elementor_actions['count'];
            $this->business_directory_elementor_recommended_actions = $business_directory_elementor_actions['actions'];

            add_action( 'wp_ajax_create_pattern_setup_builder', array( $this, 'create_pattern_setup_builder' ) );
        }

        public function business_directory_elementor_recommended_elemento_importer_plugins_array($business_directory_elementor_plugins){
            $business_directory_elementor_plugins[] = array(
                    'name'     => esc_html__('WPElemento Importer', 'business-directory-elementor'),
                    'slug'     =>  'wpelemento-importer',
                    'function' => 'WPElemento_Importer_ThemeWhizzie',
                    'desc'     => esc_html__('We highly recommend installing the WPElemento Importer plugin for importing the demo content with Elementor.', 'business-directory-elementor'),               
            );
            return $business_directory_elementor_plugins;
        }

        public function enqueue_scripts() {
            wp_enqueue_script('updates');      
            wp_register_script( 'business-directory-elementor-plugin-activation-script', esc_url(get_template_directory_uri()) . '/includes/getstart/js/plugin-activation.js', array('jquery') );
            wp_localize_script('business-directory-elementor-plugin-activation-script', 'business_directory_elementor_plugin_activate_plugin',
                array(
                    'installing' => esc_html__('Installing', 'business-directory-elementor'),
                    'activating' => esc_html__('Activating', 'business-directory-elementor'),
                    'error' => esc_html__('Error', 'business-directory-elementor'),
                    'ajax_url' => esc_url(admin_url('admin-ajax.php')),
                    'wpelementoimpoter_admin_url' => esc_url(admin_url('admin.php?page=wpelemento-importer-tgmpa-install-plugins')),
                    'addon_admin_url' => esc_url(admin_url('admin.php?page=wpelementoimporter-wizard'))
                )
            );
            wp_enqueue_script( 'business-directory-elementor-plugin-activation-script' );

        }

        // --------- Plugin Actions ---------
        public function business_directory_elementor_get_recommended_actions() {

            $business_directory_elementor_act_count  = 0;
            $business_directory_elementor_actions_todo = get_option( 'recommending_actions', array());

            $business_directory_elementor_plugins = $this->business_directory_elementor_get_recommended_plugins();

            if ($business_directory_elementor_plugins) {
                foreach ($business_directory_elementor_plugins as $business_directory_elementor_key => $business_directory_elementor_plugin) {
                    $business_directory_elementor_action = array();
                    if (!isset($business_directory_elementor_plugin['slug'])) {
                        continue;
                    }

                    $business_directory_elementor_action['id']   = 'install_' . $business_directory_elementor_plugin['slug'];
                    $business_directory_elementor_action['desc'] = '';
                    if (isset($business_directory_elementor_plugin['desc'])) {
                        $business_directory_elementor_action['desc'] = $business_directory_elementor_plugin['desc'];
                    }

                    $business_directory_elementor_action['name'] = '';
                    if (isset($business_directory_elementor_plugin['name'])) {
                        $business_directory_elementor_action['title'] = $business_directory_elementor_plugin['name'];
                    }

                    $business_directory_elementor_link_and_is_done  = $this->business_directory_elementor_get_plugin_buttion($business_directory_elementor_plugin['slug'], $business_directory_elementor_plugin['name'], $business_directory_elementor_plugin['function']);
                    $business_directory_elementor_action['link']    = $business_directory_elementor_link_and_is_done['button'];
                    $business_directory_elementor_action['is_done'] = $business_directory_elementor_link_and_is_done['done'];
                    if (!$business_directory_elementor_action['is_done'] && (!isset($business_directory_elementor_actions_todo[$business_directory_elementor_action['id']]) || !$business_directory_elementor_actions_todo[$business_directory_elementor_action['id']])) {
                        $business_directory_elementor_act_count++;
                    }
                    $business_directory_elementor_recommended_actions[] = $business_directory_elementor_action;
                    $business_directory_elementor_actions_todo[]        = array('id' => $business_directory_elementor_action['id'], 'watch' => true);
                }
                return array('count' => $business_directory_elementor_act_count, 'actions' => $business_directory_elementor_recommended_actions);
            }

        }

        public function business_directory_elementor_get_recommended_plugins() {

            $business_directory_elementor_plugins = apply_filters('business_directory_elementor_recommended_plugins', array());
            return $business_directory_elementor_plugins;
        }

        public function business_directory_elementor_get_plugin_buttion($slug, $name, $function) {
                $business_directory_elementor_is_done      = false;
                $business_directory_elementor_button_html  = '';
                $business_directory_elementor_is_installed = $this->is_plugin_installed($slug);
                $business_directory_elementor_plugin_path  = $this->get_plugin_basename_from_slug($slug);
                $business_directory_elementor_is_activeted = (class_exists($function)) ? true : false;
                if (!$business_directory_elementor_is_installed) {
                    $business_directory_elementor_plugin_install_url = add_query_arg(
                        array(
                            'action' => 'install-plugin',
                            'plugin' => $slug,
                        ),
                        self_admin_url('update.php')
                    );
                    $business_directory_elementor_plugin_install_url = wp_nonce_url($business_directory_elementor_plugin_install_url, 'install-plugin_' . esc_attr($slug));
                    $business_directory_elementor_button_html        = sprintf('<a class="business-directory-elementor-plugin-install install-now button-secondary button" data-slug="%1$s" href="%2$s" aria-label="%3$s" data-name="%4$s">%5$s</a>',
                        esc_attr($slug),
                        esc_url($business_directory_elementor_plugin_install_url),
                        sprintf(esc_html__('Install %s Now', 'business-directory-elementor'), esc_html($name)),
                        esc_html($name),
                        esc_html__('Install & Activate', 'business-directory-elementor')
                    );
                } elseif ($business_directory_elementor_is_installed && !$business_directory_elementor_is_activeted) {

                    $business_directory_elementor_plugin_activate_link = add_query_arg(
                        array(
                            'action'        => 'activate',
                            'plugin'        => rawurlencode($business_directory_elementor_plugin_path),
                            'plugin_status' => 'all',
                            'paged'         => '1',
                            '_wpnonce'      => wp_create_nonce('activate-plugin_' . $business_directory_elementor_plugin_path),
                        ), self_admin_url('plugins.php')
                    );

                    $business_directory_elementor_button_html = sprintf('<a class="business-directory-elementor-plugin-activate activate-now button-primary button" data-slug="%1$s" href="%2$s" aria-label="%3$s" data-name="%4$s">%5$s</a>',
                        esc_attr($slug),
                        esc_url($business_directory_elementor_plugin_activate_link),
                        sprintf(esc_html__('Activate %s Now', 'business-directory-elementor'), esc_html($name)),
                        esc_html($name),
                        esc_html__('Activate', 'business-directory-elementor')
                    );
                } elseif ($business_directory_elementor_is_activeted) {
                    $business_directory_elementor_button_html = sprintf('<div class="action-link button disabled"><span class="dashicons dashicons-yes"></span> %s</div>', esc_html__('Active', 'business-directory-elementor'));
                    $business_directory_elementor_is_done     = true;
                }

                return array('done' => $business_directory_elementor_is_done, 'button' => $business_directory_elementor_button_html);
            }
        public function is_plugin_installed($slug) {
            $business_directory_elementor_installed_plugins = $this->get_installed_plugins(); // Retrieve a list of all installed plugins (WP cached).
            $business_directory_elementor_file_path         = $this->get_plugin_basename_from_slug($slug);
            return (!empty($business_directory_elementor_installed_plugins[$business_directory_elementor_file_path]));
        }
        public function get_plugin_basename_from_slug($slug) {
            $business_directory_elementor_keys = array_keys($this->get_installed_plugins());
            foreach ($business_directory_elementor_keys as $business_directory_elementor_key) {
                if (preg_match('|^' . $slug . '/|', $business_directory_elementor_key)) {
                    return $business_directory_elementor_key;
                }
            }
            return $slug;
        }

        public function get_installed_plugins() {

            if (!function_exists('get_plugins')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }

            return get_plugins();
        }
        public function create_pattern_setup_builder() {

            $edit_page = admin_url().'post-new.php?post_type=page&create_pattern=true';
            echo json_encode(['page_id'=>'','edit_page_url'=> $edit_page ]);

            exit;
        }

    }
}
/**
 * Kicking this off by calling 'get_instance()' method
 */
Business_Directory_Elementor_Plugin_Activation_WPElemento_Importer::get_instance();