<?php

function get_page_id_by_title($business_directory_elementor_pagename){
  $business_directory_elementor_args = array(
 'post_type' => 'page',
 'posts_per_page' => 1,
 'title' => $business_directory_elementor_pagename
  );
  $business_directory_elementor_query = new WP_Query( $business_directory_elementor_args );    $business_directory_elementor_page_id = '1';
 if (isset($business_directory_elementor_query->post->ID)) {
      $business_directory_elementor_page_id = $business_directory_elementor_query->post->ID;
  } return $business_directory_elementor_page_id;
}
//about theme info
add_action( 'admin_menu', 'business_directory_elementor_gettingstarted' );
function business_directory_elementor_gettingstarted() {
	add_theme_page( esc_html__('Business Directory Elementor', 'business-directory-elementor'), esc_html__('Business Directory Elementor', 'business-directory-elementor'), 'edit_theme_options', 'business_directory_elementor_about', 'business_directory_elementor_mostrar_guide');
}

// Add a Custom CSS file to WP Admin Area
function business_directory_elementor_admin_theme_style() {
	wp_enqueue_style('business-directory-elementor-custom-admin-style', esc_url(get_template_directory_uri()) . '/includes/getstart/getstart.css');
	wp_enqueue_script('business-directory-elementor-tabs', esc_url(get_template_directory_uri()) . '/includes/getstart/js/tab.js');
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri().'/assets/css/fontawesome-all.css' );

	// Admin notice code START
	wp_register_script('business-directory-elementor-notice', esc_url(get_template_directory_uri()) . '/includes/getstart/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('business-directory-elementor-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'business_directory_elementor_admin_theme_style');

// Changelog
if ( ! defined( 'BUSINESS_DIRECTORY_ELEMENTOR_CHANGELOG_URL' ) ) {
    define( 'BUSINESS_DIRECTORY_ELEMENTOR_CHANGELOG_URL', get_template_directory() . '/readme.txt' );
}

function business_directory_elementor_changelog_screen() {
	global $wp_filesystem;
	$business_directory_elementor_changelog_file = apply_filters( 'business_directory_elementor_changelog_file', BUSINESS_DIRECTORY_ELEMENTOR_CHANGELOG_URL );

	if ( $business_directory_elementor_changelog_file && is_readable( $business_directory_elementor_changelog_file ) ) {
		WP_Filesystem();
		$business_directory_elementor_changelog = $wp_filesystem->get_contents( $business_directory_elementor_changelog_file );
		$business_directory_elementor_changelog_list = business_directory_elementor_parse_changelog( $business_directory_elementor_changelog );

		
		echo '<div id="business-directory-elementor-changelog-container">';
		echo wp_kses_post( $business_directory_elementor_changelog_list );
		echo '</div>';
		echo '<button id="business-directory-elementor-load-more" class="button button-primary" style="margin-top:15px;">Load More</button>';
	}
}

function business_directory_elementor_parse_changelog( $business_directory_elementor_content ) {
	$business_directory_elementor_content = explode ( '== ', $business_directory_elementor_content );
	$business_directory_elementor_changelog_isolated = '';

	foreach ( $business_directory_elementor_content as $key => $business_directory_elementor_value ) {
		if ( strpos( $business_directory_elementor_value, 'Changelog ==' ) === 0 ) {
	    	$business_directory_elementor_changelog_isolated = str_replace( 'Changelog ==', '', $business_directory_elementor_value );
	    }
	}

	$business_directory_elementor_changelog_array = explode( '= ', $business_directory_elementor_changelog_isolated );
	unset( $business_directory_elementor_changelog_array[0] );

	$business_directory_elementor_changelog = '<div class="changelog">';
	foreach ( $business_directory_elementor_changelog_array as $business_directory_elementor_value ) {
		$business_directory_elementor_value = preg_replace( '/\n+/', '</span><span>', $business_directory_elementor_value );
		$business_directory_elementor_value = '<div class="block-changelog"><span class="heading">= ' . $business_directory_elementor_value . '</span></div>';
		$business_directory_elementor_changelog .= str_replace( '<span></span>', '', $business_directory_elementor_value );
	}
	$business_directory_elementor_changelog .= '</div>';

	return wp_kses_post( $business_directory_elementor_changelog );
}

//guidline for about theme
function business_directory_elementor_mostrar_guide() { 
	//custom function about theme customizer
	$business_directory_elementor_return = add_query_arg( array()) ;
	$business_directory_elementor_theme = wp_get_theme( 'business-directory-elementor' );
	?>
<div class="container-getstarted">
		<div class="inner-side-content1">
			<div class="tab-outer-box">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/includes/getstart/images/sticky-header-logo.png" />
			</div>
		    <div class="coupon-container-box-left">
			    <div class="iner-sidebar-pro-btn">
				    <span class="premium-btn"><a href="<?php echo esc_url( BUSINESS_DIRECTORY_ELEMENTOR_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Premium Theme', 'business-directory-elementor'); ?></a>
				    </span>
			    </div>
		    </div>
        </div>					
   <div class="top-head">
	    <div class="top-title">
		     <h2><?php esc_html_e( 'Business Directory Elementor', 'business-directory-elementor' ); ?></h2>
		     <h4><?php esc_html_e( 'Welcome to WP Elemento Theme!', 'business-directory-elementor' ); ?></h4>
		     <p><?php esc_html_e( 'Click on the quick start button to import the demo.', 'business-directory-elementor' ); ?></p>
			    <div class="iner-sidebar-pro-btn">
					<?php if(!class_exists('WPElemento_Importer_ThemeWhizzie')){
						$business_directory_elementor_plugin_ins = Business_Directory_Elementor_Plugin_Activation_WPElemento_Importer::get_instance();
						$business_directory_elementor_actions = $business_directory_elementor_plugin_ins->business_directory_elementor_recommended_actions;
					?>
					<div class="business-directory-elementor-recommended-plugins ">
						<div class="business-directory-elementor-action-list">
							<?php if ($business_directory_elementor_actions): foreach ($business_directory_elementor_actions as $business_directory_elementor_key => $business_directory_elementor_actionValue): ?>
									<div class="business-directory-elementor-action" id="<?php echo esc_attr($business_directory_elementor_actionValue['id']);?>">
										<div class="action-inner plugin-activation-redirect">
											<?php echo wp_kses_post($business_directory_elementor_actionValue['link']); ?>
										</div>
									</div>
								<?php endforeach;
							endif; ?>
						</div>
					</div>
				   <?php }else{ ?>
					<span class="quick-btn">
				    <?php if (isset($_GET['imported']) && $_GET['imported'] == 'true'): ?>
                        <a href="<?php echo esc_url( site_url() ); ?>" target="_blank"><?php esc_html_e('Visit Site', 'business-directory-elementor'); ?></a>
						<?php
						$business_directory_elementor_page_id = get_page_id_by_title('Home');
						?>
						<a href="<?php echo esc_url( admin_url('post.php?post=' . $business_directory_elementor_page_id . '&action=elementor') ); ?>" 
							target="_blank" class="elementor-edit-btn"><?php esc_html_e('Edit With Elementor', 'business-directory-elementor'); ?>
						</a>
                    <?php else: ?>
                        <a href="<?php echo esc_url( admin_url('admin.php?page=wpelementoimporter-wizard') ); ?>"><?php esc_html_e('Quick Start', 'business-directory-elementor'); ?></a>
                    <?php endif; ?>
					<?php } ?>
				   </span>
				    <span class="premium-btn"><a href="<?php echo esc_url( BUSINESS_DIRECTORY_ELEMENTOR_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Premium', 'business-directory-elementor'); ?></a>
				    </span>
				    <span class="demo-btn"><a href="<?php echo esc_url( BUSINESS_DIRECTORY_ELEMENTOR_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'business-directory-elementor'); ?></a>
				    </span>
				    <span class="doc-btn"><a href="<?php echo esc_url( BUSINESS_DIRECTORY_ELEMENTOR_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Theme Bundle at $79', 'business-directory-elementor'); ?></a>
				    </span>
			    </div>
            </div>			
		<div class="inner-side-content">
			<div class="tab-outer-box">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png" />
			</div>
			<div class="top-right">
			  <span class="version"><?php esc_html_e( 'Version', 'business-directory-elementor' ); ?>: <?php echo esc_html($business_directory_elementor_theme['Version']);?></span>
		    </div>
		</div>
    </div>
    <div class="inner-cont">
	    <div class="tab-outer-box1">
		   <div class="tab-inner-box">
			   <div class= "bundle-box">
				    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/includes/getstart/images/bundle.png"/>
				    <h1><?php esc_html_e('ELEMENTOR WORDPRESS THEME BUNDLE', 'business-directory-elementor'); ?></h1>
			     <div>
				    <p class="product-price"><?php esc_html_e('Price:', 'business-directory-elementor'); ?>
                        <span class="regular-price"><?php esc_html_e('$1,999.00', 'business-directory-elementor'); ?></span>
                        <span class="sale-price"><?php esc_html_e('$79.00', 'business-directory-elementor'); ?></span>
                    </p>
					<p><?php esc_html_e('The Elementor WordPress Theme Bundle offers a stunning collection of 76+ Premium Elementor Themes', 'business-directory-elementor'); ?></p>
                 </div>
				</div> 
			    <div class="offer-box"> 
				    <div class="offer1-box">
                       <span class="off-text1"><a href="<?php echo esc_url( BUSINESS_DIRECTORY_ELEMENTOR_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Buy Bundle at 20% Discount', 'business-directory-elementor'); ?></a></span>
				    </div> 
		        </div>
			</div>	
		</div>	
		<div class="tab-outer-box2">
			<div class="tab-outer-box-2-1">
			  <h3><?php esc_html_e( 'Customizer Setting', 'business-directory-elementor' ); ?></h3>
			  <div class="lite-theme-inner">
				<div>
					<h3><?php esc_html_e('Theme Customizer', 'business-directory-elementor'); ?></h3>
					<p><?php esc_html_e('To begin customizing your website, start by clicking "Customize".', 'business-directory-elementor'); ?></p>
					<div class="info-link">
					   <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Open customizer', 'business-directory-elementor'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Help Docs', 'business-directory-elementor'); ?></h3>
					<p><?php esc_html_e('The complete procedure to configure and manage a WordPress Website from the beginning is shown in this documentation .', 'business-directory-elementor'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( BUSINESS_DIRECTORY_ELEMENTOR_FREE_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'business-directory-elementor'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Need Support?', 'business-directory-elementor'); ?></h3>
					<p><?php esc_html_e('Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme.', 'business-directory-elementor'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( BUSINESS_DIRECTORY_ELEMENTOR_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'business-directory-elementor'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Reviews & Testimonials', 'business-directory-elementor'); ?></h3>
					<p> <?php esc_html_e('All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'business-directory-elementor'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( BUSINESS_DIRECTORY_ELEMENTOR_REVIEW ); ?>" target="_blank"><?php esc_html_e('Review', 'business-directory-elementor'); ?></a>
					</div>
				</div>
            </div>	
		</div>
			<div class="tab-outer-box-2-2">
			  <h3><?php esc_html_e( 'Link to customizer', 'business-directory-elementor' ); ?></h3>
				<div class="first-row">
					<div class="row-box">
						<div class="row-box1">
							<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your Website logo','business-directory-elementor'); ?></a>
						</div>
						<div class="row-box2">
							<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Edit Your Menus','business-directory-elementor'); ?></a>
						</div>
					</div>
							
					<div class="row-box">
						<div class="row-box1">
							<span class="dashicons dashicons-align-center"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=header_image') ); ?>" target="_blank"><?php esc_html_e('Add Header Image','business-directory-elementor'); ?></a>
						</div>
						<div class="row-box2">
							<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Add Footer Widget','business-directory-elementor'); ?></a>
						</div>
					</div>
				</div>
            </div>	
			<div class="tab-outer-box-2-3">
				<h3><?php esc_html_e( 'Change log', 'business-directory-elementor' ); ?></h3>	
		     <?php business_directory_elementor_changelog_screen(); ?>
          </div>	
        </div>
    </div>
</div>	
<?php } ?>