<?php
/**
 * Template part for displaying the featured car section
 *
 * @package Auto Dealer Lite
 * @subpackage auto_dealer_lite
 */
?>

<?php
$auto_dealer_lite_static_image = get_template_directory_uri() . '/assets/images/sliderimage.png';
$show_featured_car = get_theme_mod('auto_dealer_lite_featured_car_show_hide', true);

if ($show_featured_car) : 
?>
<section id="featured-car" class="py-5 text-center text-md-start">
  <div class="container">
    <div class="row mb-4">
      <div class="col-lg-8 col-md-8 align-self-center">
        <?php
        $short_title = get_theme_mod('auto_dealer_lite_featured_car_section_short_title', '');
        if (!empty($short_title)) : ?>
          <h2 class="text-uppercase"><?php echo esc_html($short_title); ?></h2>
        <?php endif; ?>
        
        <?php
        $main_title = get_theme_mod('auto_dealer_lite_featured_car_section_tittle', '');
        if (!empty($main_title)) : ?>
          <h3 class="text-uppercase"><?php echo esc_html($main_title); ?></h3>
        <?php endif; ?>
      </div>
      <div class="col-lg-4 col-md-4 align-self-center">
        <div class="car-button text-center text-md-end my-3 my-md-0">
          <?php
          $button_text = get_theme_mod('auto_dealer_lite_featured_car_button_text', '');
          $button_link = get_theme_mod('auto_dealer_lite_featured_car_button_link', '');
          if (!empty($button_text) && !empty($button_link)) : ?>
            <a href="<?php echo esc_url($button_link); ?>" class="my-3">
              <i class="fas fa-angle-right me-4"></i><?php echo esc_html($button_text); ?>
            </a>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="row">
      <?php
      $auto_dealer_lite_post_category = get_theme_mod('auto_dealer_lite_featured_car_section_category');
      $auto_dealer_lite_num_posts = get_theme_mod('auto_dealer_lite_num_posts', 2);

      if (!empty($auto_dealer_lite_post_category)) :
        $args = array(
          'category_name'  => esc_html($auto_dealer_lite_post_category),
          'posts_per_page' => absint($auto_dealer_lite_num_posts),
        );
        $auto_dealer_lite_page_query = new WP_Query($args);

        if ($auto_dealer_lite_page_query->have_posts()) :
          while ($auto_dealer_lite_page_query->have_posts()) :
            $auto_dealer_lite_page_query->the_post(); 
            $post_index = $auto_dealer_lite_page_query->current_post + 1; // Adjust for 1-based index
          ?>
            <div class="col-lg-6 col-md-6">
              <div class="cat-inner-box mb-3 p-3">
                <h4 class="mb-3 text-uppercase"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <?php
                $auto_dealer_lite_compare_price = get_theme_mod('auto_dealer_lite_compare_price' . $post_index, '');
                if (!empty($auto_dealer_lite_compare_price)) : ?>
                  <p class="cours-price"><?php echo esc_html($auto_dealer_lite_compare_price); ?></p>
                <?php endif; ?>
               
                <div class="row">
                  <div class="col-lg-8 col-md-7 align-self-center">
                    <?php if (has_post_thumbnail()) {
                      the_post_thumbnail();
                    } else { ?>
                      <img src="<?php echo esc_url($auto_dealer_lite_static_image); ?>" alt="<?php esc_attr_e('Default Image', 'auto-dealer-lite'); ?>">
                    <?php } ?>
                  </div>
                  <div class="col-lg-4 col-md-5 align-self-center">
                    <div class="featured-car-box">
                      <?php
                      $auto_dealer_lite_body_type = get_theme_mod('auto_dealer_lite_body_type' . $post_index, '');
                      if (!empty($auto_dealer_lite_body_type)) : ?>
                        <p><i class="fas fa-car me-2"></i><?php echo esc_html($auto_dealer_lite_body_type); ?></p>
                      <?php endif; ?>

                      <?php
                      $auto_dealer_lite_model_year = get_theme_mod('auto_dealer_lite_model_year' . $post_index, '');
                      if (!empty($auto_dealer_lite_model_year)) : ?>
                        <p><i class="fas fa-calendar-alt me-2"></i><?php echo esc_html($auto_dealer_lite_model_year); ?></p>
                      <?php endif; ?>

                      <?php
                      $auto_dealer_lite_engine_type = get_theme_mod('auto_dealer_lite_engine_type' . $post_index, '');
                      if (!empty($auto_dealer_lite_engine_type)) : ?>
                        <p><i class="fas fa-power-off me-2"></i><?php echo esc_html($auto_dealer_lite_engine_type); ?></p>
                      <?php endif; ?>

                      <?php
                      $auto_dealer_lite_car_color = get_theme_mod('auto_dealer_lite_car_color' . $post_index, '');
                      if (!empty($auto_dealer_lite_car_color)) : ?>
                        <p><i class="fas fa-tint me-2"></i><?php echo esc_html($auto_dealer_lite_car_color); ?></p>
                      <?php endif; ?>

                      <?php
                      $auto_dealer_lite_mileage = get_theme_mod('auto_dealer_lite_mileage' . $post_index, '');
                      if (!empty($auto_dealer_lite_mileage)) : ?>
                        <p><i class="fas fa-road me-2"></i><?php echo esc_html($auto_dealer_lite_mileage); ?></p>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_postdata();
        endif;
      endif;
      ?>
    </div>
  </div>
</section>
<?php endif; ?>